#--------dv---------------------About DataVision-------------------------------

#------------------------------------------------------------------------------
# multilabel {} simmuliert einen Label durch setzen der einzelnen
#                Buchstaben in einen Frame; dieser Frame muss noch gepackt
#                bzw. geplaced werden
#                path : Pfadname des Labels
#                args : ArgumentenListe des Labels                     
#------------------------------------------------------------------------------
#               
proc multilabel {path args} {

   # Nach Option -text suchen
   #
   set tindex [lsearch $args -text]

   # -text loeschen
   #
   lvarpop args $tindex 
 
   # Text des labels ermitten
   #
   set text [lindex $args $tindex]

   # Text aus der Argumentenliste loeschen
   #
   lvarpop args $tindex

   # Frame fuer Multilabel setzen
   #
   frame $path 

   # einzelne Buchstabenlabel setzen
   #
   set ltext [clength $text]
   loop i 0 $ltext {
     
      # Argumentliste des Multilabels an die einzelnen Buchstaben weitergeben
      #
      eval label $path.letter$i $args -text {[cindex $text $i]}
      pack $path.letter$i -side left
   }
}

#------------------------------------------------------------------------------
# mixmultilcolor {} veraendert die Farbe de einzelner Buchstaben eines
#                   multilabels
#                   Dabei werden Pseudozufallsfarben gesetzt
#                   path : Pfad des Multilabels
#------------------------------------------------------------------------------
#
proc mixmultilcolor {path} {

   # Pfadnamen der Buchstabenlabel ermitteln
   #
   set letters [winfo children $path]

   # alle Buchstabenlabel faerben
   #
   foreach letter $letters {
     
      # Pseudozufaelligen Startwert ermitteln
      # 
      set seed [random 0xffff]

      # Farbe ermitteln
      #
      set color [randomcolor $seed]

      # Label faerben
      #
      $letter config -foreground $color
   }
}

#------------------------------------------------------------------------------
# flashmultil {} veraendert jeweils nach mm Millisekunden einen Multilabel
#                path : Pfad des Multilabels
#                mm   : Zeitabstand, in dem der Multilabel veraendert wird 
#------------------------------------------------------------------------------
#
proc flashmultil {path mm} {

   # falls label nicht existiert flashroutine verlassen
   #
   if {![winfo exist $path]} {
      return
   }

   # Farbe der Buchstaben des Multilabels aendern
   # 
   mixmultilcolor $path

   # diese Routine nach mm Millisekunden wieder aufrufen
   #
   after $mm "flashmultil $path $mm"
}

#------------------------------------------------------------------------------
# dvabout {} erzeugt ein Fenster mit einigen Informationen ueber
#            DataVision
#            path : Pfad dieses Toplevels
#            dp   : aktueller Diagrammwidgetsatz --- zur Zeit unbenutzt
#------------------------------------------------------------------------------
#
proc dvabout {path dp} {

   # Statusvariablen sichtbar machen
   #
   global status

   # falls toplevel schon existiert, Fenster hervorheben
   #
   if {[winfo exist $path]} {
      myraise $path
      return
   }

   # toplevel erzeugen
   #
   toplevel $path
 
   # alten focus speichern und focus auf dieses Toplevelfenster
   #
   savefocus
   focus $path

   # Fenster Titel setzen
   #
   wm title $path "About"

   # Bitmap fuer icon setzen
   #
   global env
   wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
   wm iconname   $path "About" 
 
   # Rahmen fuer Titelzeilen
   #
   frame $path.titlelines
   pack $path.titlelines -pady 15

     # Text des About-Fensters erzeugen
     #
     multilabel $path.titlelines.head -text "DataVision"\
                      -font "-Adobe-times-bold-r-normal--*-240-*"\
                      -bd 5
     pack $path.titlelines.head

     label $path.titlelines.text1 -text "Version $status(version)"\
                      -font "-Adobe-times-bold-r-normal--*-180-*"
     pack $path.titlelines.text1

   # Rahmen fuer Author und MailAdresse
   #
   frame $path.author
   pack $path.author -pady 15
 
      label $path.author.name -text "programmed by Michael Boese in 1994"
      pack $path.author.name

      label $path.author.mailaddr -text "current email address :"
      pack $path.author.mailaddr
      label $path.author.mailaddr2 -text "boese@ipf.bau-verm.uni-karlsruhe.de"
      pack $path.author.mailaddr2

   # Instituts Suffix
   #
   frame $path.suffix
   pack $path.suffix -pady 15

     label $path.suffix.1 -text "I"\
                          -font "-Adobe-times-bold-r-normal--*-180-*"\
                          -bd 0
     label $path.suffix.2 -text "nstitut fuer "\
                          -bd 0
     label $path.suffix.3 -text "P"\
                          -font "-Adobe-times-bold-r-normal--*-180-*"\
                          -bd 0
     label $path.suffix.4 -text "hotogrammetrie und "\
                          -bd 0
     label $path.suffix.5 -text "F"\
                          -font "-Adobe-times-bold-r-normal--*-180-*"\
                          -bd 0
     label $path.suffix.6 -text "ernerkundung"\
                          -bd 0
     pack $path.suffix.1 $path.suffix.2 $path.suffix.3 $path.suffix.4\
          $path.suffix.5 $path.suffix.6\
          -side left

   # Ok - Button erzeugen
   #
   button $path.ok -text " OK " -command "destroy $path; setoldfocus"
   pack $path.ok -fill x

   # ReturnTaste wie Ok-Knopf Betaetigung
   #
   lvarcat list [findentries $path] $path
   bindreturn $list "$path.ok invoke"

   # Farbe des Datavision Multilabels jeweils nach 10 Millisekunden aendern
   #
   flashmultil $path.titlelines.head 100
}
