########################################################################
#
# Copyright (c) 1994 John F. Sefler.
# All rights reserved.
#
########################################################################
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written
# agreement is hereby granted, provided the above copyright notice and
# the following two paragraphs appear in all copies of this software.
#
# IN NO EVENT SHALL JOHN F. SEFLER BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF HE HAS
# BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# JOHN F. SEFLER SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT
# NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
# "AS IS" BASIS, AND JOHN F. SEFLER HAS NO OBLIGATION TO PROVIDE
# MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
#
########################################################################

$w insert end {
Introduction
  The objective of Maze Man is to maneuver the man through a randomly generated maze from start to finish.  Although the paths through the maze are randomly generated, there are many features of the maze that you can set when practicing.  In general, the maze can be a three dimensional maze consisting of many levels between the start (located on the first level) and finish (located on the top level).  To get from one level to another, you take elevators.  Watch out for multi-colored ghosts as you traverse the maze.  They will temporarily stop you in your tracks and deduct points from your score when you are in competition.

Maneuvering Maze Man
  There are two ways to maneuver the man; using the mouse, and using the keyboard.  You can use either method at any time, or a combination of both.

  Using the Mouse:
    <Button-1> and drag	Moves the man through the maze.
    <Button-2> click	Takes the elevator going Up.
    <Button-3> click	Takes the elevator going Down.
    
  Note: When using the mouse, the best performance occurs by grabbing the man on the nose and dragging your cursor along the center of the path.  If you cross a wall with your cursor, the man will not move.  Also try the "Snap Mouse Motion" in the Options pull-down.

  Using the Keyboard (Default):
    <Up>		Moves the man upward.
    <Down>	Moves the man downward.
    <Left>		Moves the man to the left.
    <Right>	Moves the man to the right.
    <q>		Takes the elevator going Up.
    <z>		Takes the elevator going Down.
    <w>		View the maze level above the current level.
    <x>		View the maze level below the current level.
    <Return>	starts/pauses the game.

  Note: The keyboard bindings can be changed through the Key Bindings under Help.

Practice
  When playing a practice game, you are presented with many parameters with which to generate a random maze.  Different combinations of the parameters can make the game more difficult.

Maze Dimensions
  This parameter sets the two dimensional size of each level in the maze.  It sets the width and height in number of square segments.

Number of Levels
  This parameter sets the third dimensional size of the maze.  It sets the depth of the maze.  If the number of levels is 1, then the maze is considered a simple 2D maze.

Maximum Number of Elevators between Levels
  This parameter is used to set a maximum number elevators between the levels.  For example, if there are two elevators between floors, then there are only two places on that level to take an elevator up and only two places on that level to take an elevator down.  As number of elevators between floors increases, the difficulty of the maze increases.

Number of Loops per Level
  A loop is considered to be an alternative path to get from one point in the maze to another.  If there is one loop on a level of the maze, then there exists two locations on that level that the man can traverse two different paths to get to the same point.  In general, the maze is easier to solve when there are loops in the maze.  Likewise, it is easier to avoid ghosts with loops in the maze.

Number of Ghosts
  This simply sets the number of uniquely colored ghosts in the maze.  Watch out, the color of the last ghost blends in with the background.

Maximum Ghost Speed
  When this parameter is set to its maximum, one of the ghosts will move by taking one step between adjacent squares in the maze.  When set to its minimum, all the ghosts will take 10 steps between adjacent squares.  The speed of the ghosts is linearly distributed among the ghosts from the slowest speed to the maximum speed.

Competition
  After having some practice, you can attempt to complete a predefined set of mazes.  Each maze is called a stage.  Once you reach the finish of a stage, an increasingly more difficult stage is presented.  Completing all the stages will end the competition.  If you score well, you may become one of the Top 10 Maze Men.

Score
  To add to your score, you must complete the stage as quickly as possible.  When you reach the finish, the bonus points that remain are added to your score.  As always, avoid the ghosts since they will deduct from your score.

Bonus
  Each stage begins with a maximum set of bonus points equivalent to the number of squares in the 3D maze.  As each second goes by, the bonus depletes until there are no points left.  Unfortunately, you must still get to the finish in order to get to the next stage.
  
Options
  To help you solve the maze, the following options may be useful.

Show Solution Paths
  This option will show all the solution paths from the start to finish.  Remember that there may be more than one solution when the maze contains loops.  Unfortunatly, this option is not available when competing.  That wouldn't be fair.

Leave A Trail
  This option causes the man to leave a trailed marking in the path.  It may help you identify where you have already been when the maze gets large.  However, the ghosts don't like trails; they eat'em.

Snap Mouse Motion
  When using the mouse to drag the man through the maze, this option will cause the man to move as if you were using the keyboard bindings.

Key Bindings
  To customize the keyboard keys that you use to move the man, choose Key Bindings under the Help pull-down.  It will pop up a window showing the current key bindings.  Click on the key that you wish to change and hit the new key.  The new keyboard binding is immediately reflected in the dialog.

  Note: The keyboard bindings may not take affect until a new game begins.

Game Speed
  Unfortunately this game is inherently slow especially when there are many ghosts.  This has a significant impact on the felicity of maneuvering the man.  The speed of your computer also makes a big difference.  To help address this problem, I have given you the ability to change the game speed dynamically.  Actually, the game speed is a measure of the time delay between ghost steps.  As the time delay increases, the ghosts move slower, yet more cpu time is apportioned to maneuvering the man faster.  You will have to experiment to determine an optimal setting.

Top 10 Maze Men
  If you complete all the stages in a competition game and have one of the top ten scores, you will be prompted for your name.  It will then be added to the list of Top 10 Maze Men.  Wow!

Comments
  Send complaints/suggestions/comments/improvements to:
    sefler@eecs.berkeley.edu

  This program was a self-assigned class project.  Let me know if you get any enjoyment from it, or if I should have chosen a different class project.

  Regarding bugs, I already know of many.  Most of them concern the movement of the man.  To help address this problem, I gave you the ability to change the Game Speed dynamically.  Try it before sending me a complaint.

  I have found that Maze Man runs most satisfactorily on a fast machine such as an HP 700 series, DEC Alpha, or SGI Indigo.
}

# Introduction
$w tag add topic		2.0 3.0
$w tag add underline 		3.226 3.236
$w tag add "Practice" 		3.226 3.236
$w tag add underline 		3.618 3.629
$w tag add "Competition" 	3.618 3.629
$w tag add red		3.480 3.481
$w tag add magenta	3.481 3.482
$w tag add orange	3.482 3.483
$w tag add green	3.483 3.484
$w tag add cyan		3.484 3.485
$w tag add blue		3.485 3.486
$w tag add purple	3.486 3.487

# Maneuvering Maze Man
$w tag add topic	5.0 6.0

# Using the Mouse
$w tag add subtopic	8.0 9.0
$w tag add red		13.2 13.6
$w tag add underline 		13.248 13.255
$w tag add "Options" 		13.248 13.255

# Using the Keyboard
$w tag add subtopic	15.0 16.0
$w tag add red		26.2 26.6
$w tag add underline 		26.57 26.69
$w tag add "Key Bindings"	26.57 26.69

#Practice
$w tag add topic	28.0 29.0

# Maze Dimensions
$w tag add subtopic	31.0 32.0

# Number of Levels
$w tag add subtopic	34.0 35.0

# Maximum Number of Elevators
$w tag add subtopic	37.0 38.0

# Number of Loops per Level
$w tag add subtopic	40.0 41.0

# Number of Ghosts
$w tag add subtopic	43.0 44.0

# Maximum Ghost Speed
$w tag add subtopic	46.0 47.0

# Competition
$w tag add topic	49.0 50.0
$w tag add underline 		50.304 50.319
$w tag add "Top 10 Maze Men"	50.304 50.319

# Score
$w tag add subtopic	52.0 53.0

# Bonus
$w tag add subtopic	55.0 56.0

# Options
$w tag add topic	58.0 59.0

# Show Solution Paths
$w tag add subtopic     61.0 62.0

# Leave A Trail
$w tag add subtopic     64.0 65.0

# Snap Mouse Motion
$w tag add subtopic     67.0 68.0

# Key Bindings
$w tag add subtopic	70.0 71.0
$w tag add red		73.2 73.6

# Game Speed
$w tag add subtopic	75.0 76.0

# Top 10 Maze Men
$w tag add topic	78.0 79.0
$w tag add italic	79.183 79.187

# Comments
$w tag add topic	81.0 82.0
$w tag add courier	83.0 84.0
$w tag add underline	87.157 87.167
$w tag add "Game Speed"	87.157 87.167



# Help Topics
$m add command -label "Introduction"		-command "$w yview 1"
$m add command -label "Maneuvering Maze Man"	-command "$w yview 4"
$m add command -label "Practice"		-command "$w yview 27"
$m add command -label "Competition"		-command "$w yview 48"
$m add command -label "Options"			-command "$w yview 57"
$m add command -label "Key Bindings"		-command "$w yview 69"
$m add command -label "Game Speed"		-command "$w yview 74"
$m add command -label "Top 10 Maze Men"		-command "$w yview 77"
$m add command -label "Comments"		-command "$w yview 80"

$w tag bind "Introduction"		<ButtonPress-1> "$w yview 1"
$w tag bind "Maneuvering Maze Man"	<ButtonPress-1> "$w yview 4"
$w tag bind "Practice"			<ButtonPress-1> "$w yview 27"
$w tag bind "Competition"		<ButtonPress-1> "$w yview 48"
$w tag bind "Options"			<ButtonPress-1> "$w yview 57"
$w tag bind "Key Bindings"		<ButtonPress-1> "$w yview 69"
$w tag bind "Game Speed"		<ButtonPress-1> "$w yview 74"
$w tag bind "Top 10 Maze Men"		<ButtonPress-1> "$w yview 77"
$w tag bind "Comments"			<ButtonPress-1> "$w yview 80"

# setting default configurations for entire text widget
$w configure -wrap word
$w configure -state disabled
$w configure -cursor hand1
set font [GetNearestFontFromPixels helvetica medium r 17]
$w configure -font $font
$w configure -foreground black -background white

# "topic" tag configurations
set font [GetNearestFontFromPixels helvetica bold r 24]
$w tag configure topic -font $font

# "subtopic" tag configurations
set font [GetNearestFontFromPixels helvetica bold r 17]
$w tag configure subtopic -font $font

# "italic" tag configurations
set font [GetNearestFontFromPixels helvetica medium o 17]
$w tag configure italic -font $font

# "underline" tag configurations
$w tag configure underline -underline true

# "courier" tag configurations
set font [GetNearestFontFromPixels courier medium r 20]
$w tag configure courier -font $font

# color tag configurations
$w tag configure black		-foreground black
$w tag configure white		-foreground white -background black
$w tag configure red		-foreground red
$w tag configure orange		-foreground orange
$w tag configure yellow		-foreground yellow
$w tag configure green		-foreground green
$w tag configure blue		-foreground blue
$w tag configure purple		-foreground purple
$w tag configure cyan		-foreground cyan
$w tag configure magenta	-foreground magenta


