
defwidget Entry

defmethod Entry new {name args} {

  args	textfont text layout {width 16} action max filter

  if { $textfont == "" } {
    set textfont text
  }

  entry $name \
	-font [Font slot $textfont] \
	-foreground [Color slot fg] \
	-background [Color slot bg] \
	-selectbackground [Color slot bg,active] \
	-selectforeground [Color slot fg,active] \
	-relief sunken -width ${width} \
	-insertborderwidth 0

  $name insert 0 $text

  Entry instantiate $name $layout [list \
	[list max $max] \
	[list action [$self buildAction $action $name]] \
	[list filter $filter] \
	]

  $name bindings

  return $name
}

defmethod Entry get {} {
  $self! get
}

defmethod Entry set {text} {

  catch {$self! delete 0 end}
  set max [$self slot max]
  if { $max != {} && [string length $text] > $max } {
    set text [string range $text 0 [expr $max-1]]
  }
  $self! insert 0 $text
}

defmethod Entry keypress {code} {

  if { $code == "" } {
    return
  }

  set max [$self slot max]
  set filter [$self slot filter]

  if { $filter != {} } {
    set code [eval [concat $filter [list $code]]]
    if { $code == "" } {
      return
    }
  }

  if { $max == "" || [string length [$self! get]] < $max } {
    $self! insert insert $code
    $self see_caret
  }
}

defmethod Entry erase {} {

  catch {$self! delete 0 end}
}

defmethod Entry backspace {} {

  set pos [expr {[$self! index insert]-1}]
  if { $pos >= 0 } {
    $self! delete $pos
  }
  $self see_caret
}

defmethod Entry see_caret {} {

  set c [$self! index insert]

  set left [$self! index @0]
  if { $left > $c } {
    $self! view $c
    return
  }
  while {([$self! index @[expr [winfo width $self]-5]] < $c) && ($left < $c)} {
    set left [expr $left+1]
    $self! view $left
  }
}

defmethod Entry delete {} {

  catch {$self! delete sel.first sel.last}
  $self see_caret
}

defmethod Entry action {} {

  set action [$self slot action]
  if { $action != {} } then {
    uplevel #0 [concat $action [list [$self! get]]]
  }
}

defmethod Entry position {where} {
  $self! icursor $where
  $self see_caret
}

defmethod Entry insert {string} {
  $self! insert insert $string
  $self see_caret
}

#---------------------------------------------------------------------------

defmethod Entry bindings {} {

  bind $self <Any-KeyPress> [list %W keypress %A]
  
  bind $self <BackSpace> [list %W backspace]
  bind $self <Delete> [list %W backspace]
  bind $self <Control-h> [list %W backspace]
  bind $self <Control-d> [list %W delete]
  bind $self <Control-u> [list %W erase]
  
  bind $self <Control-a> [list %W position 0]
  bind $self <Control-e> [list %W position end]
  
  bind $self <Key-Return> [list %W action]
  
  bind $self <1> {
    %W! icursor @%x
    %W! select from @%x
    if { [lindex [%W! config -state] 4] == "normal" } {
      focus %W
    }
  }
  
  bind $self <B1-Motion> {
    %W! select to @%x
  }
  
  bind $self <Shift-1> {
    %W! select adjust @%x
  }
  
  bind $self <Shift-B1-Motion> {
    %W! select to @%x
  }
  
  bind $self <2> {
    %W! scan mark %x
  }
  
  bind $self <B2-Motion> {
    %W! scan dragto %x
  }
  
}
