#
#	This is a crude hack to display the scaled image of a country.
#	The outline is given as vector coordinates.

defmethod Country new {name args} {

  args	{factor 1} layout {country Germany} cities action

  set action [$self buildAction $action $name]

  if { [streq [info command $country] {}] } {
    source [the(image) $country canvas]
    $country boundary
  }

  Canvas new $name \
	-width [expr $factor*[$country slot maxx]] \
	-height [expr $factor*[$country slot maxy]] \
	-layout $layout

  defsuper $name Country
  $name slot country $country
  $name slot factor $factor
  $name slot cities [streq $cities "true"]

  $name bind Country <1> [list $name countrySelect %x %y]
  $name bind Country(city) <1> [list $name citySelect $action]

  $name redisplay

  return $name
}

defmethod Country boundary {} {

  if { ![streq [$self slot maxx] {}] } {
    return
  }

  set minx 99999; set miny 99999
  set maxx 0; set maxy 0
  set xcoord 1
  foreach z [$self slot coordinates] {
    if { $xcoord } {
      set xcoord 0
      if { $z < $minx } {
	set minx $z
      } elseif { $z > $maxx } {
	set maxx $z
      }
    } {
      set xcoord 1
      if { $z < $miny } {
	set miny $z
      } elseif { $z > $maxy } {
	set maxy $z
      }
    }
  }

  if { [expr $maxx-$minx] < [expr $maxy-$miny] } {
    set scale [expr $maxy-$miny]
  } {
    set scale [expr $maxx-$minx]
  }

  set coords {}
  set xcoord 1
  foreach z [$self slot coordinates] {
    if { $xcoord } {
      set xcoord 0
      lappend coords [expr ($z-$minx)*90.0/$scale+5]
    } {
      set xcoord 1
      lappend coords [expr ($z-$miny)*90.0/$scale+5]
    }
  }
  $self slot coordinates $coords

  set newpos {}
  foreach city [$self slot positions] {
    lappend newpos [list \
			[lindex $city 0] \
			[expr ([lindex $city 1]-$minx)*90.0/$scale+5] \
			[expr ([lindex $city 2]-$miny)*90.0/$scale+5] \
			[lindex $city 3] \
			[lindex $city 4] \
			]
  }
  $self slot positions $newpos

  $self slot maxx [expr ($maxx-$minx)*90.0/$scale+10]
  $self slot maxy [expr ($maxy-$miny)*90.0/$scale+10]

  return $self
}

defmethod Country redisplay {} {

  set pos(s) -1
  set pos(n) 1
  set pos(w) 1
  set pos(e) -1
  set pos() 0

  $self delete Country
  $self delete Country(city)
  set bits @[the(image) country-gray]

  set list [[$self slot country] slot coordinates]

  eval [concat \
	[list $self create polygon] \
	$list \
	[list -stipple $bits -tags Country]]

  eval [concat \
	[list $self create line] \
	$list [lindex $list 0] [lindex $list 1] \
	[list -fill black -tags Country -width 2]]

  if { [$self slot cities] } {
    foreach city [[$self slot country] slot positions] {

      set name [lindex $city 0]
      set x [lindex $city 1]
      set y [lindex $city 2]
      set ypos [lindex $city 3]
      set xpos [lindex $city 4]

      $self create rectangle \
	[expr $x-.7] [expr $y-.7] [expr $x+.7] [expr $y+.7] \
	-fill [Color slot bg,alert] \
	-tags [list Country(city) [concat cityname $name]]
      $self create text \
	[expr $x+0.7*$pos($xpos)] \
	[expr $y+0.7*$pos($ypos)] \
	-anchor ${ypos}${xpos} -text $name -font [Font slot smallbold] \
	-tags [list Country(city)]
    }
  }

  set factor [$self slot factor]
  if { ![streq $factor "1"] } {
    $self scale Country 0 0 $factor $factor
    $self scale Country(city) 0 0 $factor $factor
  }

  return $self
}

defmethod Country countrySelect {x y} {
}

defmethod Country citySelect {action} {

  set id [$self find withtag current]
  set tags [$self gettags $id]
  set name [assoc cityname $tags]
  if { [streq $name {}] } {
    incr id -1
    set tags [$self gettags $id]
    set name [assoc cityname $tags]
    if { [streq $name {}] } {
      incr id -1
      set tags [$self gettags $id]
      set name [assoc cityname $tags]
    }
  }
  if { ![streq $name {}] } {
    eval [concat $action [list $name]]
  }
}

Window addDemo Country

defmethod Country demo {} {

  set top [Toplevel new *]
  Country new *$top \
	-factor 6 \
	-country Germany \
	-layout top \
	-cities true \
	-action {- showAction}
  $top layout +100+100
}
