# 
# Brainstorm Conference Application
# ---------------------------------
#
# This program is a very simple anonymous group brainstorming tool, where
# users can enter an "idea" and it will appear on all users' screens.  To
# be practical it needs routines to e.g. save the ideas to a file.
#

#source ~marwood/work/tcl-path/tcl-path.tcl
#source [SearchTCLPath conf.tcl]
#source [SearchTCLPath errors.tcl]
#source [SearchTCLPath gkwidgets.tcl]

initConf $argv


#
# create the interface; a listbox displaying the ideas, and an entry for
# new ideas
#

gkDefaultMenu .menu
listbox .list 
frame .f
entry .f.entry -textvariable fooey -relief sunken
button .f.b -text Enter -command { doit }
pack append .f .f.entry left .f.b left
pack append . .menu {top fillx} .list {top fillx} .f top
bind .f.entry <Return> "doit"
bind .list <Return> "doit"

#
# when the new idea should be entered, put it in the local list and then
# tell everyone else about it
#

proc doit {} { global fooey others
    .list insert end $fooey
    foreach i $others {	RDO [keylget i filedesc] .list insert end $fooey  }
    set fooey ""
}

