'\"
'\" Upgrades to Tk8
'\" Copyright (c) 1998-1999 Jeffrey Hobbs
'\"
'\" Copyright (c) 1995 Marco Beijersbergen (beijersb@rulhm1.leidenuniv.nl)
'\" See the file "license.terms" for information on usage and
'\" redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" Based upon scale.n of the tk4.0 package:
'\"   Copyright (c) 1990-1994 The Regents of the University of California.
'\"   Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\" 
'\" @(#) dial.n 2.0 Oct 16 98
'\" 
.TH dial n 2.0 Tk "Tk dial extension"
.HS dial meter Tk
.BS
.SH NAME
dial \- Create and manipulate dial widgets
.SH SYNOPSIS
\fBdial\fI \fIpathName \fR?\fIoptions\fR?
.SO
\-activebackground	\-background	\-borderwidth
\-cursor	\-font	\-foreground
\-highlightbackground	\-highlightcolor	\-highlightthickness
\-relief
\-repeatdelay	\-repeatinterval	\-takefocus
.SE

.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-beginangle beginAngle BeginAngle
The angle at which the scale of the dial will start. The value is in
degrees. Zero is at the top and the angle increases clockwise, just like a
compass. If you want the scale to start at the left, use a negative value,
not the value above 180 degrees.
.OP \-bigincrement bigIncrement BigIncrement
Some interactions with the dial cause its value to change by
``large'' increments;  this option specifies the size of the
large increments.  If specified as 0, the large increments default
to 1/10 the range of the dial.
.OP \-command command Command
Specifies the prefix of a Tcl command to invoke whenever the dial's value
is changed via a widget command.  The actual command consists of this
option followed by a space and a real number indicating the new value of
the dial.
.OP \-constrainvalue constrainValue ConstrainValue
Specifies whether the value for the dial should be constrained to the
given \fBfrom\fR and \fBto\fR values and the \fBresolution\fR.  If true,
the it is limited to the value range and to the nearest resolution.
Otherwise, only the displayed value (which is always constrained)
is constrained.  Defaults to 0.
.OP \-dialborderwidth dialBorderWidth DialBorderWidth
Specifies the border width for the inner dial.  Defaults to 3.
.OP \-dialcolor dialColor DialColor
Specifies the color for the inner dial.  Defaults to the normal background.
.OP \-dialrelief dialRelief DialRelief
Specifies the relief for the inner dial.  Defaults to the raised.
.OP \-digits digits Digits
An integer specifying how many significant digits should be retained
when converting the value of the dial to a string.
If the number is less than or equal to zero, then the dial picks
the smallest value that guarantees that every possible dial
position prints as a different string.
.OP \-endangle endAngle EndAngle
The angle at which the scale of the dial will end. The
value is in degrees. Zero is at the top and the angle increases
clockwise, just like a compass.
.OP \-from from From
A real value corresponding to the counterclockwise-most end of the dial.
.OP \-label label Label
A string to display as a label for the dial.
The label is displayed above the dial.  If the option is specified
as an empty string, no label is displayed.
.OP \-needlecolor needleColor NeedleColor
Specifies the color for the needle.  Defaults to black.
.OP \-needletype needleType NeedleType
Specifies a type for the needle: \fBarc\fR, \fBline\fR, or \fBtriangle\fR.
\fBarc\fR draws the needle as a filled arc from the \fBfrom\fR value to
the current value.  \fBline\fR draws the needle as a thick line at the
value.  \fBtriangle\fR draws the needle as a thin triangle at the value
(compass style).  Defaults to \fBline\fR.
.OP \-minortickinterval minorTickInterval MinorTickInterval
Must be a real value.  Determines the spacing between minor tick marks,
those without a numerical value or tag. These ticks are also slightly
smaller.  If 0 (default), no minor tick marks will be displayed.  See
\fBtickinterval\fR for more details.
.OP \-radius radius Radius
Specifies the desired radius of the central dial of the dial in
screen units (i.e. any form acceptable to Tk_GetPixels).
.OP \-resolution resolution Resolution
A real value specifying the resolution for the dial.
If this value is greater than zero then the dial's value will always be
rounded to an even multiple of this value, as will tick marks and
the endpoints of the dial.  If the value is less than zero then no
rounding occurs.  Defaults to 1 (i.e., the value will be integral).
.OP \-showvalue showValue ShowValue
Specifies a boolean value indicating whether or not the current
value of the dial is to be displayed.
.OP \-showtags showTags ShowTags
Specifies which tags to display at normal tick marks on the dial:
\fBvalue\fR (default), \fBlabel\fR, \fBboth\fR, or \fBnone\fR.  If
\fBvalue\fR, then the value is always displayed.  If \fBlabel\fR, then only
labels specified by the \fBtag\fR command are displayed.  \fBall\fR refers
to both of the above, and \fBnone\fR causes neither to be displayed.
.OP \-state state State
Specifies one of three states for the dial: \fBnormal\fR, \fBactive\fR, or
\fBdisabled\fR.  If the dial is disabled then the value may not be changed
and the dial won't activate.  If the dial is active, the dial is displayed
using the color specified by the \fBactiveBackground\fR option.
.OP \-tickcolor tickColor TickColor
Specifies the color to be used for the ticks.  Defaults to black.
.OP \-tickinterval tickInterval TickInterval
Must be a real value.  Determines the spacing between tick marks displayed
with their numeric value or a tag around the dial.  This spacing is
calculated at \fBtickinterval\fR counts around the dial between the
\fBfrom\fR and \fBto\fR values.  If \fBfrom\fR is 0.0 and \fBto\fR is
100.0, then a \fBtickinterval\fR of 10.0 will place 11 ticks (at 0.0, 10.0,
20.0, ...) on the dial.  If 0 (default), no tick marks will be displayed.
.OP \-tickwidth tickWidth TickWidth
Specifies the width of the line that ticks are displayed with.  0, the
default, means a simple line.  If you don't wish to display ticks, set
the tick intervals to 0.
.OP \-to to To
Specifies a real value corresponding to the clockwise-most end of the dial.
This value may be either less than or greater than the \fBfrom\fR option.
.OP \-variable variable Variable
Specifies the name of a global variable to link to the dial.  Whenever the
value of the variable changes, the dial will update to reflect this value.
Whenever the dial is manipulated interactively, the variable will be
modified to reflect the dial's new value.
.PP
Further options are handled by the dial widget in order to maintain
100% compatibility with the scale widget.  These options are not
guaranteed to translate correctly for use by the dial, but they will
not cause an error in code.
.BE

.SH DESCRIPTION
.PP
The \fBdial\fR command creates a new window (given by the \fIpathName\fR
argument) and makes it into a dial widget.  Additional options, described
above, may be specified on the command line or in the option database to
configure aspects of the dial such as its colors and relief.  The
\fBdial\fR command returns its \fIpathName\fR argument.  At the time this
command is invoked, there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A dial is a widget that displays a circular \fIdial\fR with a small
\fImark\fR. The position of the dial selects a particular real value of the
scale which is determined by the \fBfrom\fR, \fBto\fR, and \fBresolution\fR
options.  The dial may be turned (and hence the dial's value changed) with
the mouse or keyboard as described in the BINDINGS section below.  Whenever
the dial's value is changed, a Tcl command is invoked (using the
\fBcommand\fR option) to notify other interested widgets of the change.  In
addition, the value of the dial can be linked to a Tcl variable (using the
\fBvariable\fR option), so that changes in either are reflected in the
other.  The dial is modelled after the Tk \fBscale\fR widget and is 100%
compatible with the commands and options for a scale.
.PP
Five annotations may be displayed in a dial widget: a label appearing at
the top left of the widget, a number displaying the current value just
below the dial, a collection of major tick marks, numerical or string
labels next to the major tick marks and a collection of minor tick
marks. Each of these five annotations may be enabled or disabled using the
configuration options.

.SH "WIDGET COMMAND"
.PP
The \fBdial\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations on
the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for dial widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given by
\fIoption\fR.  \fIOption\fR may have any of the values accepted by the
\fBdial\fR command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBdial\fR
command.
.TP
\fIpathName \fBcoords\fR \fR?\fIvalue\fR?
Returns a list whose elements are the x and y coordinates of
the point along the radius of the dial  that corresponds
to \fIvalue\fR.
If \fIvalue\fR is omitted then the dial's current value is used.
.TP
\fIpathName \fBget\fR ?\fIx y\fR?
If \fIx\fR and \fIy\fR are omitted, returns the current value
of the dial.  If \fIx\fR and \fIy\fR are specified, they give
pixel coordinates within the widget;  the command returns
the dial value corresponding to the given pixel.
.TP
\fIpathName \fBidentify\fR \fIx y\fR
Returns a string indicating what part of the dial lies under
the coordinates given by \fIx\fR and \fIy\fR.
A return value of \fBdial\fR means that the point is over
the dial;  \fBleft\fR means that the point is to the left of the
dial, and \fBright\fR means that the point is to the right of the dial.
.TP
\fIpathName \fBlabel\fR ?\fI\-constrain\fR? ?\fIvalue\fR? ?\fIstring\fR? ?\fIvalue string ...\fR?
This command will associate a string label with a specific value.  The
value should correspond to a major tick value.  It is important that the
correct resolution is used for the value (constrained by the
\fBtickinterval\fR), as the label will otherwise not be shown.  You can use
the \fI\-constrain\fR option to cause the given value to be constrained to
a valid tick value, ensuring that the label will be displayed.  This means
that given values are open to be changed.  Constraining is bound to the
current value of \fBtickinterval\fR.  When this value changes, so would the
constraints.  However, constrained tags are not tracked to the change in
\fBtickinterval\fR, so changing that could cause tags to not be displayed.
All the known labels can be seen when no arguments are given.  If only a
value is given, then the label for that value will be shown, if any.
Otherwise, each given value will be assigned the given string.  Labels are
shown when specified by the \fBshowtags\fR option.
\fIpathName \fBset\fR ?\fIvalue\fR?
This command is invoked to change the current value of the dial, and hence
the orientation of the dial.  \fIValue\fR gives the new value for the dial.
If no value is given, this behaves like a get and simply returns the
current value of the dial.  The set command has no effect if the dial is
disabled.

.SH BINDINGS
.PP
Tk automatically creates class bindings for dials that give them
the following default behavior.
.IP [1]
If button 1 is pressed at the area around the dial,
the dial's value will be incremented or decremented by
the value of the \fBresolution\fR
option. If you press left of the dial, the dial will turn counterclockwise; 
if you press at the right it turns clockwise.
If the button is held down, the action auto-repeats.
.IP [2]
If button 1 is pressed over the dial, the dial is turned towards the
mouse cursor. If the button is held down, the dial orientation can be
dragged with the mouse.
.IP [3]
If button 1 is pressed at the surrounding with the Control key down,
the dial turns all the way to the end of its range. If the cursor was at
the left, it goes to the lower limit; if it was at the right, it goes to the
upper limit.
.IP [4]
The Down and Left keys turn the dial counterclockwise by the value
of the \fBresolution\fR option.
.IP [5]
The Up and Right keys turn the dial clockwise by the value
of the \fBresolution\fR option.
.IP [6]
Control-Down and Control-Left turn the dial counterclockwise by the
value of the \fBbigIncrement\fR option.
.IP [7]
Control-Up and Control-Right turn the dial clockwise by the
value of the \fBbigIncrement\fR option.
.IP [8]
Home turns the dial to the lower end of its range.
.IP [9]
End moves the dial to the higher end of its range.
.PP
If the dial is disabled using the \fBstate\fR option then
none of the above bindings have any effect.
.PP
The behavior of dials can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
dial, widget
