
/*
 * blt.h --
 *
 *	Copyright 1991-2004 George A Howlett.
 *
 *	Permission is hereby granted, free of charge, to any person
 *	obtaining a copy of this software and associated documentation
 *	files (the "Software"), to deal in the Software without
 *	restriction, including without limitation the rights to use,
 *	copy, modify, merge, publish, distribute, sublicense, and/or
 *	sell copies of the Software, and to permit persons to whom the
 *	Software is furnished to do so, subject to the following
 *	conditions:
 *
 *	The above copyright notice and this permission notice shall be
 *	included in all copies or substantial portions of the
 *	Software.
 *
 *	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 *	KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 *	PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
 *	OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *	OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 *	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 *	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _BLT_H
#define _BLT_H

#define BLT_MAJOR_VERSION 	3
#define BLT_MINOR_VERSION 	0
#define BLT_VERSION		"3.0"
#define BLT_PATCH_LEVEL		"3.0a"
#define BLT_RELEASE_SERIAL	0

#include <tcl.h>

#ifndef EXPORT
#define EXPORT
#endif

#undef EXTERN

#ifdef __cplusplus
#   define EXTERN extern "C" EXPORT
#else
#   define EXTERN extern EXPORT
#endif

#ifndef _ANSI_ARGS_
#   define _ANSI_ARGS_(x)       ()
#endif

#include <bltVector.h>
#include <bltHash.h>

typedef void *(Blt_MallocProc) (size_t size);
typedef void *(Blt_ReallocProc) (void *ptr, size_t size);
typedef void (Blt_FreeProc) (void *ptr);

EXTERN void Blt_AllocInit _ANSI_ARGS_((Blt_MallocProc *mallocProc, 
	Blt_ReallocProc *reallocProc, Blt_FreeProc *freeProc));

typedef char *Blt_Uid;

EXTERN Blt_Uid Blt_GetUid _ANSI_ARGS_((char *string));
EXTERN void Blt_FreeUid _ANSI_ARGS_((Blt_Uid uid));
EXTERN Blt_Uid Blt_FindUid _ANSI_ARGS_((char *string));

EXTERN int Blt_GetArrayFromObj _ANSI_ARGS_((Tcl_Interp *interp, 
	Tcl_Obj *objPtr, Blt_HashTable **tablePtrPtr));
EXTERN Tcl_Obj *Blt_NewArrayObj _ANSI_ARGS_((int objc, Tcl_Obj *objv[]));
EXTERN void Blt_RegisterArrayObj _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int Blt_IsArrayObj _ANSI_ARGS_((Tcl_Obj *obj));

EXTERN int Blt_Init _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int Blt_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));

#endif /*_BLT_H*/
