#!/usr/bin/perl

package eBay::API::XML::BaseCallGen;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BaseCallGen.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::BaseCallGen

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::BaseCallGen inherits from the L<eBay::API::XML::BaseXml> class

=cut

use eBay::API::XML::BaseXml;
our @ISA = ("eBay::API::XML::BaseXml");

=head1 Subroutines:

=cut

#
# INPUT properties (request)
#

=head2 getRequestBotBlock()

Container for a token and for user input.

#    Returns: 'ns:BotBlockRequestType'

=cut
       
sub getRequestBotBlock {
   my $self = shift;
   return $self->getRequestDataType()->getBotBlock();
}
=head2 setRequestBotBlock()

#    Argument: 'ns:BotBlockRequestType'

=cut
       
sub setRequestBotBlock {
   my $self   = shift;
   my $pBotBlock = shift;
   $self->getRequestDataType()->setBotBlock($pBotBlock);
}

=head2 getDetailLevel()

Detail levels are instructions that define standard subsets of
data to return for particular data components (e.g., each
Item, Transaction, or User) within the response payload.
For example, a particular detail level might cause the
response to include buyer-related data in every result
(e.g., for every Item), but no seller-related data.
Specifying a detail level is like using a
predefined attribute list in the SELECT clause of an SQL query.
Use the DetailLevel element to specify the required detail level
that the client application needs pertaining to the data components
that are applicable to the request.<br>
<br>
The DetailLevelCodeType defines the
global list of available detail levels for all request types.
Most request types support certain detail
levels or none at all. If you pass a detail level that exists
in the schema but that isn't valid for a particular request,
eBay ignores it processes the request without it.
For each request type, see the detail level tables in the
Input/Output Reference to determine which detail levels are
applicable and which elements are returned for each applicable
detail level. (Some detail level tables are still in the
eBay Web Services guide. They will be moved to the
Input/Output Reference in a future release.)<br>
<br>Note that DetailLevel is required input for
GetMyMessages. <br>
<br>
With GetSellerList and other calls that retrieve large data sets,
please avoid using ReturnAll when possible. For example, if you use
GetSellerList, use a GranularityLevel or use the
GetSellerEvents call instead. If you do use ReturnAll with
GetSellerList, use a small EntriesPerPage value and a short
EndTimeFrom/EndTimeTo range for better performance.

#    Returns: reference to an array  
                      of 'ns:DetailLevelCodeType'

=cut
       
sub getDetailLevel {
   my $self = shift;
   return $self->getRequestDataType()->getDetailLevel();
}
=head2 setDetailLevel()

#    Argument: reference to an array  
                      of 'ns:DetailLevelCodeType'

=cut
       
sub setDetailLevel {
   my $self   = shift;
   my $sDetailLevel = shift;
   $self->getRequestDataType()->setDetailLevel($sDetailLevel);
}

=head2 getEndUserIP()

The public IP address of the machine from which the request is sent.
Your application captures that IP address and includes it in
a call request. eBay evaluates requests for safety (also see
the BotBlock container
in the request and response of this call).

#    Returns: 'xs:string'

=cut
       
sub getEndUserIP {
   my $self = shift;
   return $self->getRequestDataType()->getEndUserIP();
}
=head2 setEndUserIP()

#    Argument: 'xs:string'

=cut
       
sub setEndUserIP {
   my $self   = shift;
   my $sEndUserIP = shift;
   $self->getRequestDataType()->setEndUserIP($sEndUserIP);
}

=head2 getErrorHandling()

Error tolerance level for the call. This is a preference
that specifies how eBay should handle requests that contain
invalid data or that could partially fail. This gives you some control
over whether eBay returns warnings or blocking errors
and how eBay processes the invalid data.<br>
<br>
For AddItem and related calls, this field is only applicable when
the listing includes Item Specifics and Pre-filled Item Information
(such as AttributeSetArray and ProductListingDetails).

#    Returns: 'ns:ErrorHandlingCodeType'

=cut
       
sub getErrorHandling {
   my $self = shift;
   return $self->getRequestDataType()->getErrorHandling();
}
=head2 setErrorHandling()

#    Argument: 'ns:ErrorHandlingCodeType'

=cut
       
sub setErrorHandling {
   my $self   = shift;
   my $sErrorHandling = shift;
   $self->getRequestDataType()->setErrorHandling($sErrorHandling);
}

=head2 getErrorLanguage()

Use ErrorLanguage to return error strings for the call in a different language
from the language commonly associated with the site that the requesting user
is registered with. Specify the standard RFC 3066 language identification tag
(e.g., en_US).
<br>
ID--- country<br>
----- -----<br>
de_AT Austria<br>
de_CH Switzerland<br>
de_DE Germany <br>
en_AU Australia <br>
en_CA Canada <br>
en_GB United Kingdom<br>
en_SG Singapore<br>
en_US United States <br>
es_ES Spain <br>
fr_BE Belgium (French)<br>
fr_CA Canada (French) <br>
fr_FR France <br>
it_IT Italy <br>
nl_BE Belgium (Dutch)<br>
nl_NL Netherlands <br>
zh_CN China<br>
en_IN India<br>
en_IE Ireland<br>
zh_HK Hong Kong

#    Returns: 'xs:string'

=cut
       
sub getErrorLanguage {
   my $self = shift;
   return $self->getRequestDataType()->getErrorLanguage();
}
=head2 setErrorLanguage()

#    Argument: 'xs:string'

=cut
       
sub setErrorLanguage {
   my $self   = shift;
   my $sErrorLanguage = shift;
   $self->getRequestDataType()->setErrorLanguage($sErrorLanguage);
}

=head2 getInvocationID()

A unique identifer for a particular call. If the same InvocationID is passed
in after it has been passed in once on a call that succeeded for a particular
application and user, then an error will be returned. The identifier can
only contain digits from 0-9 and letters from A-F. The
identifier must be 32 characters long.  For example,
1FB02B2-9D27-3acb-ABA2-9D539C374228.

#    Returns: 'ns:UUIDType'

=cut
       
sub getInvocationID {
   my $self = shift;
   return $self->getRequestDataType()->getInvocationID();
}
=head2 setInvocationID()

#    Argument: 'ns:UUIDType'

=cut
       
sub setInvocationID {
   my $self   = shift;
   my $pInvocationID = shift;
   $self->getRequestDataType()->setInvocationID($pInvocationID);
}

=head2 getMessageID()

In most cases, all calls support a MessageID element in the request and a
CorrelationID element in the response. If you pass a message ID in a request,
we will return the same value in CorrelationID in the response. You can use
this for tracking that a response is returned for every request and to match
particular responses to particular requests. If you do not pass MessageID in
the request, CorrelationID is not returned. <br>
<br>
<span class="tablenote"><b>Note:</b>
GetCategories, GetAttributesCS, GetCategory2CS, GetAttributesXSL,
GetProductFinder, GetProductFinderXSL, and GetProductSearchPage
are designed to retrieve very large sets of metadata
that change once a day or less often. To improve performance,
these calls return cached responses when you request all available data
(with no filters). When this occurs, the MessageID and CorrelationID
fields aren't applicable.
However, if you specify an input filter to reduce the amount of data
returned, the calls retrieve the latest data (not cached).
When this occurs, MessageID and CorrelationID are applicable.
</span>

#    Returns: 'xs:string'

=cut
       
sub getMessageID {
   my $self = shift;
   return $self->getRequestDataType()->getMessageID();
}
=head2 setMessageID()

#    Argument: 'xs:string'

=cut
       
sub setMessageID {
   my $self   = shift;
   my $sMessageID = shift;
   $self->getRequestDataType()->setMessageID($sMessageID);
}

=head2 getOutputSelector()

You can use the OutputSelector field to restrict the data returned by this call.
When you make a call such as GetItem that retrieves data from eBay,
the OutputSelector field is useful for restricting the data returned.
This field makes the call response easier to use, especially when a large payload
would be returned. If you use the OutputSelector field, the output data
will include only the fields you specified in the request.
For example, if you are using GetItem and you want the item data
in the response to be restricted to the ViewItemURL
(the URL where a user can view the listing) and BuyItNowPrice, then
within the GetItem request, specify those output fields.
To use this field, see the information at the following link.

#    Returns: reference to an array  
                      of 'xs:string'

=cut
       
sub getOutputSelector {
   my $self = shift;
   return $self->getRequestDataType()->getOutputSelector();
}
=head2 setOutputSelector()

#    Argument: reference to an array  
                      of 'xs:string'

=cut
       
sub setOutputSelector {
   my $self   = shift;
   my $sOutputSelector = shift;
   $self->getRequestDataType()->setOutputSelector($sOutputSelector);
}

=head2 getRequesterCredentials()

Authentication information for the user on whose behalf the application is
making the request. Only registered eBay users are allowed to make API calls. To
verify that a user is registered, your application needs to pass a user-specific
value called an "authentication token" in the request. This is equivalent to
signing in on the eBay Web site. As API calls do not pass session information,
you need to pass the user's authentication token every time you invoke a call on
their behalf. All calls require an authentication token, except the calls you
use to retrieve a token in the first place. (For such calls, you use the eBay
member's username and password instead.)

#    Returns: 'ns:XMLRequesterCredentialsType'

=cut
       
sub getRequesterCredentials {
   my $self = shift;
   return $self->getRequestDataType()->getRequesterCredentials();
}
=head2 setRequesterCredentials()

#    Argument: 'ns:XMLRequesterCredentialsType'

=cut
       
sub setRequesterCredentials {
   my $self   = shift;
   my $pRequesterCredentials = shift;
   $self->getRequestDataType()->setRequesterCredentials($pRequesterCredentials);
}

=head2 getRequestVersion()

The version number of the API code that you are
programming against (e.g., 549).
The version you specify for a call has these basic effects:<br>
- It indicates the version of the code lists and other
data that eBay should use to process your request.<br>
- It indicates the schema version you are using.<br>
You need to use a version that is greater than or equal to the
lowest supported version.<br>
<br>
<b>For the SOAP API:</b> If you are using the SOAP API,
this field is required. Specify the version of the WSDL your
application is using.<br>
<br>
<b>For the XML API:</b> If you are using the XML API,
this field has no effect. Instead, specify the version in the
X-EBAY-API-COMPATIBILITY-LEVEL HTTP header.
(If you specify Version in the body of an XML API request and it
is different from the value in the HTTP header, eBay returns an
informational warning that the value in the HTTP header was used
instead.)

#    Returns: 'xs:string'

=cut
       
sub getRequestVersion {
   my $self = shift;
   return $self->getRequestDataType()->getVersion();
}
=head2 setRequestVersion()

#    Argument: 'xs:string'

=cut
       
sub setRequestVersion {
   my $self   = shift;
   my $sVersion = shift;
   $self->getRequestDataType()->setVersion($sVersion);
}

=head2 getWarningLevel()

Controls whether or not to return warnings when the application passes
unrecognized or deprecated elements in a request.<br>
<br>
An unrecognized element is one that is not defined in any supported
version of the schema. Schema element names are case-sensitive,
so using WarningLevel can also help you remove any potential hidden
bugs within your application due to incorrect case or spelling in
field names before you put your application into the
Production environment.<br>
<br>
WarningLevel only validates elements; it doesn't validate
XML attributes. It also doesn't control warnings related to
user-entered strings or numbers, or warnings for
logical errors.<br>
<br>
We recommend that you only use this during development and debugging.
Do not use this in requests in your production code.

#    Returns: 'ns:WarningLevelCodeType'

=cut
       
sub getWarningLevel {
   my $self = shift;
   return $self->getRequestDataType()->getWarningLevel();
}
=head2 setWarningLevel()

#    Argument: 'ns:WarningLevelCodeType'

=cut
       
sub setWarningLevel {
   my $self   = shift;
   my $sWarningLevel = shift;
   $self->getRequestDataType()->setWarningLevel($sWarningLevel);
}



#
# OUTPUT properties (response)
#

=head2 getAck()

A token representing the application-level acknowledgement code that indicates
the response status (e.g., success). The AckCodeType list specifies
the possible values for Ack.

  Returned: Always
  AllCallsExcept: CompleteSale, GetPopularKeywords
  AllValuesExcept: PartialFailure
  Returned: Always
#    Returns: 'ns:AckCodeType'

=cut
       
sub getAck {
   my $self = shift;
   return $self->getResponseDataType()->getAck();
}

=head2 getResponseBotBlock()

Container of token, image URL and audio URL.

  Returned: Conditionally
#    Returns: 'ns:BotBlockResponseType'

=cut
       
sub getResponseBotBlock {
   my $self = shift;
   return $self->getResponseDataType()->getBotBlock();
}

=head2 getBuild()

This refers to the specific software build that eBay used when processing the request
and generating the response. This includes the version number plus additional
information. eBay Developer Support may request the build information
when helping you resolve technical issues.

  Returned: Always
  AllCalls: 
#    Returns: 'xs:string'

=cut
       
sub getBuild {
   my $self = shift;
   return $self->getResponseDataType()->getBuild();
}

=head2 getCorrelationID()

In most cases, all calls support a MessageID element in the request
and a CorrelationID element in the response. If you pass a message
ID in a request, we will return the same value in CorrelationID in
the response. You can use this for tracking that a response is
returned for every request and to match particular responses to
particular requests. If you do not pass MessageID in the request,
CorrelationID is not returned.<br>
<br>
<span class="tablenote"><b>Note:</b>
GetCategories, GetAttributesCS, GetCategory2CS, GetAttributesXSL,
GetProductFinder, GetProductFinderXSL, and GetProductSearchPage
are designed to retrieve very large sets of metadata
that change once a day or less often. To improve performance,
these calls return cached responses when you request all available data
(with no filters). When this occurs, the MessageID and CorrelationID
fields aren't applicable.
However, if you specify an input filter to reduce the amount of data
returned, the calls retrieve the latest data (not cached).
When this occurs, MessageID and CorrelationID are applicable.
</span>

  Returned: Conditionally
  AllCalls: 
#    Returns: 'xs:string'

=cut
       
sub getCorrelationID {
   my $self = shift;
   return $self->getResponseDataType()->getCorrelationID();
}

=head2 getDuplicateInvocationDetails()

Information that explains a failure due to a duplicate InvocationID being
passed in.

  Returned: Conditionally
#    Returns: 'ns:DuplicateInvocationDetailsType'

=cut
       
sub getDuplicateInvocationDetails {
   my $self = shift;
   return $self->getResponseDataType()->getDuplicateInvocationDetails();
}

=head2 getEIASToken()

Unique Identifier of Recipient user ID of the notification. Only returned by
Platform Notifications (not for regular API call responses).

#    Returns: 'xs:string'

=cut
       
sub getEIASToken {
   my $self = shift;
   return $self->getResponseDataType()->getEIASToken();
}

=head2 getErrors()

A list of application-level errors (if any) that occurred when eBay
processed the request.

  Returned: Conditionally
  AllCalls: 
#    Returns: reference to an array  
                      of 'ns:ErrorType'

=cut
       
sub getErrors {
   my $self = shift;
   return $self->getResponseDataType()->getErrors();
}

=head2 getHardExpirationWarning()

Expiration date of the user's authentication token. Only returned
within the 7-day period prior to a token's expiration. To ensure
that user authentication tokens are secure and to help avoid a
user's token being compromised, tokens have a limited life span. A
token is only valid for a period of time (set by eBay). After this
amount of time has passed, the token expires and must be replaced
with a new token.

  Returned: Conditionally
  AllCallsExcept: FetchToken
#    Returns: 'xs:string'

=cut
       
sub getHardExpirationWarning {
   my $self = shift;
   return $self->getResponseDataType()->getHardExpirationWarning();
}

=head2 getMessage()

Supplemental information from eBay, if applicable. May elaborate on errors or
provide useful hints for the seller. This data can accompany the call's normal
data result set or a result set that contains only errors. The string can
return HTML, including TABLE, IMG, and HREF elements. In this case, an HTML-
based application should be able to include the HTML as-is in the HTML page
that displays the results. A non-HTML application would need to parse the HTML
and convert the table elements and image references into UI elements
particular to the programming language used. Because this data is returned as
a string, the HTML markup elements are escaped with character entity
references (e.g.,&lt;table&gt;&lt;tr&gt;...). See the
appendices in the eBay Web Services guide for general information about string
data types.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getMessage {
   my $self = shift;
   return $self->getResponseDataType()->getMessage();
}

=head2 getNotificationEventName()

Event name of the notification. Only returned by Platform Notifications.

#    Returns: 'xs:string'

=cut
       
sub getNotificationEventName {
   my $self = shift;
   return $self->getResponseDataType()->getNotificationEventName();
}

=head2 getNotificationSignature()

A Base64-encoded MD5 hash that allows the recipient of a Platform
Notification to verify this is a valid Platform Notification sent by
eBay.

#    Returns: 'xs:string'

=cut
       
sub getNotificationSignature {
   my $self = shift;
   return $self->getResponseDataType()->getNotificationSignature();
}

=head2 getRecipientUserID()

Recipient user ID of the notification. Only returned by Platform Notifications.

#    Returns: 'xs:string'

=cut
       
sub getRecipientUserID {
   my $self = shift;
   return $self->getResponseDataType()->getRecipientUserID();
}

=head2 getTimestamp()

This value represents the date and time when eBay processed the
request. The time zone of this value is GMT and the format is the
ISO 8601 date and time format (YYYY-MM-DDTHH:MM:SS.SSSZ). See Time
Values in the eBay Web Services guide for information about this
time format and converting to and from the GMT time zone. <br>
<br>
<span class="tablenote"><b>Note:</b>
GetCategories, GetAttributesCS, GetCategory2CS, GetAttributesXSL,
GetProductFinder, GetProductFinderXSL, and GetProductSearchPage
are designed to retrieve very large sets of metadata
that change once a day or less often. To improve performance,
these calls return cached responses when you request all available data
(with no filters). When this occurs, this time value reflects the
time the cached response was created. Thus, this value is not
necessarily when the request was processed.
However, if you specify an input filter to reduce the amount of data
returned, the calls retrieve the latest data (not cached).
When this occurs, this time value does reflect when the request
was processed.</span>

  Returned: Always
  AllCalls: 
#    Returns: 'xs:dateTime'

=cut
       
sub getTimestamp {
   my $self = shift;
   return $self->getResponseDataType()->getTimestamp();
}

=head2 getResponseVersion()

The version of the response payload schema. Indicates the version of the
schema that eBay used to process the request.
See "Standard Data for All Calls" in the eBay Web Services Guide for information
on using the response version when troubleshooting "CustomCode" values that appear
in the response.

  Returned: Always
  AllCalls: 
#    Returns: 'xs:string'

=cut
       
sub getResponseVersion {
   my $self = shift;
   return $self->getResponseDataType()->getVersion();
}





1;   
