#!/usr/bin/perl -w
# This tests the various methods of the Graphics::Framebuffer module
# and shows the only way threads will work with it.

use strict;
use Switch;

use threads;
use threads::shared;
use Graphics::Framebuffer;
use Sys::CPU;

my $mali = 0;
my $file = 0;
my $hold : shared = 0;
my @waiting : shared;
my $arg = join('',@ARGV);
my $Threads = $arg =~ /(\d+)/ ? $1 : Sys::CPU::cpu_count();
$mali = 1 if ($arg =~ /mali/i); # Mali GPU correction mode
$file = 1 if ($arg =~ /file/i); # File Handle mode

print "\nRunning on a ",Sys::CPU::cpu_type(), " with $Threads threads\n";
sleep 3;

my @framebuffer;
foreach my $thr (0..$Threads) {
    $framebuffer[$thr] = Graphics::Framebuffer->new('FB_DEVICE' => '/dev/fb0','FILE_MODE' => $file,'MALI' => $mali);
}
my ($screen_width,$screen_height)  = $framebuffer[0]->screen_dimensions();


$framebuffer[0]->cls();

foreach my $page (1..$Threads) {
    $waiting[$page] = 0;
    threads->create(
        sub {
            my $Page = shift;
            my $Cols = shift;
            if (defined($framebuffer[$Page]->{'ERROR'})) {
                print STDERR "Thread $Page, $framebuffer[$Page]->{'ERROR'}\n";
            }
            while(1) {
                attract($Page,$Cols);
                while($hold) {
                    threads->yield();
                    $waiting[$Page] = 0;
                    sleep 1;
                }
                $waiting[$Page] = 1;
            }
        },
        $page
    );
}
while(1) {
    $hold = 0;
    sleep 30;
    $hold = 1;
    foreach my $page (1..$Threads) {
        while($waiting[$page]) {
            sleep 1;
        }
    }
    $framebuffer[0]->cls();
}


##############################################################################
##                             ATTRACT MODE                                 ##
##############################################################################
# Remeniscent of the "Atract Mode" of the old Atari 8 bit computers, this    #
# mode merely puts random patterns on the screen.                            #
##############################################################################

sub attract {
    my $page = shift;
    my $red  = int(rand(256));
    my $grn  = int(rand(256));
    my $blu  = int(rand(256));
    my $x    = int(rand($screen_width));
    my $y    = int(rand($screen_height));
    my $w    = int(rand($screen_width/3));
    my $h    = int(rand($screen_height/3));
    my $rx   = int(rand($screen_width/5));
    my $ry   = int(rand($screen_height/5));
    my $sd   = int(rand(360));
    my $ed   = int(rand(360));
    my $gr   = (rand(100)/100);
    my $mode = int(rand(4));
    my $type = int(rand(11));
    my $size = int(rand(7)) - 3;
    my $arc  = int(rand(3));

    $framebuffer[$page]->set_color({'red' => $red,'green' => $grn,'blue' => $blu});
    $framebuffer[$page]->draw_mode($mode);
    switch ($type) {
        case 0 {
            $framebuffer[$page]->plot({'x' => $x,'y' => $y,'pixel_size' => $size});
        }
        case 1 {
            $framebuffer[$page]->plot({'x' => $x,'y' => $y,'pixel_size' => $size});
            $framebuffer[$page]->drawto({'x' => $w,'y' => $h,'pixel_size' => $size});
        }
        case 2 {
            $framebuffer[$page]->circle({'x' => $x,'y' => $y,'radius' => $rx,'filled' => int(rand(2)),'pixel_size' => $size});
        }
        case 3 {
            $framebuffer[$page]->ellipse({'x' => $x,'y' => $y,'xradius' => $rx,'yradius' => $ry,'filled' => int(rand(2)),'factor' => 1,'pixel_size' => $size});
        }
        case 4 {
            $framebuffer[$page]->rbox({'x' => $x,'y' => $y,'width' => $w,'height' => $h,'filled' => (int(rand(2))),'pixel_size' => $size});
        }
        case 5 {
            $framebuffer[$page]->draw_arc({'x' => $x,'y' => $y,'radius' => $ry,'start_degrees' => $sd,'end_degrees' => $ed,'granularity' => $gr,'mode' => $arc,'pixel_size' => $size});
        }
        case 6 {
            $framebuffer[$page]->rbox(
                {
                    'x'          => $x,
                    'y'          => $y,
                    'width'      => $w,
                    'height'     => $h,
                    'filled'     => 1,
                    'pixel_size' => 1,
                    'gradient'   => {
                        'start' => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        },
                        'end'   => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        }
                    }
                }
            );
        }
        case 7 {
            my @poly;
            foreach my $count (0..int(rand(10))) {
                push(@poly,int(rand($screen_width)));
                push(@poly,int(rand($screen_height)));
            }
            $framebuffer[$page]->polygon({'pixel_size' => $size,'coordinates' => \@poly, 'filled' => (int(rand(2)))});
        }
        case 8 {
            my @poly;
            foreach my $count (0..int(rand(5))) {
                push(@poly,int(rand($screen_width)));
                push(@poly,int(rand($screen_height)));
            }
            $framebuffer[$page]->polygon(
                {
                    'pixel_size'  => 1,
                    'coordinates' => \@poly,
                    'filled'      => 1,
                    'gradient'    => {
                        'start' => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        },
                        'end'   => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        }
                    }
                }
            );
        }
        case 9 {
            $framebuffer[$page]->circle(
                {
                    'x'        => $x,
                    'y'        => $y,
                    'radius'   => $rx,
                    'filled'   => 1,
                    'gradient' => {
                        'start' => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        },
                        'end'   => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        }
                    }
                }
            );
        }
        case 10 {
            $framebuffer[$page]->ellipse(
                {
                    'x'        => $x,
                    'y'        => $y,
                    'xradius'  => $rx,
                    'yradius'  => $ry,
                    'filled'   => 1,
                    'factor'   => 1,
                    'gradient' => {
                        'start' => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        },
                        'end'   => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        }
                    }
                }
            );
        }
        else { # This can be a large memory hog.  Disabled (random number doesn't go this high) for the moment.
            $framebuffer[$page]->fill({'x' => $x,'y' => $y});
        }
    }
}

__END__

__C__

