/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.interpreter;

import com.javonet.core.handler.Handler;
import com.javonet.core.protocol.CommandDeserializer;
import com.javonet.core.protocol.CommandSerializer;
import com.javonet.core.receiver.Receiver;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.utils.Command;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;

public class Interpreter {
    private final Handler handler = new Handler();

    public Command execute(Command command, IConnectionData connectionData) {
        byte[] messageByteArray = new CommandSerializer().serialize(command, connectionData);
        byte[] response = new byte[]{};
        if (connectionData.getConnectionType() != ConnectionType.WEB_SOCKET) {
            response = command.getRuntimeName() == RuntimeName.Jvm && connectionData.getConnectionType() == ConnectionType.IN_MEMORY ? new Receiver().sendCommand(messageByteArray) : Transmitter.sendCommand(messageByteArray);
        }
        return new CommandDeserializer(response).deserialize();
    }

    public Command process(byte[] byteArray) {
        Command receivedCommand = new CommandDeserializer(byteArray).deserialize();
        return this.handler.handleCommand(receivedCommand);
    }
}

