/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.core.handler.loadlibrary.JarAdder;
import com.javonet.core.handler.loadlibrary.JvmClassLoader;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;

public class LoadLibraryHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 1;
    private final JvmClassLoader jvmClassLoader = new JvmClassLoader(new URL[0], this.getClass().getClassLoader());

    LoadLibraryHandler() {
    }

    @Override
    public Object process(Command command) throws Exception {
        return this.loadLibrary(command);
    }

    private Object loadLibrary(Command command) throws Exception {
        if (command.getPayload().length < 1) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 1);
        }
        String assemblyName = command.getPayload()[0].toString();
        File f = new File(assemblyName);
        if (f.exists()) {
            try {
                this.jvmClassLoader.addUrl(f.toURI().toURL());
                JarAdder.addJarToClasspath(f);
                return 0;
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        throw new FileNotFoundException(assemblyName);
    }
}

