package Params::CheckCompiler::Exception::ValidationFailedForMooseTypeConstraint;

use strict;
use warnings;

our $VERSION = '0.03';

use Moo;

extends 'Throwable::Error';

has parameter => (
    is       => 'ro',
    required => 1,
);

has value => (
    is       => 'ro',
    required => 1,
);

has type => (
    is       => 'ro',
    required => 1,
);

1;

# ABSTRACT: Exception thrown when a Moose type constraint check fails

__END__

=pod

=encoding UTF-8

=head1 NAME

Params::CheckCompiler::Exception::ValidationFailedForMooseTypeConstraint - Exception thrown when a Moose type constraint check fails

=head1 VERSION

version 0.03

=head1 DESCRIPTION

This class provides information about type constraint failures.

=head1 METHODS

This class provides the following methods:

=head2 $e->parameter

This returns a string describing the parameter, something like C<The 'foo'
parameter> or C<Parameter #1>.

=head2 $e->value

This is the value that failed the type constraint check.

=head2 $e->type

This is the type constraint object that did not accept the value.

=head1 STRINGIFICATION

This object stringifies to a reasonable error message.

=head1 SUPPORT

Bugs may be submitted through L<the RT bug tracker|http://rt.cpan.org/Public/Dist/Display.html?Name=Params-CheckCompiler>
(or L<bug-params-checkcompiler@rt.cpan.org|mailto:bug-params-checkcompiler@rt.cpan.org>).

I am also usually active on IRC as 'drolsky' on C<irc://irc.perl.org>.

=head1 AUTHOR

Dave Rolsky <autarch@urth.org>

=head1 COPYRIGHT AND LICENCE

This software is Copyright (c) 2016 by Dave Rolsky.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
