use 5.14.0;
use strict;
use warnings;

package Stenciller::Standard {

    our $VERSION = '0.1208'; # VERSION:
    # ABSTRACT: Import to all

    use base 'Moops';
    use List::AllUtils();
    use Types::Stenciller();
    use MooseX::AttributeDocumented();
    use Path::Tiny();
    use PerlX::Maybe();
    use Carp();

    sub import {
        my $class = shift;
        my %opts = @_;

        push @{ $opts{'imports'} ||= [] } => (
            'List::AllUtils'    => [qw/any none sum uniq first_index/],
            'feature'           => [qw/:5.14/],
            'Types::Stenciller' => [{ replace => 1 }, '-types'],
            'Path::Tiny'        => ['path'],
            'MooseX::AttributeDocumented' => [],
            'PerlX::Maybe'      => [qw/maybe provided/],
            'Carp'              => [qw/carp/],
        );

        $class->SUPER::import(%opts);
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Stenciller::Standard - Import to all

=head1 VERSION

Version 0.1208, released 2015-02-08.

=head1 SOURCE

L<https://github.com/Csson/p5-Stenciller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Stenciller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
