use Stenciller::Standard;

our $VERSION = '0.1206'; # VERSION:
# ABSTRACT: A role for transformer plugins to consume
# PODNAME: Stenciller::Transformer

role Stenciller::Transformer using Moose {

    requires 'transform';

    has stenciller => (
        is => 'ro',
        isa => Stenciller,
        required => 1,
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Stenciller::Transformer - A role for transformer plugins to consume

=head1 VERSION

Version 0.1206, released 2015-02-07.

=head1 SYNOPSIS

    package Stenciller::Plugin::MyNewRenderer;

    use Moose;
    with 'Stenciller::Transformer';

    sub transformer {
        ...
    }

=head1 DESCRIPTION

This is the role that all L<Stenciller> plugins must consume. It requires a C<transformer> method to be implemented.



=head1 ATTRIBUTES

=head2 stenciller

The L<Stenciller> object is passed automatically to plugins.

=head1 SOURCE

L<https://github.com/Csson/p5-Stenciller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Stenciller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
