use 5.008;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
my $LIBS = '';
if ($^O eq 'MSWin32') {
   $LIBS = '-lopengl32 -lglu32';
} else {
   $LIBS = '-lGL -lGLU';
}

WriteMakefile(
    NAME              => 'OpenGL::GLU',
    VERSION_FROM      => 'lib/OpenGL/GLU.pm', # finds $VERSION, requires EU::MM from perl >= 5.5
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ABSTRACT_FROM     => 'lib/OpenGL/GLU.pm', # retrieve abstract from module
    AUTHOR            => 'chm@cpan.org',
    LICENSE           => 'perl',
    LIBS              => [$LIBS], # e.g., '-lm'
    DEFINE            => '-DGL_OES_EGL_image=1', # e.g., '-DHAVE_SOMETHING'
    INC               => '-I.', # e.g., '-I. -I/usr/include/other'
	# Un-comment this if you add C files to link with later:
    OBJECT            => 'GLU$(OBJ_EXT) gl_util$(OBJ_EXT)', # link all the C files too
);
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(GLU_AUTO_LOAD_MATRIX GLU_BEGIN GLU_CCW GLU_CULLING GLU_CW
		 GLU_DISPLAY_MODE GLU_DOMAIN_DISTANCE GLU_EDGE_FLAG GLU_END
		 GLU_ERROR GLU_EXTENSIONS GLU_EXTERIOR
		 GLU_EXT_nurbs_tessellator GLU_EXT_object_space_tess GLU_FALSE
		 GLU_FILL GLU_FLAT GLU_INCOMPATIBLE_GL_VERSION GLU_INSIDE
		 GLU_INTERIOR GLU_INVALID_ENUM GLU_INVALID_OPERATION
		 GLU_INVALID_VALUE GLU_LINE GLU_MAP1_TRIM_2 GLU_MAP1_TRIM_3
		 GLU_NONE GLU_NURBS_BEGIN GLU_NURBS_BEGIN_DATA
		 GLU_NURBS_BEGIN_DATA_EXT GLU_NURBS_BEGIN_EXT GLU_NURBS_COLOR
		 GLU_NURBS_COLOR_DATA GLU_NURBS_COLOR_DATA_EXT
		 GLU_NURBS_COLOR_EXT GLU_NURBS_END GLU_NURBS_END_DATA
		 GLU_NURBS_END_DATA_EXT GLU_NURBS_END_EXT GLU_NURBS_ERROR
		 GLU_NURBS_ERROR1 GLU_NURBS_ERROR10 GLU_NURBS_ERROR11
		 GLU_NURBS_ERROR12 GLU_NURBS_ERROR13 GLU_NURBS_ERROR14
		 GLU_NURBS_ERROR15 GLU_NURBS_ERROR16 GLU_NURBS_ERROR17
		 GLU_NURBS_ERROR18 GLU_NURBS_ERROR19 GLU_NURBS_ERROR2
		 GLU_NURBS_ERROR20 GLU_NURBS_ERROR21 GLU_NURBS_ERROR22
		 GLU_NURBS_ERROR23 GLU_NURBS_ERROR24 GLU_NURBS_ERROR25
		 GLU_NURBS_ERROR26 GLU_NURBS_ERROR27 GLU_NURBS_ERROR28
		 GLU_NURBS_ERROR29 GLU_NURBS_ERROR3 GLU_NURBS_ERROR30
		 GLU_NURBS_ERROR31 GLU_NURBS_ERROR32 GLU_NURBS_ERROR33
		 GLU_NURBS_ERROR34 GLU_NURBS_ERROR35 GLU_NURBS_ERROR36
		 GLU_NURBS_ERROR37 GLU_NURBS_ERROR4 GLU_NURBS_ERROR5
		 GLU_NURBS_ERROR6 GLU_NURBS_ERROR7 GLU_NURBS_ERROR8
		 GLU_NURBS_ERROR9 GLU_NURBS_MODE GLU_NURBS_MODE_EXT
		 GLU_NURBS_NORMAL GLU_NURBS_NORMAL_DATA
		 GLU_NURBS_NORMAL_DATA_EXT GLU_NURBS_NORMAL_EXT
		 GLU_NURBS_RENDERER GLU_NURBS_RENDERER_EXT
		 GLU_NURBS_TESSELLATOR GLU_NURBS_TESSELLATOR_EXT
		 GLU_NURBS_TEXTURE_COORD GLU_NURBS_TEXTURE_COORD_DATA
		 GLU_NURBS_TEX_COORD_DATA_EXT GLU_NURBS_TEX_COORD_EXT
		 GLU_NURBS_VERTEX GLU_NURBS_VERTEX_DATA
		 GLU_NURBS_VERTEX_DATA_EXT GLU_NURBS_VERTEX_EXT
		 GLU_OBJECT_PARAMETRIC_ERROR GLU_OBJECT_PARAMETRIC_ERROR_EXT
		 GLU_OBJECT_PATH_LENGTH GLU_OBJECT_PATH_LENGTH_EXT
		 GLU_OUTLINE_PATCH GLU_OUTLINE_POLYGON GLU_OUTSIDE
		 GLU_OUT_OF_MEMORY GLU_PARAMETRIC_ERROR
		 GLU_PARAMETRIC_TOLERANCE GLU_PATH_LENGTH GLU_POINT
		 GLU_SAMPLING_METHOD GLU_SAMPLING_TOLERANCE GLU_SILHOUETTE
		 GLU_SMOOTH GLU_TESS_BEGIN GLU_TESS_BEGIN_DATA
		 GLU_TESS_BOUNDARY_ONLY GLU_TESS_COMBINE GLU_TESS_COMBINE_DATA
		 GLU_TESS_COORD_TOO_LARGE GLU_TESS_EDGE_FLAG
		 GLU_TESS_EDGE_FLAG_DATA GLU_TESS_END GLU_TESS_END_DATA
		 GLU_TESS_ERROR GLU_TESS_ERROR1 GLU_TESS_ERROR2 GLU_TESS_ERROR3
		 GLU_TESS_ERROR4 GLU_TESS_ERROR5 GLU_TESS_ERROR6
		 GLU_TESS_ERROR7 GLU_TESS_ERROR8 GLU_TESS_ERROR_DATA
		 GLU_TESS_MAX_COORD GLU_TESS_MISSING_BEGIN_CONTOUR
		 GLU_TESS_MISSING_BEGIN_POLYGON GLU_TESS_MISSING_END_CONTOUR
		 GLU_TESS_MISSING_END_POLYGON GLU_TESS_NEED_COMBINE_CALLBACK
		 GLU_TESS_TOLERANCE GLU_TESS_VERTEX GLU_TESS_VERTEX_DATA
		 GLU_TESS_WINDING_ABS_GEQ_TWO GLU_TESS_WINDING_NEGATIVE
		 GLU_TESS_WINDING_NONZERO GLU_TESS_WINDING_ODD
		 GLU_TESS_WINDING_POSITIVE GLU_TESS_WINDING_RULE GLU_TRUE
		 GLU_UNKNOWN GLU_U_STEP GLU_VERSION GLU_VERSION_1_1
		 GLU_VERSION_1_2 GLU_VERSION_1_3 GLU_VERTEX GLU_V_STEP));
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'OpenGL::GLU',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
