#!/usr/bin/perl

package eBay::API::XML::DataType::ShippingServiceDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ShippingServiceDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ShippingServiceDetailsType

=head1 DESCRIPTION

Details about a specific shipping service.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ShippingServiceDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AnnouncementMessageType;
use eBay::API::XML::DataType::Enum::ShippingCarrierCodeType;
use eBay::API::XML::DataType::Enum::ShippingPackageCodeType;
use eBay::API::XML::DataType::Enum::ShippingServiceCodeType;
use eBay::API::XML::DataType::Enum::ShippingTypeCodeType;


my @gaProperties = ( [ 'CODService', 'xs:boolean', '', '', '' ]
	, [ 'DeprecationDetails', 'ns:AnnouncementMessageType', '1'
	     ,'eBay::API::XML::DataType::AnnouncementMessageType', '1' ]
	, [ 'Description', 'xs:string', '', '', '' ]
	, [ 'DimensionsRequired', 'xs:boolean', '', '', '' ]
	, [ 'ExpeditedService', 'xs:boolean', '', '', '' ]
	, [ 'InternationalService', 'xs:boolean', '', '', '' ]
	, [ 'MappedToShippingServiceID', 'xs:int', '', '', '' ]
	, [ 'ServiceType', 'ns:ShippingTypeCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::ShippingTypeCodeType', '' ]
	, [ 'ShippingCarrier', 'ns:ShippingCarrierCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::ShippingCarrierCodeType', '' ]
	, [ 'ShippingPackage', 'ns:ShippingPackageCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::ShippingPackageCodeType', '' ]
	, [ 'ShippingService', 'xs:token', '', '', '' ]
	, [ 'ShippingServiceCode', 'ns:ShippingServiceCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShippingServiceCodeType', '' ]
	, [ 'ShippingServiceID', 'xs:int', '', '', '' ]
	, [ 'ShippingTimeMax', 'xs:int', '', '', '' ]
	, [ 'ShippingTimeMin', 'xs:int', '', '', '' ]
	, [ 'SurchargeApplicable', 'xs:boolean', '', '', '' ]
	, [ 'ValidForSellingFlow', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCODService()

Applies to the Italy site (site ID 101) only. Indicates whether the shipping service
is a Cash On Delivery shipping service.
Returned only if true.

#    Argument: 'xs:boolean'

=cut

sub setCODService {
  my $self = shift;
  $self->{'CODService'} = shift
}

=head2 isCODService()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isCODService {
  my $self = shift;
  return $self->{'CODService'};
}


=head2 setDeprecationDetails()

A mechanism by which details about deprecation of a shipping service is
announced. See also MappedToShippingServiceID.
If this container is empty, it means that there is no mapping for this
shipping service and that the shipping service will be dropped from the
listing without an accompanying warning message from the eBay API.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=DeprecatedShippingServices
Title: Deprecated Shipping Services

#    Argument: reference to an array  
                      of 'ns:AnnouncementMessageType'

=cut

sub setDeprecationDetails {
  my $self = shift;
  $self->{'DeprecationDetails'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDeprecationDetails()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:AnnouncementMessageType'

=cut

sub getDeprecationDetails {
  my $self = shift;
  return $self->_getDataTypeArray('DeprecationDetails');
}


=head2 setDescription()

Full name of the shipping service for display purposes.

#    Argument: 'xs:string'

=cut

sub setDescription {
  my $self = shift;
  $self->{'Description'} = shift
}

=head2 getDescription()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDescription {
  my $self = shift;
  return $self->{'Description'};
}


=head2 setDimensionsRequired()

True if this shipping service requires package dimensions.

#    Argument: 'xs:boolean'

=cut

sub setDimensionsRequired {
  my $self = shift;
  $self->{'DimensionsRequired'} = shift
}

=head2 isDimensionsRequired()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isDimensionsRequired {
  my $self = shift;
  return $self->{'DimensionsRequired'};
}


=head2 setExpeditedService()

Indicates whether the shipping service is an expedited shipping service.
See Enabling Get It Fast. Whether the service is an expedited
shipping service. Only returned for sites for which the Get It
Fast feature is enabled and only if true.<br><br>
Related fields:<br>
Item.DispatchTimeMax and Item.GetItFast in AddItem

#    Argument: 'xs:boolean'

=cut

sub setExpeditedService {
  my $self = shift;
  $self->{'ExpeditedService'} = shift
}

=head2 isExpeditedService()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isExpeditedService {
  my $self = shift;
  return $self->{'ExpeditedService'};
}


=head2 setInternationalService()

Indicates whether the shipping service is an international shipping service, i.e.
one that ships from to another country from the country of the
specified site.<br><br>
Related field: Item.ShippingDetails.InternationalShippingServiceOption in AddItem.

#    Argument: 'xs:boolean'

=cut

sub setInternationalService {
  my $self = shift;
  $self->{'InternationalService'} = shift
}

=head2 isInternationalService()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isInternationalService {
  my $self = shift;
  return $self->{'InternationalService'};
}


=head2 setMappedToShippingServiceID()

The ID of another shipping service that will be used when a
shipping service is deprecated. See also DeprecationDetails.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=DeprecatedShippingServices
Title: Deprecated Shipping Services

#    Argument: 'xs:int'

=cut

sub setMappedToShippingServiceID {
  my $self = shift;
  $self->{'MappedToShippingServiceID'} = shift
}

=head2 getMappedToShippingServiceID()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getMappedToShippingServiceID {
  my $self = shift;
  return $self->{'MappedToShippingServiceID'};
}


=head2 setServiceType()

The types of shipping that this shipping service supports.

#    Argument: reference to an array  
                      of 'ns:ShippingTypeCodeType'

=cut

sub setServiceType {
  my $self = shift;
  $self->{'ServiceType'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getServiceType()

  Calls: GeteBayDetails
  Returned: Conditionally
  OnlyTheseValues: Flat, Calculated

#    Returns: reference to an array  
                      of 'ns:ShippingTypeCodeType'

=cut

sub getServiceType {
  my $self = shift;
  return $self->_getDataTypeArray('ServiceType');
}


=head2 setShippingCarrier()

The kinds of carrier supported by this shipping service.

#    Argument: reference to an array  
                      of 'ns:ShippingCarrierCodeType'

=cut

sub setShippingCarrier {
  my $self = shift;
  $self->{'ShippingCarrier'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getShippingCarrier()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ShippingCarrierCodeType'

=cut

sub getShippingCarrier {
  my $self = shift;
  return $self->_getDataTypeArray('ShippingCarrier');
}


=head2 setShippingPackage()

The kinds of packages supported by this shipping service.

#    Argument: reference to an array  
                      of 'ns:ShippingPackageCodeType'

=cut

sub setShippingPackage {
  my $self = shift;
  $self->{'ShippingPackage'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getShippingPackage()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ShippingPackageCodeType'

=cut

sub getShippingPackage {
  my $self = shift;
  return $self->_getDataTypeArray('ShippingPackage');
}


=head2 setShippingService()

Value used for the shipping service.
For a list of valid values that you can cache for future use, call GeteBayDetails
with DetailName set to ShippingServiceDetails.<br><br>
Related fields:<br>
Item.ShippingDetails.InternationalShippingServiceOption.ShippingService in AddItem<br>
Item.ShippingDetails.ShippingServiceOptions.ShippingService in AddItem

#    Argument: 'xs:token'

=cut

sub setShippingService {
  my $self = shift;
  $self->{'ShippingService'} = shift
}

=head2 getShippingService()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:token'

=cut

sub getShippingService {
  my $self = shift;
  return $self->{'ShippingService'};
}


=head2 setShippingServiceCode()

For future use.

#    Argument: 'ns:ShippingServiceCodeType'

=cut

sub setShippingServiceCode {
  my $self = shift;
  $self->{'ShippingServiceCode'} = shift
}

=head2 getShippingServiceCode()

#    Returns: 'ns:ShippingServiceCodeType'

=cut

sub getShippingServiceCode {
  my $self = shift;
  return $self->{'ShippingServiceCode'};
}


=head2 setShippingServiceID()

Numeric identifier. A value greater than 50000 represents an
international shipping service (confirmed by
InternationalShippingService being true). Some applications use this ID
to look up shipping services more efficiently.
Also useful for applications that have migrated from the legacy XML API.

#    Argument: 'xs:int'

=cut

sub setShippingServiceID {
  my $self = shift;
  $self->{'ShippingServiceID'} = shift
}

=head2 getShippingServiceID()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getShippingServiceID {
  my $self = shift;
  return $self->{'ShippingServiceID'};
}


=head2 setShippingTimeMax()

The maximum guaranteed number of days the shipping carrier will
take to ship an item (not including the time it takes the
seller to deliver the item to the shipping carrier). Always
returned when ExpeditedService is true or if defined for a particular service.
See Enabling Get It Fast feature.

#    Argument: 'xs:int'

=cut

sub setShippingTimeMax {
  my $self = shift;
  $self->{'ShippingTimeMax'} = shift
}

=head2 getShippingTimeMax()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getShippingTimeMax {
  my $self = shift;
  return $self->{'ShippingTimeMax'};
}


=head2 setShippingTimeMin()

The minimum guaranteed number of days the shipping carrier will
take to ship an item (not including the time it takes the
seller to deliver the item to the shipping carrier). Always
returned when ExpeditedService is true or if defined for a
particular service.
See Enabling Get It Fast feature.

#    Argument: 'xs:int'

=cut

sub setShippingTimeMin {
  my $self = shift;
  $self->{'ShippingTimeMin'} = shift
}

=head2 getShippingTimeMin()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getShippingTimeMin {
  my $self = shift;
  return $self->{'ShippingTimeMin'};
}


=head2 setSurchargeApplicable()

True if a surcharge applies for any region that this service ships to.

#    Argument: 'xs:boolean'

=cut

sub setSurchargeApplicable {
  my $self = shift;
  $self->{'SurchargeApplicable'} = shift
}

=head2 isSurchargeApplicable()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isSurchargeApplicable {
  my $self = shift;
  return $self->{'SurchargeApplicable'};
}


=head2 setValidForSellingFlow()

True if the shipping service is valid for the Sell Your Item flow.

#    Argument: 'xs:boolean'

=cut

sub setValidForSellingFlow {
  my $self = shift;
  $self->{'ValidForSellingFlow'} = shift
}

=head2 isValidForSellingFlow()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isValidForSellingFlow {
  my $self = shift;
  return $self->{'ValidForSellingFlow'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
