#!/usr/bin/perl

package eBay::API::XML::DataType::PolicyComplianceDashboardType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PolicyComplianceDashboardType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::PolicyComplianceDashboardType

=head1 DESCRIPTION

Container for fields related to policy compliance.Communicate the Sellers current
status in terms of risk of facing TnS action(i.e. warnings, cancelled listings,
restrictions, suspension,violations.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::PolicyComplianceDashboardType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::SellerDashboardAlertType;
use eBay::API::XML::DataType::Enum::PolicyComplianceStatusCodeType;


my @gaProperties = ( [ 'Alert', 'ns:SellerDashboardAlertType', '1'
	     ,'eBay::API::XML::DataType::SellerDashboardAlertType', '1' ]
	, [ 'Status', 'ns:PolicyComplianceStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PolicyComplianceStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAlert()

A message to help you understand your eBay policy compliance status.

#    Argument: reference to an array  
                      of 'ns:SellerDashboardAlertType'

=cut

sub setAlert {
  my $self = shift;
  $self->{'Alert'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAlert()

  Calls: GetSellerDashboard
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:SellerDashboardAlertType'

=cut

sub getAlert {
  my $self = shift;
  return $self->_getDataTypeArray('Alert');
}


=head2 setStatus()

Rates how well you are following eBay's policies.

#    Argument: 'ns:PolicyComplianceStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetSellerDashboard
  Returned: Conditionally

#    Returns: 'ns:PolicyComplianceStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
