#!/usr/bin/perl

package eBay::API::XML::Call::VerifyAddItem::VerifyAddItemRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. VerifyAddItemRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::VerifyAddItem::VerifyAddItemRequestType

=head1 DESCRIPTION

Enables a seller to specify the definition of a new
item and submit the definition to eBay without creating a
listing. This enables the seller to test
the item definition and get
listing fees before actually listing the item.
The listing fees may be different
from the listing fees returned by AddItem.
<br>
<br>
The call validates your input fields against the schema. However, some
business-logic checks performed for an AddItem call are not executed.
For more information, please see the following
Knowledge Base article:
<br>
<br>
<a href="http://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=912" target="_blank">VerifyAddItem returns Success with no Errors, but AddItem returns Failure with Errors</a>
<br>
<br>
There are cases in which VerifyAddItem
behaves differently from AddItem and returns a different result.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::VerifyAddItem::VerifyAddItemRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ExternalProductIDType;
use eBay::API::XML::DataType::ItemType;


my @gaProperties = ( [ 'ExternalProductID', 'ns:ExternalProductIDType', ''
	     ,'eBay::API::XML::DataType::ExternalProductIDType', '1' ]
	, [ 'IncludeExpressRequirements', 'xs:boolean', '', '', '' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setExternalProductID()

<b>Deprecated.</b> This field will be removed from the schema
in a future release. Recommended usage as of release 439 varies for
eBay.com listings and Half.com listings.
<br><br>
For eBay.com listings:
As of release 439, this field can still be passed in, but we recommend
that you update your applications to use the ExternalProductID field
defined on the item instead (i.e., Item.ExternalProductID). If you
specify both Item.ExternalProductID and this field in the same request,
eBay uses the value in Item.ExternalProductID and ignores the value in
this field. See Item.ExternalProductID for information on using an
external ID for eBay.com listings.
<br><br>
For Half.com listings:
As of release 439, this field is required for Half.com listings.
Causes Half.com to list the item with Pre-filled Item Information based on
an ISBN value or other supported external ID, plus other meta-data that
you specify. See the eBay Web Services guide for information about
listing to Half.com.

  RequiredInput: Conditionally
#    Argument: 'ns:ExternalProductIDType'

=cut

sub setExternalProductID {
  my $self = shift;
  $self->{'ExternalProductID'} = shift
}

=head2 getExternalProductID()

#    Returns: 'ns:ExternalProductIDType'

=cut

sub getExternalProductID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExternalProductID'
		,'eBay::API::XML::DataType::ExternalProductIDType');
}


=head2 setIncludeExpressRequirements()

Indicates if the response should include detailed data relating to
whether an item would qualify as an Express listing. For
information about the Express-related data that can be returned
when IncludeExpressRequirements is set to true,
see the response of VerifyAddItem and see the
eBay Web Services Guide.

Default: false
SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressListingCriteria
Title: Listing Criteria for eBay Express

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeExpressRequirements {
  my $self = shift;
  $self->{'IncludeExpressRequirements'} = shift
}

=head2 isIncludeExpressRequirements()

#    Returns: 'xs:boolean'

=cut

sub isIncludeExpressRequirements {
  my $self = shift;
  return $self->{'IncludeExpressRequirements'};
}


=head2 setItem()

ItemType object, the properties of which define the new item listing.

  RequiredInput: Yes
#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
