/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.DTSSpecificBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTSTrackImpl
extends AbstractTrack {
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    int samplerate;
    int bitrate;
    int frameSize = 0;
    int sampleSize;
    int samplesPerFrame;
    int channelCount;
    private long[] sampleDurations;
    private int dataOffset = 0;
    DTSSpecificBox ddts = new DTSSpecificBox();
    private DataSource dataSource;
    private List<Sample> samples;
    boolean isVBR = false;
    boolean coreSubStreamPresent = false;
    boolean extensionSubStreamPresent = false;
    int numExtSubStreams = 0;
    int coreMaxSampleRate = 0;
    int coreBitRate = 0;
    int coreChannelMask = 0;
    int coreFramePayloadInBytes = 0;
    int extAvgBitrate = 0;
    int extPeakBitrate = 0;
    int extSmoothBuffSize = 0;
    int extFramePayloadInBytes = 0;
    int maxSampleRate = 0;
    int lbrCodingPresent = 0;
    int numFramesTotal = 0;
    int samplesPerFrameAtMaxFs = 0;
    int numSamplesOrigAudioAtMaxFs = 0;
    int channelMask = 0;
    int codecDelayAtMaxFs = 0;
    int bcCoreMaxSampleRate = 0;
    int bcCoreBitRate = 0;
    int bcCoreChannelMask = 0;
    int lsbTrimPercent = 0;
    String type = "none";
    private String lang = "eng";
    private static final int BUFFER = 0x4000000;

    public DTSTrackImpl(DataSource dataSource, String lang) throws IOException {
        super(dataSource.toString());
        this.lang = lang;
        this.dataSource = dataSource;
        this.parse();
    }

    public DTSTrackImpl(DataSource dataSource) throws IOException {
        super(dataSource.toString());
        this.dataSource = dataSource;
        this.parse();
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    private void parse() throws IOException {
        if (!this.readVariables()) {
            throw new IOException();
        }
        this.sampleDescriptionBox = new SampleDescriptionBox();
        AudioSampleEntry audioSampleEntry = new AudioSampleEntry(this.type);
        audioSampleEntry.setChannelCount(this.channelCount);
        audioSampleEntry.setSampleRate(this.samplerate);
        audioSampleEntry.setDataReferenceIndex(1);
        audioSampleEntry.setSampleSize(16);
        audioSampleEntry.addBox(this.ddts);
        this.sampleDescriptionBox.addBox(audioSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.samplerate);
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public long[] getSampleDurations() {
        return this.sampleDurations;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    private void parseDtshdhdr(int size, ByteBuffer bb) {
        bb.getInt();
        bb.get();
        bb.getInt();
        bb.get();
        short bitwStreamMetadata = bb.getShort();
        bb.get();
        this.numExtSubStreams = bb.get();
        if ((bitwStreamMetadata & 1) == 1) {
            this.isVBR = true;
        }
        if ((bitwStreamMetadata & 8) == 8) {
            this.coreSubStreamPresent = true;
        }
        if ((bitwStreamMetadata & 0x10) == 16) {
            this.extensionSubStreamPresent = true;
            ++this.numExtSubStreams;
        } else {
            this.numExtSubStreams = 0;
        }
        int i = 14;
        while (i < size) {
            bb.get();
            ++i;
        }
    }

    private boolean parseCoressmd(int size, ByteBuffer bb) {
        byte cmsr_1 = bb.get();
        short cmsr_2 = bb.getShort();
        this.coreMaxSampleRate = cmsr_1 << 16 | cmsr_2 & 0xFFFF;
        this.coreBitRate = bb.getShort();
        this.coreChannelMask = bb.getShort();
        this.coreFramePayloadInBytes = bb.getInt();
        int i = 11;
        while (i < size) {
            bb.get();
            ++i;
        }
        return true;
    }

    private boolean parseAuprhdr(int size, ByteBuffer bb) {
        bb.get();
        short bitwAupresData = bb.getShort();
        byte a = bb.get();
        int b = bb.getShort();
        this.maxSampleRate = a << 16 | b & 0xFFFF;
        this.numFramesTotal = bb.getInt();
        this.samplesPerFrameAtMaxFs = bb.getShort();
        a = bb.get();
        b = bb.getInt();
        this.numSamplesOrigAudioAtMaxFs = a << 32 | b & 0xFFFF;
        this.channelMask = bb.getShort();
        this.codecDelayAtMaxFs = bb.getShort();
        int c = 21;
        if ((bitwAupresData & 3) == 3) {
            a = bb.get();
            b = bb.getShort();
            this.bcCoreMaxSampleRate = a << 16 | b & 0xFFFF;
            this.bcCoreBitRate = bb.getShort();
            this.bcCoreChannelMask = bb.getShort();
            c += 7;
        }
        if ((bitwAupresData & 4) > 0) {
            this.lsbTrimPercent = bb.get();
            ++c;
        }
        if ((bitwAupresData & 8) > 0) {
            this.lbrCodingPresent = 1;
        }
        while (c < size) {
            bb.get();
            ++c;
        }
        return true;
    }

    private boolean parseExtssmd(int size, ByteBuffer bb) {
        byte a = bb.get();
        short b = bb.getShort();
        this.extAvgBitrate = a << 16 | b & 0xFFFF;
        int i = 3;
        if (this.isVBR) {
            a = bb.get();
            b = bb.getShort();
            this.extPeakBitrate = a << 16 | b & 0xFFFF;
            this.extSmoothBuffSize = bb.getShort();
            i += 5;
        } else {
            this.extFramePayloadInBytes = bb.getInt();
            i += 4;
        }
        while (i < size) {
            bb.get();
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readVariables() throws IOException {
        bb = this.dataSource.map(0L, 25000L);
        testHeader1 = bb.getInt();
        testHeader2 = bb.getInt();
        if (testHeader1 == 1146377032 && testHeader2 == 1145586770) ** GOTO lbl30
        throw new IOException("data does not start with 'DTSHDHDR' as required for a DTS-HD file");
lbl-1000:
        // 1 sources

        {
            size = (int)bb.getLong();
            if (testHeader1 == 1146377032 && testHeader2 == 1145586770) {
                this.parseDtshdhdr(size, bb);
            } else if (testHeader1 == 1129271877 && testHeader2 == 1397968196) {
                if (!this.parseCoressmd(size, bb)) {
                    return false;
                }
            } else if (testHeader1 == 1096110162 && testHeader2 == 759710802) {
                if (!this.parseAuprhdr(size, bb)) {
                    return false;
                }
            } else if (testHeader1 == 1163416659 && testHeader2 == 1398754628) {
                if (!this.parseExtssmd(size, bb)) {
                    return false;
                }
            } else {
                i = 0;
                while (i < size) {
                    bb.get();
                    ++i;
                }
            }
            testHeader1 = bb.getInt();
            testHeader2 = bb.getInt();
lbl30:
            // 2 sources

            ** while ((testHeader1 != 1398035021 || testHeader2 != 0x44415441) && bb.remaining() > 100)
        }
lbl31:
        // 1 sources

        dataSize = bb.getLong();
        this.dataOffset = bb.position();
        amode = -1;
        extAudioId = 0;
        extAudio = 0;
        corePresent = -1;
        extPresent = -1;
        extXch = false;
        extXXch = false;
        extX96k = false;
        extXbr = false;
        extLbr = false;
        extXll = false;
        extCore = false;
        done = false;
        while (!done) {
            offset = bb.position();
            sync = bb.getInt();
            if (sync == 2147385345) {
                if (corePresent == 1) {
                    done = true;
                    continue;
                }
                corePresent = 1;
                brb = new BitReaderBuffer(bb);
                ftype = brb.readBits(1);
                shrt = brb.readBits(5);
                cpf = brb.readBits(1);
                if (ftype != 1 || shrt != 31 || cpf != 0) {
                    return false;
                }
                nblks = brb.readBits(7);
                this.samplesPerFrame = 32 * (nblks + 1);
                fsize = brb.readBits(14);
                this.frameSize += fsize + 1;
                amode = brb.readBits(6);
                sfreq = brb.readBits(4);
                this.samplerate = this.getSampleRate(sfreq);
                rate = brb.readBits(5);
                this.bitrate = this.getBitRate(rate);
                fixedBit = brb.readBits(1);
                if (fixedBit != 0) {
                    return false;
                }
                brb.readBits(1);
                brb.readBits(1);
                brb.readBits(1);
                brb.readBits(1);
                extAudioId = brb.readBits(3);
                extAudio = brb.readBits(1);
                brb.readBits(1);
                brb.readBits(2);
                brb.readBits(1);
                if (cpf == 1) {
                    brb.readBits(16);
                }
                brb.readBits(1);
                vernum = brb.readBits(4);
                brb.readBits(2);
                pcmr = brb.readBits(3);
                switch (pcmr) {
                    case 0: 
                    case 1: {
                        this.sampleSize = 16;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.sampleSize = 20;
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.sampleSize = 24;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                brb.readBits(1);
                brb.readBits(1);
                dialnorm = 0;
                switch (vernum) {
                    case 6: {
                        dialnorm = brb.readBits(4);
                        -(16 + dialnorm);
                        break;
                    }
                    case 7: {
                        dialnorm = brb.readBits(4);
                        -dialnorm;
                        break;
                    }
                    default: {
                        brb.readBits(4);
                    }
                }
                bb.position(offset + fsize + 1);
                continue;
            }
            if (sync == 1683496997) {
                if (corePresent == -1) {
                    corePresent = 0;
                    this.samplesPerFrame = this.samplesPerFrameAtMaxFs;
                }
                extPresent = 1;
                brb = new BitReaderBuffer(bb);
                brb.readBits(8);
                brb.readBits(2);
                headerSizeType = brb.readBits(1);
                nuBits4Header = 12;
                nuBits4ExSSFsize = 20;
                if (headerSizeType == 0) {
                    nuBits4Header = 8;
                    nuBits4ExSSFsize = 16;
                }
                nuExtSSHeaderSize = brb.readBits(nuBits4Header) + 1;
                nuExtSSFsize = brb.readBits(nuBits4ExSSFsize) + 1;
                bb.position(offset + nuExtSSHeaderSize);
                extSync = bb.getInt();
                if (extSync == 0x5A5A5A5A) {
                    if (extXch) {
                        done = true;
                    }
                    extXch = true;
                } else if (extSync == 1191201283) {
                    if (extXXch) {
                        done = true;
                    }
                    extXXch = true;
                } else if (extSync == 496366178) {
                    if (extX96k) {
                        done = true;
                    }
                    extX96k = true;
                } else if (extSync == 1700671838) {
                    if (extXbr) {
                        done = true;
                    }
                    extXbr = true;
                } else if (extSync == 176167201) {
                    if (extLbr) {
                        done = true;
                    }
                    extLbr = true;
                } else if (extSync == 1101174087) {
                    if (extXll) {
                        done = true;
                    }
                    extXll = true;
                } else if (extSync == 45126241) {
                    if (extCore) {
                        done = true;
                    }
                    extCore = true;
                }
                if (!done) {
                    this.frameSize += nuExtSSFsize;
                }
                bb.position(offset + nuExtSSFsize);
                continue;
            }
            throw new IOException("No DTS_SYNCWORD_* found at " + bb.position());
        }
        fd = -1;
        switch (this.samplesPerFrame) {
            case 512: {
                fd = 0;
                break;
            }
            case 1024: {
                fd = 1;
                break;
            }
            case 2048: {
                fd = 2;
                break;
            }
            case 4096: {
                fd = 3;
            }
        }
        if (fd == -1) {
            return false;
        }
        coreLayout = 31;
        switch (amode) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                coreLayout = amode;
            }
        }
        streamContruction = 0;
        if (corePresent == 0) {
            if (extXll) {
                if (!extCore) {
                    streamContruction = 17;
                    this.type = "dtsl";
                } else {
                    streamContruction = 21;
                    this.type = "dtsh";
                }
            } else if (extLbr) {
                streamContruction = 18;
                this.type = "dtse";
            } else if (extCore) {
                this.type = "dtsh";
                if (!extXXch && !extXll) {
                    streamContruction = 19;
                } else if (extXXch && !extXll) {
                    streamContruction = 20;
                } else if (!extXXch && extXll) {
                    streamContruction = 21;
                }
            }
            this.samplerate = this.maxSampleRate;
            this.sampleSize = 24;
        } else if (extPresent < 1) {
            if (extAudio > 0) {
                switch (extAudioId) {
                    case 0: {
                        streamContruction = 2;
                        this.type = "dtsc";
                        break;
                    }
                    case 2: {
                        streamContruction = 4;
                        this.type = "dtsc";
                        break;
                    }
                    case 6: {
                        streamContruction = 3;
                        this.type = "dtsh";
                        break;
                    }
                    default: {
                        streamContruction = 0;
                        this.type = "dtsh";
                        break;
                    }
                }
            } else {
                streamContruction = 1;
                this.type = "dtsc";
            }
        } else {
            this.type = "dtsh";
            if (extAudio == 0) {
                if (!(extCore || !extXXch || extX96k || extXbr || extXll || extLbr)) {
                    streamContruction = 5;
                } else if (!(extCore || extXXch || extX96k || !extXbr || extXll || extLbr)) {
                    streamContruction = 6;
                } else if (!extCore && extXXch && !extX96k && extXbr && !extXll && !extLbr) {
                    streamContruction = 9;
                } else if (!(extCore || extXXch || !extX96k || extXbr || extXll || extLbr)) {
                    streamContruction = 10;
                } else if (!extCore && extXXch && extX96k && !extXbr && !extXll && !extLbr) {
                    streamContruction = 13;
                } else if (!(extCore || extXXch || extX96k || extXbr || !extXll || extLbr)) {
                    streamContruction = 14;
                }
            } else if (!(extAudioId != 0 || extCore || extXXch || extX96k || !extXbr || extXll || extLbr)) {
                streamContruction = 7;
            } else if (!(extAudioId != 6 || extCore || extXXch || extX96k || !extXbr || extXll || extLbr)) {
                streamContruction = 8;
            } else if (!(extAudioId != 0 || extCore || extXXch || !extX96k || extXbr || extXll || extLbr)) {
                streamContruction = 11;
            } else if (!(extAudioId != 6 || extCore || extXXch || !extX96k || extXbr || extXll || extLbr)) {
                streamContruction = 12;
            } else if (!(extAudioId != 0 || extCore || extXXch || extX96k || extXbr || !extXll || extLbr)) {
                streamContruction = 15;
            } else if (!(extAudioId != 2 || extCore || extXXch || extX96k || extXbr || !extXll || extLbr)) {
                streamContruction = 16;
            }
        }
        this.ddts.setDTSSamplingFrequency(this.maxSampleRate);
        if (this.isVBR) {
            this.ddts.setMaxBitRate(1000 * (this.coreBitRate + this.extPeakBitrate));
        } else {
            this.ddts.setMaxBitRate(1000 * (this.coreBitRate + this.extAvgBitrate));
        }
        this.ddts.setAvgBitRate(1000 * (this.coreBitRate + this.extAvgBitrate));
        this.ddts.setPcmSampleDepth(this.sampleSize);
        this.ddts.setFrameDuration(fd);
        this.ddts.setStreamConstruction(streamContruction);
        if ((this.coreChannelMask & 8) > 0 || (this.coreChannelMask & 4096) > 0) {
            this.ddts.setCoreLFEPresent(1);
        } else {
            this.ddts.setCoreLFEPresent(0);
        }
        this.ddts.setCoreLayout(coreLayout);
        this.ddts.setCoreSize(this.coreFramePayloadInBytes);
        this.ddts.setStereoDownmix(0);
        this.ddts.setRepresentationType(4);
        this.ddts.setChannelLayout(this.channelMask);
        if (this.coreMaxSampleRate > 0 && this.extAvgBitrate > 0) {
            this.ddts.setMultiAssetFlag(1);
        } else {
            this.ddts.setMultiAssetFlag(0);
        }
        this.ddts.setLBRDurationMod(this.lbrCodingPresent);
        this.ddts.setReservedBoxPresent(0);
        this.channelCount = 0;
        bit = 0;
        while (bit < 16) {
            if ((this.channelMask >> bit & 1) == 1) {
                switch (bit) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 14: {
                        ++this.channelCount;
                        break;
                    }
                    default: {
                        this.channelCount += 2;
                    }
                }
            }
            ++bit;
        }
        this.samples = this.generateSamples(this.dataSource, this.dataOffset, dataSize, corePresent);
        this.sampleDurations = new long[this.samples.size()];
        Arrays.fill(this.sampleDurations, (long)this.samplesPerFrame);
        return true;
    }

    private List<Sample> generateSamples(DataSource dataSource, int dataOffset, long dataSize, int corePresent) throws IOException {
        ByteBuffer sample;
        LookAhead la = new LookAhead(dataSource, dataOffset, dataSize, corePresent);
        ArrayList<Sample> mySamples = new ArrayList<Sample>();
        while ((sample = la.findNextStart()) != null) {
            final ByteBuffer finalSample = sample;
            mySamples.add(new Sample(){

                public void writeTo(WritableByteChannel channel) throws IOException {
                    channel.write((ByteBuffer)finalSample.rewind());
                }

                public long getSize() {
                    return finalSample.rewind().remaining();
                }

                public ByteBuffer asByteBuffer() {
                    return finalSample;
                }
            });
        }
        System.err.println("all samples found");
        return mySamples;
    }

    private int getBitRate(int rate) throws IOException {
        int bitrate;
        switch (rate) {
            case 0: {
                bitrate = 32;
                break;
            }
            case 1: {
                bitrate = 56;
                break;
            }
            case 2: {
                bitrate = 64;
                break;
            }
            case 3: {
                bitrate = 96;
                break;
            }
            case 4: {
                bitrate = 112;
                break;
            }
            case 5: {
                bitrate = 128;
                break;
            }
            case 6: {
                bitrate = 192;
                break;
            }
            case 7: {
                bitrate = 224;
                break;
            }
            case 8: {
                bitrate = 256;
                break;
            }
            case 9: {
                bitrate = 320;
                break;
            }
            case 10: {
                bitrate = 384;
                break;
            }
            case 11: {
                bitrate = 448;
                break;
            }
            case 12: {
                bitrate = 512;
                break;
            }
            case 13: {
                bitrate = 576;
                break;
            }
            case 14: {
                bitrate = 640;
                break;
            }
            case 15: {
                bitrate = 768;
                break;
            }
            case 16: {
                bitrate = 960;
                break;
            }
            case 17: {
                bitrate = 1024;
                break;
            }
            case 18: {
                bitrate = 1152;
                break;
            }
            case 19: {
                bitrate = 1280;
                break;
            }
            case 20: {
                bitrate = 1344;
                break;
            }
            case 21: {
                bitrate = 1408;
                break;
            }
            case 22: {
                bitrate = 1411;
                break;
            }
            case 23: {
                bitrate = 1472;
                break;
            }
            case 24: {
                bitrate = 1536;
                break;
            }
            case 25: {
                bitrate = -1;
                break;
            }
            default: {
                throw new IOException("Unknown bitrate value");
            }
        }
        return bitrate;
    }

    private int getSampleRate(int sfreq) throws IOException {
        int samplerate;
        switch (sfreq) {
            case 1: {
                samplerate = 8000;
                break;
            }
            case 2: {
                samplerate = 16000;
                break;
            }
            case 3: {
                samplerate = 32000;
                break;
            }
            case 6: {
                samplerate = 11025;
                break;
            }
            case 7: {
                samplerate = 22050;
                break;
            }
            case 8: {
                samplerate = 44100;
                break;
            }
            case 11: {
                samplerate = 12000;
                break;
            }
            case 12: {
                samplerate = 24000;
                break;
            }
            case 13: {
                samplerate = 48000;
                break;
            }
            default: {
                throw new IOException("Unknown Sample Rate");
            }
        }
        return samplerate;
    }

    class LookAhead {
        private final int corePresent;
        long bufferStartPos;
        int inBufferPos = 0;
        DataSource dataSource;
        long dataEnd;
        ByteBuffer buffer;
        long start;

        LookAhead(DataSource dataSource, long bufferStartPos, long dataSize, int corePresent) throws IOException {
            this.dataSource = dataSource;
            this.bufferStartPos = bufferStartPos;
            this.dataEnd = dataSize + bufferStartPos;
            this.corePresent = corePresent;
            this.fillBuffer();
        }

        public ByteBuffer findNextStart() throws IOException {
            try {
                while (!(this.corePresent == 1 ? this.nextFourEquals0x7FFE8001() : this.nextFourEquals0x64582025())) {
                    this.discardByte();
                }
                this.discardNext4AndMarkStart();
                while (!(this.corePresent == 1 ? this.nextFourEquals0x7FFE8001orEof() : this.nextFourEquals0x64582025orEof())) {
                    this.discardQWord();
                }
                return this.getSample();
            }
            catch (EOFException eOFException) {
                return null;
            }
        }

        private void fillBuffer() throws IOException {
            System.err.println("Fill Buffer");
            this.buffer = this.dataSource.map(this.bufferStartPos, Math.min(this.dataEnd - this.bufferStartPos, 0x4000000L));
        }

        private boolean nextFourEquals0x64582025() throws IOException {
            return this.nextFourEquals((byte)100, (byte)88, (byte)32, (byte)37);
        }

        private boolean nextFourEquals0x7FFE8001() throws IOException {
            return this.nextFourEquals((byte)127, (byte)-2, (byte)-128, (byte)1);
        }

        private boolean nextFourEquals(byte a, byte b, byte c, byte d) throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 4) {
                return this.buffer.get(this.inBufferPos) == a && this.buffer.get(this.inBufferPos + 1) == b && this.buffer.get(this.inBufferPos + 2) == c && this.buffer.get(this.inBufferPos + 3) == d;
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 4L >= this.dataSource.size()) {
                throw new EOFException();
            }
            return false;
        }

        private boolean nextFourEquals0x64582025orEof() throws IOException {
            return this.nextFourEqualsOrEof((byte)100, (byte)88, (byte)32, (byte)37);
        }

        private boolean nextFourEquals0x7FFE8001orEof() throws IOException {
            return this.nextFourEqualsOrEof((byte)127, (byte)-2, (byte)-128, (byte)1);
        }

        private boolean nextFourEqualsOrEof(byte a, byte b, byte c, byte d) throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 4) {
                if ((this.bufferStartPos + (long)this.inBufferPos) % 0x100000L == 0L) {
                    System.err.println("" + (this.bufferStartPos + (long)this.inBufferPos) / 1024L / 1024L);
                }
                return this.buffer.get(this.inBufferPos) == a && this.buffer.get(this.inBufferPos + 1) == b && this.buffer.get(this.inBufferPos + 2) == c && this.buffer.get(this.inBufferPos + 3) == d;
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 4L > this.dataEnd) {
                return this.bufferStartPos + (long)this.inBufferPos == this.dataEnd;
            }
            this.bufferStartPos = this.start;
            this.inBufferPos = 0;
            this.fillBuffer();
            return this.nextFourEquals0x7FFE8001();
        }

        private void discardByte() {
            ++this.inBufferPos;
        }

        private void discardQWord() {
            this.inBufferPos += 4;
        }

        private void discardNext4AndMarkStart() {
            this.start = this.bufferStartPos + (long)this.inBufferPos;
            this.inBufferPos += 4;
        }

        private ByteBuffer getSample() {
            if (this.start >= this.bufferStartPos) {
                this.buffer.position((int)(this.start - this.bufferStartPos));
                ByteBuffer sample = this.buffer.slice();
                ((Buffer)sample).limit((int)((long)this.inBufferPos - (this.start - this.bufferStartPos)));
                return sample;
            }
            throw new RuntimeException("damn! NAL exceeds buffer");
        }
    }
}

