#!/usr/bin/perl

package eBay::API::XML::DataType::XMLRequesterCredentialsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. XMLRequesterCredentialsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::XMLRequesterCredentialsType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::XMLRequesterCredentialsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Password', 'xs:string', '', '', '' ]
	, [ 'Username', 'xs:string', '', '', '' ]
	, [ 'eBayAuthToken', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setPassword()

Password for the user specified in Username.

#    Argument: 'xs:string'

=cut

sub setPassword {
  my $self = shift;
  $self->{'Password'} = shift
}

=head2 getPassword()

#    Returns: 'xs:string'

=cut

sub getPassword {
  my $self = shift;
  return $self->{'Password'};
}


=head2 setUsername()

eBay user ID (i.e., eBay.com Web site login name) for the user the application
is retrieving a token for. This is typically the application's end-user (not
the developer).

MaxLength: 64

  Calls: FetchToken
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setUsername {
  my $self = shift;
  $self->{'Username'} = shift
}

=head2 getUsername()

#    Returns: 'xs:string'

=cut

sub getUsername {
  my $self = shift;
  return $self->{'Username'};
}


=head2 setEBayAuthToken()

Authentication token representing the user who is making the request. The
user's token must be retrieved from eBay. To determine a user's authentication
token, see the Authentication and Authorization information in the eBay Web
Services guide. For calls that list or retrieve item or transaction data, the
user usually needs to be the seller of the item in question or, in some cases,
the buyer. Similarly, calls that retrieve user or account data may be
restricted to the user whose data is being requested. The documentation for
each call includes information about such restrictions.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization
MaxLength: 2000

  Calls:   RequiredInput: Yes
  AllCallsExcept: FetchToken

#    Argument: 'xs:string'

=cut

sub setEBayAuthToken {
  my $self = shift;
  $self->{'eBayAuthToken'} = shift
}

=head2 getEBayAuthToken()

#    Returns: 'xs:string'

=cut

sub getEBayAuthToken {
  my $self = shift;
  return $self->{'eBayAuthToken'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
