package Daje::Workflow::GenerateSQL::Activity;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;

# NAME
# ====
##
# Daje::Workflow::GenerateSQL::Activity - It's to generate SQL from a json description
#
# SYNOPSIS
# ========
##
#     use Daje::Workflow::GenerateSQL::Activity;
#
#     my $object = $activity->{activity}->new(
#             context       => $context,
#             db            => $>db,
#             error         => $error,
#             model         => $model,
#             activity_data => $activity_data,
#         );
#
#     $object->process();
#
# DESCRIPTION
# ===========
##
# Daje::Workflow::GenerateSQL::Activity is ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

our $VERSION = "0.08";

use Mojo::File;
use Daje::Workflow::GenerateSQL::Manager::Sql;
use Daje::Tools::Datasections;
use Daje::Config;

sub process ($self) {

    my @data;
    my $files_list = $self->context->{context}->{changed_files};
    my $length = scalar @{$files_list};
    for (my $i = 0; $i < $length; $i++) {
        if ($self->error->has_error() == 0) {
            if (my $sql = $self->_process_sql(@{$files_list}[$i])) {
                my $data->{data} = $sql;
                $data->{file} = Mojo::File->new(@{$files_list}[$i])->basename;
                $data->{file} =~ s/.json//g;
                push(@data, $data);
                $self->model->insert_history(@{$files_list}[$i], "Daje::Workflow::GenerateSQL::Activity;");
            }
        }
    }
    $self->context->{context}->{sql} = \@data;

    return;
}

sub _process_sql($self, $file) {
    my $sql = "";
    eval {
        my $table = $self->_load_table($file);
        $table->generate_table();
        $sql = $table->sql();
    };
    $self->error->add_error($@) if defined $@;



     # try {
     #     Daje::Generate::Output::Sql::SqlManager->new(
     #        config => $self->config,
     #        file   => $file,
     #         sql    => $sql,
     #     )->save_file();
     # } catch ($e) {
     #     die "Could not create output '$e'";
     # };

     return $sql;
}

sub _load_table($self, $file) {

    my $json = Daje::Config->new()->load_json($file);
    my $templates = $self->_load_templates();
    my $table;

    eval {
        $table = Daje::Workflow::GenerateSQL::Manager::Sql->new(
            templates => $templates,
            json     => $json,
            error    => $self->error,
        );
    };
    $self->error->add_error($@) if defined $@ and length($@) > 0;

    return $table;
}

sub _load_templates($self) {
    my $template;
    eval {
        $template = Daje::Tools::Datasections->new(
            data_sections => $self->activity_data->{template}->{data_sections},
            source        => $self->activity_data->{template}->{source},
        );
    };
    $self->error->add_error($@) if defined $@;

    $template->load_data_sections();
    $self->error->add_error($template->error());

    return $template;
}



1;
__END__





#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::GenerateSQL::Activity - It's to generate SQL from a json description



=head1 SYNOPSIS


    use Daje::Workflow::GenerateSQL::Activity;

    my $object = $activity->{activity}->new(
            context       => $context,
            db            => $>db,
            error         => $error,
            model         => $model,
            activity_data => $activity_data,
        );

    $object->process();



=head1 DESCRIPTION


Daje::Workflow::GenerateSQL::Activity is ...



=head1 REQUIRES

L<Config::Tiny> 

L<Daje::Tools::Datasections> 

L<Daje::Workflow::GenerateSQL::Manager::Sql> 

L<Mojo::Base> 


=head1 METHODS

=head2 process

 process();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

