/*
 * ba_xor_ba.c -- xor a set with another set
 *
 * Part of publib.  See man page for more information
 * "@(#)publib-bitarr:ba_xor_ba.c,v 1.2 1993/11/29 19:41:42 liw Exp"
 */

#include <assert.h>
#include "publib/bitarr.h"

void ba_xor_ba(Bitarr *u1, const Bitarr *u2) {
	size_t i, size, u2size;

	assert(u1 != NULL);
	assert(u2 != NULL);
	assert(u1->rnglen == 0 || u1->w != NULL);
	assert(u2->rnglen == 0 || u2->w != NULL);

	size = ba_num2word(u1->rnglen);
	u2size = ba_num2word(u2->rnglen);
	if (u2size < size)
		size = u2size;
	for (i = 0; i < size; ++i)
		u1->w[i] ^= u2->w[i];
}
