/*
 * ba_resize.c -- change size of set
 *
 * Part of publib.  See man page for more information
 * "@(#)publib-bitarr:ba_resize.c,v 1.3 1994/07/16 15:28:30 liw Exp"
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "publib/bitarr.h"
#include "publib/errormsg.h"

int ba_resize(Bitarr *u, size_t rnglen) {
	size_t oldsize, newsize;
	unsigned *w;

	assert(u != NULL);

	oldsize = ba_num2word(u->rnglen);
	newsize = ba_num2word(rnglen);
	w = realloc(u->w, newsize);
	if (w == NULL) {
		__publib_error("realloc failed");
		return -1;
	}

	if (oldsize < newsize)
		memset(w + oldsize, 0, newsize - oldsize);

	u->w = w;
	u->rnglen = rnglen;
	return 0;
}
