/*
 * ba_copy.c -- create a copy of a set
 *
 * Part of publib.  See man page for more information
 * "@(#)publib-bitarr:ba_copy.c,v 1.3 1994/07/16 15:28:25 liw Exp"
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "publib/bitarr.h"
#include "publib/errormsg.h"

Bitarr *ba_copy(const Bitarr *u) {
	Bitarr *uc;

	assert(u != NULL);
	assert(u->rnglen == 0 || u->w != NULL);

	uc = ba_create();
	if (uc == NULL) {
		__publib_error("ba_create failed");
		return NULL;
	}
	if (ba_resize(uc, ba_num2word(u->rnglen)) == -1) {
		__publib_error("ba_resize failed");
		return NULL;
	}
	memcpy(uc->w, u->w, ba_num2word(u->rnglen));
	return uc;
}
