extern int verbose;
#include <stdio.h>

#include "xyplot.h"

extern struct xy xd;
extern struct xy yd;

extern float titlesize;    /* title character size */
extern float xtitlesize;   /* x title character size */
extern float ytitlesize;   /* y title character size */
extern float titlex;
extern float titley;
extern float xtitlex;
extern float xtitley;
extern float ytitlex;
extern float ytitley;
extern int   titleatopf;
extern int   titlexf;
extern int   titleyf;
extern int   xtitlexf;
extern int   xtitleyf;
extern int   ytitlexf;
extern int   ytitleyf;
extern int   ytitlehf;       /* write y title horizontally */

extern char  titlebuf[];
extern char  xtitlebuf[];
extern char  ytitlebuf[];

extern int leftx;
extern float overallsize;
extern float lblwidth;
extern float numlblsize;

extern int tickSize;
#define TickSize tickSize

title()
{
    int   ix, iy;

	neww(lblwidth);
	newm(1);
 
    if (*titlebuf) {
        utou(titlebuf);
        ix = titlexf ?
            titlex * (xd.xtop - xd.xbot) + xd.xbot :
            (xd.xtop + xd.xbot) / 2.;
        iy = titleyf ?
            titley * (yd.xtop - yd.xbot) + yd.xbot :
				( titleatopf ?
				 yd.xtop + 2*neg(TickSize) + 1.5*TitleSize :
				 yd.xtop - 3*pos(TickSize) - 1.5*TitleSize);
        cascii(titlebuf, ix, iy, titleSize);
    }
    if (*xtitlebuf) {
        utou(xtitlebuf);
        ix = xtitlexf ?
            xtitlex * (xd.xtop - xd.xbot) + xd.xbot :
            (xd.xtop + xd.xbot) / 2.;
        iy = xtitleyf ?
            xtitley * (yd.xtop - yd.xbot) + yd.xbot :
            yd.xbot - (3*NumlblSize + 1.5*xTitleSize)
				- 2*neg(TickSize + 0.4*SSize);
        cascii(xtitlebuf, ix, iy, xtitleSize);
    }
    if (*ytitlebuf) {
        utou(ytitlebuf);
        ix = ytitlexf ?
            ytitlex * (xd.xtop - xd.xbot) + xd.xbot :
            leftx - 1.5*yTitleSize;
        iy = ytitleyf ?
            ytitley * (yd.xtop - yd.xbot) + yd.xbot :
            (yd.xtop + yd.xbot) / 2;
		if (verbose) fprintf(stderr,"title: ix=%d,leftx=%d\n",ix,leftx);
		if (ytitlehf)
			rascii(ytitlebuf, ix, iy, ytitleSize);
		else
			cvascii(ytitlebuf, ix, iy, ytitleSize);
    }
}


/* ----------------------- bounding box -------------------------- */
/* this provides a bounding box for a single graph; note that
 * on pages in which several graphs are superimposed, several
 * calls will be made to bbox(). it will be up to the xyps filter
 * to combine them all into a single postscript BoundingBox value
 */

bbox(xd,yd)
struct xy *xd,*yd;
{
	int xtop,ytop,xbot,ybot;
	extern FILE *outputfile;
	
	/*
	 * set ytop
	 */

	if (titleyf && titley > 1.0) {  /* if title on top defined by titley */
		ytop = titley * (yd->xtop - yd->xbot) + yd->xbot + TitleSize;
	}
	else {
		if (titleatopf) {
			ytop = yd->xtop + TSIZE + 2*neg(TickSize) + 2*TitleSize;
		}
		else /* default */
		ytop = yd->xtop + TSIZE + 2*neg(TickSize);
	}

	/*
	 * set xtop, need to make room for outward ticks; 
	 *           also for rightmost x-numlabel values
	 *           the factor 2*NumlblSize is a guess; will be too
	 *           small if the label is a big number
	 */

	xtop = xd->xtop + TSIZE + 2*neg(TickSize) + 2*NumlblSize;

	/*
	 * set xbot, be sure to make room for y-numlabels and y-axislabel
	 * use leftx, since don't know width of y-numlabels
	 */

	xbot = leftx - 2.5*yTitleSize;

	/* 
	 * set ybot, may need to make room for x-numlabels and x-axislabel
	 */
	 
	ybot = yd->xbot - (3*NumlblSize + 2*xTitleSize + 2*neg(TickSize));

#if 0
	/* this puts bbox just around essential graph */
    fprintf(outputfile,"b %6d %6d %6d %6d\n",
			xd->xbot,
			yd->xbot,
			xd->xtop,
			yd->xtop
    );
#else
	/* this puts bbox around labels and titles as well as graph */
    fprintf(outputfile,"b %6d %6d %6d %6d\n",
			xbot,
			ybot,
			xtop,
			ytop
    );
#endif
}
 
