/* size.c */ 

/* stack of plotsizes, for nestable #size command */

#include <stdio.h>

extern float overallsize;
extern float overallxoff;
extern float overallyoff;
 
struct {
	float s,x,y;
	int   flag;
} szstack[10];
int n_stack=0;
 
initstack()
{
	n_stack=0;
	szstack[n_stack].s = overallsize;
	szstack[n_stack].x = overallxoff;
	szstack[n_stack].y = overallyoff;
	purepush();
}
purepush()
{
	++n_stack;
	szstack[n_stack].s = 1.0;
	szstack[n_stack].x = 0.0;
	szstack[n_stack].y = 0.0;
}
size(s,x,y)
float s,x,y;
{
	popsize();
	pushsize(s,x,y);
}
 
pushsize(s,x,y)
float s,x,y;
{
	++n_stack;
	if (n_stack >= 10)
		fatal("overflow of the size-stack");
	
	szstack[n_stack].s = s;
	szstack[n_stack].x = x;
	szstack[n_stack].y = y;
	overallxoff += overallsize*x;
	overallyoff += overallsize*y;
	overallsize *= s;
}
popsize()
{
	if (n_stack<0)
	{
		fprintf(stderr,"xyplot: Error popping size stack");
		n_stack = 0;
	}
	overallsize /= szstack[n_stack].s;
	overallxoff -= szstack[n_stack].x * overallsize;
	overallyoff -= szstack[n_stack].y * overallsize;
 
	--n_stack;
	if (n_stack < 0)
		n_stack = 0;
 
}
