/**********************************************************************
*                     panel.c                                         *
*                                                                     *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.   *
*                                                                     *
*  This module contains code to handle TIS menus.                     *
*                                                                     *
* 160395 -HT- Very first version.                                     *
* 190395 -HT- Whole idea is now reorganized.                          *
* 200395 -HT- At least it works, and it works perfect.                *
*             (In fact nothing really happens when menu is selected)  *
* 210395 -HT- Change between menus is now automatically detected.     *
* 220395 -HT- Window is now auto resized if menus will not fit on it. *
*             (It left some mess on the window)                       *
* 230395 -HT- At least it works, and it works perfect. (As on Mar20)  *
* 250395 -HT- Some new menus and call to HandleMenuEvent() add.       *
* 030495 -HT- Empty menu titles are now taken special care of.        *
*             Radio toggle button system seems to work.               *
* 070495 -HT- New function OperateRadio() created = code reorganized. *
* 120495 -HT- Some new submenus.                                      *
* 130495 -HT- A lot of new submenus.                                  *
* 270495 -HT- New menus...                                            *
* 040595 -HT- ..                                                      *
* 160595 -HT- Makefile support.                                       *
**********************************************************************/ 

#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

char nMenus=7, Menu_h[7]={5,4,4,9,10,6,17}, Menu_w[7]={9,12,14,14,15,12,19};
char Menu[7][17][26]={
  {{"Picture"},{"Load     (l)"},{"Save     (s)"},{"About    (a)"},{"Quit     (q)"}},
  {{"Tools"},{"Pen"},{"Rectangle"},{"Filled rect."}},
  {{"Images"},{"Master      (F1)"},{"Primary     (F2)"},{"Secondary   (F3)"}},
  {{"Modes"},{"Unite"},{"Paint"},{""},{"Area (20x20)   (1)"},{"Area (5x5)     (2)"},
   {"Grid (10x10|2) (3)"},{"Grid (6x6|3)   (4)"},{"Single dots    (5)"}},
  {{"Region"},{"Select"},{"Select all"},{"Unselect"},{"Cut"},{"Copy"},
   {"Clear"},{"Paste"},{"Crop to Image"},{"Change Handle  (TAB)"}},
  {{"Effects"},{"Flip Horiz"},{"Flip Vert"},{"Rotate right"},
   {"Rotate left"},{"Negative"}},
  {{"Other"},{"Primary->Master"},{"Secondary->Master"},{"Master->Primary"},{""},
   {"Master<->Primary"},{"Master<->Secondary"},{"Primary<->Secondary"},{""},
   {"Image Info"},{"Set Size"},{"Set Offset"},{"Auto Set"}, {"Offset Origo"},{""},
   {"Auto Resize Window    (w)"}, {"Refresh Window        (r)"}}
  };
unsigned char Radio[7][17]={
  {0, 0, 0, 0, 0}, {0, 1|16, 1, 1}, {0, 2|16, 2, 2},
  {0, 3|16, 3, 0, 4|16, 4, 4, 4, 4}, {0, 1, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
  };
int Menux[8];
/* static XImage *storage_block_xi; */

HandlePanel( mx )
int mx;
{
  unsigned char i, m=100, csub=100, sel;

  for( i=0; i<nMenus; i++ )
    if( mx>Menux[i] && mx<Menux[i+1] )
      m=i;
  if( m>99 )
    return;

  /*printf("Menu %d\n", m);*/

  DrawMenu( m );

  while(1)
  {
    XNextEvent(theDisplay, &theEvent);

    switch (theEvent.type) {
          case Expose:
            printf("Window is exposed!\n");
            Refresh( Cur_Image );
            RemoveMenu(m);
            DrawPanel();
            DrawMenu(m);
            break;

          case KeyPress:
            printf("The panel button was pressed. %d\n",theEvent.xkey.keycode );
            break;

          case MotionNotify:
            sel=100;
            for( i=0; i<nMenus; i++ )
              if( theEvent.xmotion.x>Menux[i] && theEvent.xmotion.x<Menux[i+1]
                  && theEvent.xmotion.y>0 && theEvent.xmotion.y<15 )
                sel=i;
            if( sel!=m && sel!=100 )
              {
              RemoveMenu(m);
              m=sel;
              DrawMenu(m);
              }

            sel=100;
            for( i=0; i<Menu_h[m]-1; i++ )
              if( theEvent.xmotion.x>Menux[m] && theEvent.xmotion.x<Menux[m]+10+Menu_w[m]*8+10
                  && theEvent.xmotion.y>15+i*15 && theEvent.xmotion.y<=30+i*15
                  && Menu[m][i+1][0]!=0 )
                sel=i;
            if( sel!=csub )
              {
              if( csub!=100 )
                {
                XSetForeground( theDisplay, theGC, theWhitePixel );
                XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+1, 15+csub*15+1, 10+Menu_w[m]*8+7, 16 );
                XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+2, 15+csub*15+2, 10+Menu_w[m]*8+6, 14 );
                }
              csub=sel;
              /*printf("csub: %d\n", csub );*/
              if( csub!=100 )
                {
                XSetForeground( theDisplay, theGC, theBlackPixel );
                XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+1, 15+csub*15+1, 10+Menu_w[m]*8+7, 16 );
                XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+2, 15+csub*15+2, 10+Menu_w[m]*8+6, 14 );
                }
              }
            break;
          
          case ButtonRelease:
            RemoveMenu(m);
            if( csub!=100 )
              {
              if( Radio[m][csub+1] )
                OperateRadio( m, csub );
              printf("Menu %d.%d\n",m,csub);
              HandleMenuEvent( m, csub );
              }            
            return;
            break;
      }
  }
}

DrawPanel()
{
  int m, x=0;

  XClearArea(theDisplay, theWindow, 0, 0, WIDTH, 15, False );
  XSetForeground(theDisplay, theGC, theBlackPixel );
  XDrawLine(theDisplay, theWindow, theGC, 0, 14, 467, 14 );
  /*XDrawString(theDisplay, theWindow, theGC, 10, 10, "The Image Studio", strlen("The Image Studio") );*/
  Menux[0]=0;
  XDrawLine(theDisplay, theWindow, theGC, 0, 0, 0, 14 );
  for( m=0; m<nMenus; m++ )
    {
    x+=10;
    XDrawString(theDisplay, theWindow, theGC, x, 11, Menu[m][0], strlen(Menu[m][0]) );
    x+=8*strlen(Menu[m][0])+10;
    XDrawLine(theDisplay, theWindow, theGC, x, 0, x, 14 );
    Menux[m+1]=x;
    }
}

DrawMenu( m )
unsigned char m;
{
  unsigned char i;
  XWindowAttributes theAttributes;

  XGetWindowAttributes( theDisplay, theWindow, &theAttributes );

  if( theAttributes.width<Menux[m]+10+Menu_w[m]*8+10 )
    {
    if( theAttributes.height<15+Menu_h[m]*15-11 )
      XResizeWindow(theDisplay, theWindow, Menux[m]+10+Menu_w[m]*8+10+10,
                    15+Menu_h[m]*15-11 );
    else
      XResizeWindow(theDisplay, theWindow, Menux[m]+10+Menu_w[m]*8+10, 
                  theAttributes.height );
    XFlush(theDisplay); sleep(1);
    Refresh( Cur_Image );
    /*XFlush(theDisplay);*/ /*sleep(2);*/
    }
  else if( theAttributes.height<15+Menu_h[m]*15-11 )
    {
    XResizeWindow(theDisplay, theWindow, theAttributes.width,
                  15+Menu_h[m]*15-11 );
    XFlush(theDisplay); sleep(1);
    Refresh( Cur_Image );
    /*XFlush(theDisplay);*/ /*sleep(2);*/
    }

  storage_block_xi = XGetImage(theDisplay, theWindow, Menux[m], 15, 
                               10+Menu_w[m]*8+10, Menu_h[m]*15-11,
                               255, ZPixmap);

  XSetForeground( theDisplay, theGC, theBlackPixel );
  XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+1, 0, Menux[m+1]-Menux[m]-2, 13 );
  XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+2, 1, Menux[m+1]-Menux[m]-3, 12 );
  /*printf("Clear %d %d %d %d\n", Menux[m], 15, 10+Menu_w[m]*8+10, 
          Menu_h[m]*10-10 );*/
  XClearArea(theDisplay, theWindow, Menux[m], 15, 10+Menu_w[m]*8+10, Menu_h[m]*15-12, False );
  XFlush( theDisplay );
  XDrawRectangle( theDisplay, theWindow, theGC, Menux[m], 15, 10+Menu_w[m]*8+9, Menu_h[m]*15-12 );
  for( i=1; i<Menu_h[m]; i++ )
    if( Radio[m][i] )
      {
      if( Radio[m][i]&16 )
        {
        XDrawLine( theDisplay, theWindow, theGC, Menux[m]+7, 13+i*15-5, 
                   Menux[m]+10, 13+i*15-1 );
        XDrawLine( theDisplay, theWindow, theGC, Menux[m]+10, 13+i*15-1, 
                   Menux[m]+14, 13+i*15-8 );
        }
      XDrawString(theDisplay, theWindow, theGC, Menux[m]+17, 13+i*15, 
                  Menu[m][i], strlen(Menu[m][i]) );
      }
    else
      XDrawString(theDisplay, theWindow, theGC, Menux[m]+10, 13+i*15, 
                  Menu[m][i], strlen(Menu[m][i]) );
}

RemoveMenu( m )
unsigned char m;
{
  XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
            0, 0, Menux[m], 15, 10+Menu_w[m]*8+10, Menu_h[m]*15-11 );
  XSetForeground( theDisplay, theGC, theWhitePixel );
  XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+1, 0, Menux[m+1]-Menux[m]-2, 13 );
  XDrawRectangle( theDisplay, theWindow, theGC, Menux[m]+2, 1, Menux[m+1]-Menux[m]-3, 12 );
}

OperateRadio( m, csub )
unsigned char m, csub;
{
  unsigned char togl, tx, ty;

  togl=Radio[m][csub+1]&15;
  printf("togl: %d\n", togl);
  for( tx=0; tx<nMenus; tx++ )
    for( ty=1; ty<Menu_h[tx]; ty++ )
      if( (Radio[tx][ty]&15)==togl )
        Radio[tx][ty]=togl;
  Radio[m][csub+1]=Radio[m][csub+1]|16;
}
