/*******************************************************************
*                     main.c                                       *
*                                                                  *
* Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info. *
*                                                                  *
*                     The Mapper (C)1995                           *
*                                                                  *
* 170295 -HT- Window opens and the cursor is set.                  *
* 180295 -HT- Targas and XBMs works, but not at the same time.     *
* 190295 -HT- TGAs, XBMs and PPMs are supported and automatically  *
*             detected. Own mouse cursor is created.               *
*                                                                  *
*                     The Image Studio (C)1995                     *
*                                                                  *
* 060395 -HT- Loads two xbm images into buffer and views them.     *
*             TGAs and PPMs are not supported at the moment.       *
*             Special cursor is now set as XC_crosshair.           *
* 090395 -HT- It works. It really is not easy to use. It crashes   *
*             all the time and result is not very good. But works. *
* 160395 -HT- First version of control panel.                      *
* 180395 -HT- First version of menu like control system.           *
* 250395 -HT- We will generate empty image if image file cannot    *
*             be loaded for some reason.                           *
* 270395 -HT- MakeImage() is reorganized, empty image is now        * 
*             generated also for second image.                       *
* 030495 -HT- Load, Save, About and Quit are working fine.           *
* 070495 -HT- Many critical parts of code is now reorganized.        *
*             Pen Unite command works fine with all styles (one      *
*             new style is add). All images can now be moved around. *
* 080495 -HT- Pen Paint command works fine with all styles and in    *
*             all images.                                            *
* 090495 -HT- A lot of reorganization work is done. Images are now    *
*             in one table, and so are also XImages and xi_datas.      *
*             MakeImage() is shorter, Refresh() is faster, etc.         *
*             Some functions are clipped to other files.                 *
* 100495 -HT- Call to Rectangle().                                        *
* 120495 -HT- Rectangle and Filled rectangle work with all modes          *
*             and all styles.                                             *
* 130495 -HT- Window starting size changed, q is new shortcut for quit.   *
* 160495 -HT- We are using MoveImageResponsibility().                     *
* 260495 -HT- Some reorganization.                                        *
* 280495 -HT- Select, Select All and Unselect are working now. New global *
*             structure ThatBox is created. It includes region box info.  *
* 290495 -HT- Many little things that have something to do with region    *
*             functions.                                                  *
* 040595 -HT- Paste support add: PasteBox struct.                         *
* 060595 -HT- "Little" bug in window resizing fixed.                      *
* 070595 -HT- Change Handle add.                                          *
* 080595 -HT- Little "bug" in GetUpSystem_GetUp() fixed.                  *
* 110595 -HT- We are now quessing following KeyPress and Expose events    *
*             in Check_Events(). Great.                                   *
* 160595 -HT- Makefile support.                                           *
* 230595 -HT- PasteBox refreshing add in Refresh(). Refreshing when       *
*             starting add (this is not necessary in all platforms).      *      
**************************************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
/*#include <math.h>*/
#include "image.h"
/*#include "rtga.c"  colors are not supported */
/*#include "rppm.c"                           */
#include "icon.h"

Display *theDisplay;
int     theScreen;
int     theDepth;
unsigned long theBlackPixel;
unsigned long theWhitePixel;
XEvent  theEvent;
Window  theWindow;
GC      theGC;

struct Image_Struct One_Image[4]; /* Images are in one table! */
struct Image_Struct Fake_Image;   /* This is not fake at all. */
struct Image_Struct Clip_Image;
XImage *image_xi[4]; /*   Image XImages are in one table! */
char *xi_data[4];           /*   XImage datas are in one table!  */
XImage *storage_block_xi;   /* This is used in requesters and menus */
struct Box_Struct ThatBox;  /*   Region box struct! */
struct Box_Struct PasteBox; /*   Paste box struct!  */

long     colormap[256];
short offs_X[4]={0,0,0,0}, offs_Y[4]={0,0,0,0};
XWindowAttributes attr;
char Cur_Image=3;
char mode=1;
char tool=1;
char old_tool; /*  <-- What are we having here? */
char style=1;
char handle=0;  /* Clip handle place */

/* Event mask: */
#define EV_MASK (ButtonPressMask  | \
                 ButtonReleaseMask| \
                 ButtonMotionMask | \
                 KeyPressMask     | \
                 ExposureMask     | \
                 StructureNotifyMask)

#define WIDTH   580 /* Minimum size of the window */
#define HEIGHT  250
#define MARGIN   15 /* Menu height */
/* #include "panel.c"          <--------
#include "menue.c"
#include "get_string.c"
#include "load_save.c"
#include "mesg.c"
#include "question.c"
#include "tools.c"
#include "other.c"
#include "misc.c"
#include "lmesg.c"
#include "region.c"
#include "effects.c" */

GetUpSystem_GetUp()
{
  XSetWindowAttributes theWindowAttributes;
  XSizeHints           theSizeHints;
  unsigned long     theWindowMask;
  Pixmap            theIconPixmap;
  XWMHints          theWMHints;
  Cursor cursor;
  /*Pixmap source, mask;
  XColor fg,bg;*/

  /* Connect to the X server. */
  theDisplay = XOpenDisplay(NULL);
  if( theDisplay==NULL )
    {
    printf("Cannot connect to the X server.\n");
    exit(0);
    }

  theScreen = DefaultScreen(theDisplay);
  theDepth = DefaultDepth(theDisplay, theScreen);
  theWhitePixel = WhitePixel(theDisplay, theScreen);
  theBlackPixel = BlackPixel(theDisplay, theScreen);
  printf("depth: %d\n",theDepth);

  /* Set up some attributes for the window. */
  theWindowAttributes.border_pixel = theBlackPixel;
  theWindowAttributes.background_pixel = theWhitePixel;
  theWindowAttributes.override_redirect = False;
  theWindowAttributes.event_mask = EV_MASK; 
  theWindowMask = CWBackPixel | CWBorderPixel | CWOverrideRedirect;

  /* Let's open it. */
  theWindow = XCreateWindow(theDisplay, RootWindow(theDisplay,theScreen),
                            0, 0, WIDTH, HEIGHT+MARGIN, 2, theDepth, InputOutput,
                            CopyFromParent, theWindowMask, &theWindowAttributes);

  /* Create the iconbixmap */
  theIconPixmap = XCreateBitmapFromData(theDisplay, theWindow, icon_bits,
                                        icon_width, icon_height);

  /* Hints: where to put the window etc. */
  theWMHints.icon_pixmap = theIconPixmap;
  theWMHints.initial_state = NormalState;
  theWMHints.flags = IconPixmapHint | StateHint;

  XSetWMHints(theDisplay, theWindow, &theWMHints);

  theSizeHints.flags = PPosition | PSize;
  theSizeHints.x = 0;
  theSizeHints.y = 0;
  theSizeHints.width = WIDTH;
  theSizeHints.height = HEIGHT+MARGIN;
  theSizeHints.min_width = WIDTH;
  theSizeHints.min_height = HEIGHT+MARGIN;
  theSizeHints.max_width = WIDTH;
  theSizeHints.max_height = HEIGHT+MARGIN;

  XSetNormalHints(theDisplay, theWindow, &theSizeHints);

  if( createGC(theWindow, &theGC)==0 )
    Quit("Cannot create the GC.\n");

  XStoreName(theDisplay, theWindow, "TIS");

  XMapWindow(theDisplay, theWindow);

  /* Set cursor */
  cursor = XCreateFontCursor(theDisplay,XC_crosshair);
  /*fg.red=255<<8;
  bg.blue=255<<8;
  source = XCreateBitmapFromData(theDisplay, theWindow, cursor_bits,
                                 cursor_width, cursor_height );
  mask = XCreateBitmapFromData(theDisplay, theWindow, cursorm_bits,
                                 cursorm_width, cursorm_height );
  cursor = XCreatePixmapCursor(theDisplay,source,mask,&fg,&bg,0,0);*/
  XDefineCursor(theDisplay,theWindow,cursor);
  XFlush(theDisplay);
}

/* Creates a new graphics context */

createGC( theNewWindow, theNewGC)
Window  theNewWindow;
GC      *theNewGC;
{
  XGCValues       theGCValues;

  *theNewGC = XCreateGC(theDisplay, theNewWindow, (unsigned long) 0,
                        &theGCValues);

  if( *theNewGC==0 )
    return (0);    
    
  /* set foreground and background defaults for the new GC */
  XSetForeground(theDisplay, *theNewGC, theBlackPixel);
  XSetBackground(theDisplay, *theNewGC, theWhitePixel);

  return (1);   /* OK */
}

main( argc, argv )
int argc;
char *argv[];
{
  unsigned char File=1;
  short n_WIDTH, n_HEIGHT;

  if( argc>1 )
    if( argv[1][0]=='-' ) {
    printf("Usage: tis [filename] [filename]\n");
    exit();
    }
  if( argc>3 ) {
    printf("Usage: tis [filename] [filename]\n");
    exit();
    }

  /*strncpy( text, argv[1], strlen(argv[1]) );*/

  GetUpSystem_GetUp();

  XSelectInput(theDisplay, theWindow, EV_MASK);

  /*File = QuessFileFormat( argv[1] );*/

  /* Primary image: */
  if( argc<2 )
    Make_Empty_Image( &Fake_Image, 10, 10 );
  else
    if( Read_XBM_Image( &Fake_Image, argv[1] ) )
      {
      printf("Cannot load %s\n", argv[1] );
      Make_Empty_Image( &Fake_Image, 10, 10 );
      }
  MoveImageResponsibility( &Fake_Image, &One_Image[1] );
  /*One_Image[1].width = Fake_Image.width;
  One_Image[1].height = Fake_Image.height;
  One_Image[1].Colour_Map_Size = Fake_Image.Colour_Map_Size;
  One_Image[1].Colour_Map = Fake_Image.Colour_Map;
  One_Image[1].data.rgb_lines = Fake_Image.data.rgb_lines;
  One_Image[1].data.map_lines = Fake_Image.data.map_lines;*/

  /* Secondary image: */
  if( argc<3 )
    Make_Empty_Image( &Fake_Image, 10, 10 );
  else
    if( Read_XBM_Image( &Fake_Image, argv[2] ) )
      {
      printf("Cannot load %s\n", argv[2] );
      Make_Empty_Image( &Fake_Image, 10, 10 );
      }
  MoveImageResponsibility( &Fake_Image, &One_Image[2] );
  /*One_Image[2].width = Fake_Image.width;
  One_Image[2].height = Fake_Image.height;
  One_Image[2].Colour_Map_Size = Fake_Image.Colour_Map_Size;
  One_Image[2].Colour_Map = Fake_Image.Colour_Map;
  One_Image[2].data.rgb_lines = Fake_Image.data.rgb_lines;
  One_Image[2].data.map_lines = Fake_Image.data.map_lines;*/

  Make_Empty_Image( &One_Image[3], 10, 10 );
  /*switch( File ) {
    case 1:
      printf("XBM\n");
      Read_XBM_Image( &Oma_Image, argv[1] );
      break;
    case 2:
      printf("TGA\n");
      Read_TGA_Image( &Oma_Image, argv[1] );
      break;
    case 3:
      printf("PPM\n");
      Read_PPM_Image( &Oma_Image, argv[1] );
      break;
    default:
      Quit("Cannot recognize the file format.\n");
    }*/
 
  BuildColormap( &One_Image[1] );

  if( One_Image[1].width>WIDTH || One_Image[1].height>HEIGHT )
    {
    if( One_Image[1].width>WIDTH )
      n_WIDTH=One_Image[1].width;
    else
      n_WIDTH=WIDTH;
    if( One_Image[1].height>HEIGHT )
      n_HEIGHT=One_Image[1].height;
    else
      n_HEIGHT=HEIGHT;
    XResizeWindow(theDisplay, theWindow, n_WIDTH, n_HEIGHT+MARGIN );
    }
  printf("db1\n");
  MakeImage( 1 );
  MakeImage( 2 );
  MakeImage( 3 );
  printf("db2\n");

  /* This isn't necessary in all platforms. TIS starts faster if you remove this: */ 
  Refresh( Cur_Image );
  DrawPanel();

  Check_Events();
}

Quit( mesg )
char *mesg;
{
  printf("%s\n",mesg);
  XDestroyWindow(theDisplay, theWindow);
  XFlush(theDisplay);
  XCloseDisplay(theDisplay);
  exit(0);
}

Check_Events()
{
  unsigned char result;
  XEvent secEvent;

  while(1)
  {
  /*while (XPending(theDisplay) > 0) {   now deal with the events.. */

    XNextEvent(theDisplay, &theEvent); /* <- the smart way */

    smart_jump_again:
    if( XPending(theDisplay) > 0 )
      {
      XPeekEvent(theDisplay, &secEvent);
      if( secEvent.type==theEvent.type )
        {
        if( secEvent.type==KeyPress
          && (secEvent.xkey.keycode==98||secEvent.xkey.keycode==100
              ||secEvent.xkey.keycode==102||secEvent.xkey.keycode==104) )
          {
          XNextEvent( theDisplay, &secEvent );
          if( secEvent.xkey.keycode==98  ) offs_Y[Cur_Image]-=1;
          if( secEvent.xkey.keycode==100 ) offs_X[Cur_Image]-=1;
          if( secEvent.xkey.keycode==102 ) offs_X[Cur_Image]+=1;
          if( secEvent.xkey.keycode==104 ) offs_Y[Cur_Image]+=1;
          goto smart_jump_again;
          }
        if( secEvent.type==Expose )
          {
          printf("smart expose\n");
          XNextEvent( theDisplay, &secEvent );
          goto smart_jump_again;
          }          
        }
      }

        switch (theEvent.type) {
          case Expose:
            /*printf("Window is exposed!\n");*/
            Refresh( Cur_Image );
            DrawPanel();
            break;

          case MapNotify:
            /*printf("The window is mapped.\n");*/
            break;

          case ButtonPress:
            /*printf("A mouse button was pressed. %d\n",
                    theEvent.xbutton.button );*/
            if( theEvent.xbutton.y<MARGIN )
              HandlePanel( theEvent.xbutton.x );
            else if( !(Cur_Image!=3 && mode==1 && tool<10) )
              {
              if( tool==1 ) /* Mode doesn't matter cause handled later */
                {                /** Pen **/
                if( theEvent.xbutton.button==1 )
                  WorkStyle( theEvent.xbutton.x, theEvent.xbutton.y-MARGIN, 2 );
                else
                  WorkStyle( theEvent.xbutton.x, theEvent.xbutton.y-MARGIN, 1 );
                }
              if( tool==2 ) /** Rectangle **/
                {
                if( theEvent.xbutton.button==1 )
                  Rectangle( theEvent.xbutton.x, theEvent.xbutton.y, 2, 0 );
                else
                  Rectangle( theEvent.xbutton.x, theEvent.xbutton.y, 1, 0 );
                }
              if( tool==3 ) /** Filled Rectangle **/
                {
                if( theEvent.xbutton.button==1 )
                  Rectangle( theEvent.xbutton.x, theEvent.xbutton.y, 2, 1 );
                else
                  Rectangle( theEvent.xbutton.x, theEvent.xbutton.y, 1, 1 );
                }
              if( tool==10 ) /** Select **/
                Select( theEvent.xbutton.x, theEvent.xbutton.y );
              if( tool==11 ) /** Paste **/
                if( theEvent.xbutton.button==1 )
                  Paste( theEvent.xbutton.x, theEvent.xbutton.y );
                else
                  PasteTheFinalFight();
              }
            else
              {
              result = Mesg("Cannot unite here!", "Only in Master.", "Sorry" );
              if( result&2 )
                {
                Refresh( Cur_Image );
                DrawPanel();
                }
              }
            break;

          case MotionNotify:
            /*printf("A mouse cursor was moved. %d %d  %d\n",
                   theEvent.xmotion.x, theEvent.xmotion.y,
                   theEvent.xmotion.state );*/
            if( tool==1 ) /* mode doesn't matter because it is handled later */
            {
              if( theEvent.xmotion.state==256 )
                WorkStyle( theEvent.xmotion.x, theEvent.xmotion.y-MARGIN, 2 );
              else
                WorkStyle( theEvent.xmotion.x, theEvent.xmotion.y-MARGIN, 1 );
            }
            break;

          case KeyPress:
            if( tool==10 || tool==11 ) 
              if( theEvent.xkey.keycode!=25 && theEvent.xkey.keycode!=27 && theEvent.xkey.keycode!=23 )
                {
                SetTool( old_tool );
                if( tool==10 ) DestroyThatBox();
                if( tool==11 ) DestroyPasteBox();
                }
            printf("The keyboard button was pressed. %d\n",theEvent.xkey.keycode);
            if( theEvent.xkey.keycode==46 ) HandleMenuEvent( 0, 0 ); /*Pict*/
            if( theEvent.xkey.keycode==39 ) HandleMenuEvent( 0, 1 );
            if( theEvent.xkey.keycode==38 ) HandleMenuEvent( 0, 2 );
            if( theEvent.xkey.keycode==24 ) HandleMenuEvent( 0, 3 );
            if( theEvent.xkey.keycode==67 ) HandleMenuEvent( 2, 0 ); /*Img*/
            if( theEvent.xkey.keycode==68 ) HandleMenuEvent( 2, 1 );
            if( theEvent.xkey.keycode==69 ) HandleMenuEvent( 2, 2 );
            if( theEvent.xkey.keycode==10 ) HandleMenuEvent( 3, 3 ); /*Mode*/
            if( theEvent.xkey.keycode==11 ) HandleMenuEvent( 3, 4 );
            if( theEvent.xkey.keycode==12 ) HandleMenuEvent( 3, 5 );
            if( theEvent.xkey.keycode==13 ) HandleMenuEvent( 3, 6 );
            if( theEvent.xkey.keycode==14 ) HandleMenuEvent( 3, 7 );
            if( theEvent.xkey.keycode==23 ) HandleMenuEvent( 4, 8 ); /*Region */
            if( theEvent.xkey.keycode==25 ) HandleMenuEvent( 6, 14 ); /*Othr*/
            if( theEvent.xkey.keycode==27 ) HandleMenuEvent( 6, 15 );
            if( theEvent.xkey.keycode==36 )
              {
              /*CopyImageXToImageY( &One_Image[1], &One_Image[3], 3 );*/
              }
            if( theEvent.xkey.keycode==98 || theEvent.xkey.keycode==100 ||
                theEvent.xkey.keycode==102 || theEvent.xkey.keycode==104 )
              {    
              if( theEvent.xkey.keycode==100 ) offs_X[Cur_Image]-=1;
              if( theEvent.xkey.keycode==102 ) offs_X[Cur_Image]+=1;
              if( theEvent.xkey.keycode==98 ) offs_Y[Cur_Image]-=1;
              if( theEvent.xkey.keycode==104 ) offs_Y[Cur_Image]+=1;
              Refresh( Cur_Image );
              }
            break;

          case ConfigureNotify:
            XGetWindowAttributes(theDisplay, theWindow, &attr );
            /*printf("The window configuration has been changed\n");*/
            break;
        }
    }
}

MakeImage( nro )
unsigned char nro;
{
  int x, y, i;

  if( xi_data[nro] )
    {
    free( xi_data[nro] );
    xi_data[nro]=NULL;
    }

  xi_data[nro] = (char *)malloc( One_Image[nro].width * One_Image[nro].height );
  if( !xi_data[nro] )
    Quit("Can NOT mallocate enought memory for block data\n");

  for( i=0; i<( One_Image[nro].width * One_Image[nro].height ); i++ )
    xi_data[nro][i]=0;

  image_xi[nro] = XCreateImage(theDisplay, DefaultVisual(theDisplay, theScreen), 8,
                            ZPixmap, 0, xi_data[nro], One_Image[nro].width, 
                            One_Image[nro].height, 8, One_Image[nro].width);
  if( image_xi[nro]==NULL )
    printf("null\n");

  for( y=0; y<One_Image[nro].height; y++ )
    for( x=0; x<One_Image[nro].width; x++ )
      {
      if( One_Image[nro].Colour_Map_Size>0 )
        XPutPixel(image_xi[nro],x,y,colormap[One_Image[nro].data.map_lines[y][x]]);
      else      
        XPutPixel(image_xi[nro],x,y,colormap[
          (int)(One_Image[nro].data.rgb_lines[y].red[x]/42.5)*36
          +(int)(One_Image[nro].data.rgb_lines[y].green[x]/42.5)*6
          +(int)(One_Image[nro].data.rgb_lines[y].blue[x]/42.5)]);
      }
}

Refresh( nro )
char nro;
{
  int y=0;

  if( nro<1 || nro>3 )
    Quit("Cannot refresh\n");

  if( offs_Y[nro]<0 )
    y=-offs_Y[nro];
  XPutImage(theDisplay, theWindow, theGC, image_xi[nro], 0, y, offs_X[nro], offs_Y[nro]+y+MARGIN, 
                One_Image[nro].width, One_Image[nro].height );

  if( ThatBox.in )
    {
    XSetForeground( theDisplay, theGC, theBlackPixel );
    XDrawRectangle( theDisplay, theWindow, theGC, ThatBox.x, ThatBox.y,
                    ThatBox.width, ThatBox.height );
    }
  if( PasteBox.in )
    {
    XSetForeground( theDisplay, theGC, theBlackPixel );
    XDrawRectangle( theDisplay, theWindow, theGC, PasteBox.x, PasteBox.y,
                    PasteBox.width, PasteBox.height );
    }
}

/* Super refresh function clears whole window before drawing image. */
Super_Refresh( nro )
char nro;
{
  XClearWindow( theDisplay, theWindow );

  Refresh( nro );

  DrawPanel();
}
  
Close()
{
  printf("err\n");
  Quit("quit");
}

BuildColormap( Image )
struct Image_Struct *Image;
{
  XColor          tmp;
  register unsigned short r, g, b, i;
  Colormap        cmap;

  /* We will make the Colormap here. */

  /* First we will try to use DefaultColormap. */
  cmap = DefaultColormap(theDisplay, theScreen);

  if( Image->Colour_Map_Size>0 ) /* Colormap case */
    {
    for( i=0; i<Image->Colour_Map_Size; i++ )
      {
      tmp.red = Image->Colour_Map[i].Red << 8;               
      tmp.green = Image->Colour_Map[i].Green << 8;               
      tmp.blue = Image->Colour_Map[i].Blue << 8;               
      tmp.flags = DoRed | DoGreen | DoBlue;
      if( !XAllocColor(theDisplay, cmap, &tmp) )
        goto try_own;
      colormap[i] = tmp.pixel;
      }
      printf("Colormap, DefaultColormap\n");
      return;
    }
  else /* If true-color (standard 6*6*6 map) */
    {
    i = 0;
    for( r = 0; r < 6; r++) {
      for( g = 0; g < 6; g++) {
         for( b = 0; b < 6; b++, i++) {
            tmp.red = (r * 36) << 8;
            tmp.green = (g * 36) << 8;
            tmp.blue = (b * 36) << 8;
            tmp.flags = DoRed | DoGreen | DoBlue;
            if( !XAllocColor(theDisplay, cmap, &tmp) )
              goto try_own;
            colormap[i] = tmp.pixel;
            }
         }
      }
    printf("True-color, DefaultColormap\n");
    return;
    }

  try_own:
  /* We will try to create our own Colormap. */
  cmap = XCreateColormap(theDisplay, theWindow, DefaultVisual(theDisplay, 
                         theScreen), AllocNone );
  XSetWindowColormap(theDisplay, theWindow, cmap );

  if( Image->Colour_Map_Size>0 ) /* Colourmap case */
    {
    for( i=0; i<Image->Colour_Map_Size; i++ )
      {
      tmp.red = Image->Colour_Map[i].Red << 8;
      tmp.green = Image->Colour_Map[i].Green << 8;
      tmp.blue = Image->Colour_Map[i].Blue << 8;
      tmp.flags = DoRed | DoGreen | DoBlue;
      if( !XAllocColor(theDisplay, cmap, &tmp) )
        goto end_up;
      colormap[i] = tmp.pixel;
      }
      printf("Colourmap, OwnColormap\n");
      return;
    }
  else /* If true-color (standard 6*6*6 map) */
    {
    i = 0;
    for( r = 0; r < 6; r++) {
      for( g = 0; g < 6; g++) {
         for( b = 0; b < 6; b++, i++) {
            tmp.red = (r * 36) << 8;
            tmp.green = (g * 36) << 8;
            tmp.blue = (b * 36) << 8;
            tmp.flags = DoRed | DoGreen | DoBlue;
            if( !XAllocColor(theDisplay, cmap, &tmp))
              goto end_up;
            colormap[i] = tmp.pixel;
            }
         }
      }
    printf("True-color, OwnColormap\n");
    return;
    }

end_up:                       /* couldn't get what we wanted.  Boo-hoo. */
  Quit("Cannot create colormap.\n");
}
