/** This contains all the IPC routines for use by both the client
  and server 
  IPC2.c is an InterNet version

  Steve Franks		Sony Computer Science Lab
  March 92
**/



#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <stdio.h>
#include <fcntl.h>

#include <string.h>
#define SERVER_PORT	(IPPORT_USERRESERVED + 124)

#include "IPC.h"
#include <errno.h>



/*extern void bzero(void *,int); */

/*** setup_server_IPC -- setup the interprocess communication stuff ***/
int setup_server_IPC()
{
    
    int		sock,msgsock;
    struct sockaddr_un server;
    char 	buf[1024];
    char	com[50];
    
   
    int length;
    struct sockaddr_in sin;
    
    /* create a socket */
    sock = socket (AF_INET,SOCK_STREAM,0);
    if (sock < 0) {
	perror("Error opening socket");
	exit(1);
    }
    
    
    /* initialize socket address structure */
    
    bzero((void *) &sin, (sizeof(sin)));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(SERVER_PORT);
    sin.sin_addr.s_addr = INADDR_ANY;
    
    /* bind socket data structure to this socket */
    
    if (bind (sock,&sin,sizeof(sin))) {
	perror("Error binding socket");
	close(sock);
	exit(1);
    }
    
    /* prepare socket queue for connection requests and accept
       connections */
    
    listen(sock,5);
    
    length = sizeof(sin);
    msgsock = accept(sock, &sin, &length);
    if (msgsock < 0) {
	perror("accept");
	close(sock);
	exit(1);
    }
    
    printf("Connection from host %s, port %u\n",
	   inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
    fflush(stdout);
    
    close(sock);
    
    
    printf("Returning Socket #%d \n",msgsock);
    return(msgsock);
    
}	




/*** setup_client_IPC -- client IPC initialization ***/
int setup_client_IPC()
{
    
    

    int sock;
    char *hostname;
    struct hostent *hp;
    struct sockaddr_in sin;
    int length;
    
    
    hostname = "asura";
    
    /* create a socket */
    sock = socket (AF_INET,SOCK_STREAM,0);
    if (sock < 0) {
	perror("Error opening socket");
	exit(1);
    }
    
    
    /* initialize socket address structure */
    bzero((char *) &sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(SERVER_PORT);
    
    hp = gethostbyname(hostname);
    if (hp == NULL) {
	herror(hostname);
	exit(1);
    }
    bcopy (hp->h_addr, &(sin.sin_addr.s_addr), hp->h_length);
    
    /* connect to remote host */
    /* change to a do while (but cut and paste is so quick :) */
    while (connect(sock,&sin,sizeof(sin)) < 0) {
	perror("Can't connect to server");
	printf("Please Make Renderer INET Connection Available 1st\n");
	sleep(2);
	close(sock);
	/* re-initialize socket address structure */
	
	sock = socket (AF_INET,SOCK_STREAM,0);
	if (sock < 0) {
	    perror("Error opening socket");
	    exit(1);
	}
	bzero((char *) &sin, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(SERVER_PORT);
    
	hp = gethostbyname(hostname);
	if (hp == NULL) {
	    herror(hostname);
	    exit(1);
	}
	bcopy (hp->h_addr, &(sin.sin_addr.s_addr), hp->h_length);
    }

    printf("Connection established\n");
    fflush(stdout);
    return(sock);
}	



/*** close_server_IPC() - server closes and cleans up the socket ***/
void close_server_IPC()
{


}


#ifndef STANDALONE

/*** send_data_packet -- put data over a Unix domain socket ***/
void send_data_packet(int skt,packet_format *buff, int buff_siz)
{

    if (write(skt,buff,buff_siz) < 0) {
	perror("Client: Write on INET Socket");
    }


}



/*** receive_data_packet - receive data on a Unix socket ***/
int receive_data_packet(int skt,packet_format *buff, int buff_siz)
{

    int		cc,flags;

    bzero(buff,buff_siz);
    cc= read(skt,buff,buff_siz);
    if (cc==-1) {
	perror("Reading From  Port");
    }
    return(cc);

}


#else
/*** send_data_packet -- put data over a Unix domain socket ***/
void send_data_packet(int skt,packet_format *buff, int buff_siz)
{

    if (fwrite(buff,buff_siz,1,(FILE *)skt) < 0) {
	perror("Client: Write on Disk File");
    }


}



/*** receive_data_packet - receive data on a Unix socket ***/
int receive_data_packet(int skt,packet_format *buff, int buff_siz)
{

    int		cc,flags;

    bzero(buff,buff_siz);
    cc= fread(buff,buff_siz,1,(FILE *)skt);
    if (cc==-1) {
	perror("Reading From  Disk File");
    }
    return(cc);

}
#endif


/*** print_data_packet - debugging routine to peek a at packets ***/
void print_data_packet(packet_format *d)
{
    int		i;

    printf("\n");
    
    for (i=0;i<3; i++) {
	printf("%5.4f\t",d->param[i]);
    }
    printf("\n");
}





/*** open_disk_write - Open a disk file to send the data packets to ***/
FILE *open_disk_write(char *file)
{

    FILE *fp;
    char *temp;

    /* This just checks if its in the file name, assume nobody will
      put this in the middle of the file name  */
     
    printf("FILE - [%s] \n",file);
    temp= strstr("scrpt",file);
    printf("%s %d \n",temp,(int)temp);

    if (temp==NULL)
      strcat(file,".scrpt");

    fp = fopen(file,"w");
    if ((int)fp<0) {
	perror("ERROR OPENING FILE for Script Data");
	exit(-1);
    }

    return(fp);
}





/*** open_disk - Open a disk file to send the data packets to ***/
FILE *open_disk_read(char *file)
{

    FILE *fp;

    fp = fopen(file,"r");
    if ((int)fp<0) {
	perror("ERROR OPENING FILE for Script Data for reading");
	exit(-1);
    }

    return(fp);
}



