/* face[] is an array of floats, float[0] has # in array */
/******
  
  pull.c : 	Has all the facial deformation routines,
  3-Dimensional muscle pulls, sheet muscles (pull1d) sphincter which
  is hardwired for the mouth, jaw rotation and lip movement.

  Soon I will change this from checking to see if each point is
  in the muscles range at run-time to binding a list of points
  to which a muscles is attached and only moving those. This will
  mnake it much faster and (I think) a little more realistic since
  real muscles are bound. It will also (I think?) make the order of
  muscle application irrelevant.


This "single layer" facial animation model is basically a rewrite of
a old program of Keith Waters which he gave to Carol Wang at Univeristy
of Calgary.

This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/
#include <forms.h>
#include "standard.h"
#include "muscles.h"
#include <math.h>
#include "proto.h"






/* Three Dimensional Pull Routine based on Waters model/code */
/* stevef@csl.sony.co.jp */
/*** pull3d() ***/
void pull3d(float *face, struct muscle musc, float factor)
      
{
    float               cos_ang;
    float               px, py, pz, dif;
    float               newy, newx, newz, newv, percent, value;
    float               toll;
    float 		theta,theta2;
    unsigned int	npnts,ipt;
    float		muscle_range;
    float		dist_x,dist_y,dist_z, dist_tot;
    float		mend_x,mend_y,mend_z;
    register int	i;

    theta = cos((double)musc.theta / 57.1000);
    theta2 = 1.0 -theta;
    toll = 20.0;
    
    npnts = face[0];		/* Number of unique points in face */
    ipt = -2;

    /* Pull out so pca can parallelize */
    muscle_range  = musc.fall_end - musc.fall_strt;
    mend_x = musc.end[0];
    mend_y = musc.end[1];
    mend_z = musc.end[2];

/* Make this for loop parallel ! */
    
    for (i = 0; i < npnts; i++) {
	ipt+=3;
	px = face[ipt];
	py = face[ipt + 1];
	pz = face[ipt + 2];
	
	/* distance from point to end of muscle (end = point the muscle is
	   anchored in the bone..ie. the points move toward the end */
/*	if (px > toll) {
	    printf("WARNING: px>toll, this should never happen ? \n");
	}
*/
	dist_x = px - mend_x;
	dist_y = py - mend_y;
	dist_z = pz - mend_z; 

	dist_tot = fsqrt(SQR(dist_x)+SQR(dist_y)+SQR(dist_z)); 
	
	if ( dist_tot <= musc.fall_end && dist_tot >0)  {
	    cos_ang = ((musc.lenx*dist_x)+(musc.leny*dist_y) +
	      (musc.lenz * dist_z))/(musc.legth * dist_tot);
	  	     


	    if (cos_ang >= theta) {
		
		/* This point is in the muscles range of influence */
		value = factor * (cos_ang - theta) / theta2;
		
		if ((dist_tot >= musc.fall_strt) && 
		    (dist_tot <= musc.fall_end)) {
		       dif = dist_tot - musc.fall_strt;
		       percent = dif / ( musc.fall_strt-
					musc.fall_end); 
		       newv = cos((double)((percent * 90.0) / 57.1));
		       newx = ((dist_x * (value * 0.9)) * newv);
		       newy = ((dist_y * (value * 0.9)) * newv);
		       newz = ((dist_z * (value * 0.9)) * newv);
		} else {
		    newx = dist_x * (value * 0.5);
		    newy = dist_y * (value * 0.5);
		    newz = dist_z * (value * 0.5);
		}
		face[ipt]     = px - newx;
		face[ipt + 1] = py - newy;
		face[ipt + 2] = pz - newz;
	    }
	}
    } /* for loop */

  }

#define NEW_CAROL
#ifdef CAROLS_FRONTALIS
/* I think this is Carol's new method - not so good, maybe raise the
   position of the Frontalis so works *above* the eyebrow */
/*** pull1d - a sheet muscle pull based on waters LINEAR_PULL routine ***/
void pull1d(float *face, struct muscle musc,  float factor)
{
  
    double cosang;
    double sinang;
    double constan,percent,newv;
    double dist1,dist2;
    double	sign;
    double falldist;
    double 	distx,disty,distz;
    double	lngth;
    int		i,ipt;
    int  npnts;
    
  
    falldist = 8.0;    
    factor = (factor-0.5) *10;
    ipt = -2;
    npnts = (int)face[0];
    
    printf("Doing Carols PULL!!!! \n\n");
    printf("Factor = %5.3f\n",factor);
   
    /* loop on ipt to save some time */
    for (i=0; i<npnts; i++) { 
	ipt += 3;
	
	distx = face[ipt]   - musc.end[0];
	disty = face[ipt+1] - musc.end[1];
	distz = face[ipt+2] - musc.end[2];
	
	lngth = sqrt(SQR(distx)+SQR(disty)+SQR(distz)); 
	cosang = (musc.lenx * distx)+(musc.leny * disty)+
	  (musc.lenz * distz)/ (musc.legth*lngth);
	
	sinang = sqrt(1. -cosang*cosang);
	
	dist1  = lngth*sinang;	/* length of muscle */
	if(dist1 < falldist)
	  {
	      dist2 = lngth * cosang;
	      constan = dist2/musc.legth;
	      if(constan <= 1.0 && constan >=0.0)
		{
		    percent = dist1/falldist;
		    if (factor>=0)	sign = 1.;
		    else		sign = -1.;
		    newv = cos(percent* 1.57079632679489661923132169164);
		    newv = newv*newv -pow(newv, 2.0+fabs(factor));
/*	newv = cos(percent*1.57079632679489661923132169164)*factor; */
		    
		    
		    /* maybe switch the signes here */
		    face[ipt]    += (musc.lenx * newv);
		    face[ipt + 1]+= (musc.leny * newv);
		    face[ipt + 2]+= (musc.lenz * newv);
		    
		}	
	  }
    }
    
}
    
#endif

#ifdef NEW_CAROL


/*** pull1d - a sheet muscle pull based on waters LINEAR_PULL routine ***/
void pull1d(float *face, struct muscle musc,  float factor)
{
    
   
    float               dist1, dist2;
    float		falldist;
    unsigned int        ipt, npnts;
    float		distx,disty,distz,lngth;
    float		ftemp,cosang,percent;
    float		theta;
    register int	i;


    /* hmmm...to include the point muscle attached to ? */
    /* we change the 3D coordinates of muscle head and tail ?? */

    theta = musc.theta * 0.0174533;

#define FALLDIST (2.0)

    /*printf("Doing Original  Pull! \n\n ");
      */
    ipt = -2;
    npnts = face[0];
    for (i=0; i<npnts; i++) { 
	ipt += 3;

	/* Now only 1D muscles are in the forehead */
	/*if (face[ipt+1]<=0.0)
	  break;
*/
	distx = face[ipt]   - musc.end[0];
	disty = face[ipt+1] - musc.end[1];
	distz = face[ipt+2] - musc.end[2];
	
	lngth = fsqrt(SQR(distx)+SQR(disty)+SQR(distz)); 
	cosang = (musc.lenx * distx)+(musc.leny * disty)+
		   (musc.lenz * distz);

        cosang = cosang / (musc.legth*lngth);

	
	if (cosang < theta) {
	    dist1 = lngth * fsqrt(1.0 - cosang * cosang);
	    if (dist1 < FALLDIST) {
		dist2 = lngth * cosang;
		ftemp = dist2 / musc.legth;
		if (ftemp <= 1.0 && ftemp >=0) { 
		    ftemp = fcos((percent * theta)) * factor;
		    face[ipt] 	 += (musc.lenx * ftemp);
		    face[ipt + 1]+= (musc.leny * ftemp);
		    face[ipt + 2]+= (musc.lenz * ftemp);
		}
	    }
	}
    }

}

 
#endif


#ifdef USE_OLD
/* The default is to use this old version from OPEN_HOUSE */

/*** pull1d - a sheet muscle pull based on waters LINEAR_PULL routine ***/
void pull1d(float *face, int m_num,  float factor)
{
    
   
    float               dist1, dist2;
    float               falldist;
    int                 ipt, i, npnts;
    float               distx,disty,distz,lngth;
    float               ftemp,cosang,percent;
    float               theta;

        /* hmmm...to include the point muscle attached to ? */
    /* we change the 3D coordinates of muscle head and tail ?? */
/*
    ty += 0.10;         
    tx += 0.01;                 
    tz += 0.01;
    hx += 0.01;
    hy += 0.01;
    hz += 0.01;
    These are incorporated into the muscle structure in muscles.c
 */
    theta = musc[m_num].theta * 0.0174533;
    falldist = 2.0;
/*
    printf("Pulling Sheet Muscle #%d  - %5.4f\n",m_num,factor);
    printf("End of Frontalis: %5.4f %5.4f %5.4f \n",
           musc[m_num].end[0],musc[m_num].end[1],musc[m_num].end[2]);
  
    printf("Start of Frontalis: %5.4f %5.4f %5.4f \n",
           musc[m_num].start[0],musc[m_num].start[1],musc[m_num].start[2]);
    printf("theta = %5.4f\n",theta);
    printf("falldist = %5.4f \n",falldist);
    printf("factor = %5.4f \n",factor);
*/ 
   ipt = -2;
    npnts = face[0];
    for (i=0; i<npnts; i++) { 
        ipt += 3;
        
        distx = face[ipt]   - musc[m_num].end[0];
        disty = face[ipt+1] - musc[m_num].end[1];
        distz = face[ipt+2] - musc[m_num].end[2];
        
        lngth = fsqrt(SQR(distx)+SQR(disty)+SQR(distz)); 
/*printf("DIST: %5.4f  %5.4f %5.4f %5.4f \n",distx,disty,distz,lngth);
/* */
        
          cosang = (musc[m_num].lenx * distx)+(musc[m_num].leny * disty)+
                   (musc[m_num].lenz * distz);
/* printf("MUSC: %5.4f %5.4f %5.4f %5.4f \n",musc[m_num].lenx,musc[m_num].leny,
       musc[m_num].lenz,musc[m_num].legth); /* */

        cosang = cosang / (musc[m_num].legth*lngth);

        
        if (cosang < theta) {
            dist1 = lngth * fsqrt(1.0 - cosang * cosang);
            if (dist1 < falldist) {
                dist2 = lngth * cosang;
                ftemp = dist2 / musc[m_num].legth;
                if (ftemp <= 1.0 && ftemp >= 0.0) {  /* must always be >0! */
                  /*  printf("Cosang = %5.4f \n",cosang); 
                    printf("dist1 = %5.4f \n",dist1);
                    printf("dist2= %5.4f \n",dist2);
                    printf("ftemp= %5.4f \n",ftemp);
                    percent = dist1 / falldist;
                    */
                    ftemp = fcos((percent * theta)) * factor;
                   /* printf("ftemp= %5.4f \n",ftemp); */
                    /*if (ftemp <0)     ftemp= fabs(ftemp); */
                    face[ipt]    += (musc[m_num].lenx * ftemp);
                    face[ipt + 1]+= (musc[m_num].leny * ftemp);
                    face[ipt + 2]+= (musc[m_num].lenz * ftemp);
                }
            }
        }
    }

}

#endif 




/*** sphincter() - based on Carol Wang's routine ***/
void sphincter(float *face,struct sphinctor *mouth)
{
    
    /* Normally the cx,cy is (0.0,-2.0)
       The range (fall_rad) is multiplied by 2 (0..2) and is a parameter
       The squeeze amount (ms)is 0 - .225 (parameter)
       The pout (Lip_Z) is the amount to push the lip foward and is
       multiplied by 5.0

       */
       
      
    int		i,npnts,ipt;
    float	dist,ftemp,ftemp2;
    float	cx,cy,pout,range,squeeze;


#define C  (1.5*1.5)
#define OVAL_X	(1.5)	/* sphinctor muscle oval instead of circular */
#define OVAL_Y	1.0

    cx = mouth->cx;
    cy = mouth->cy;
    pout = mouth->pout;
    range = mouth->range;
    squeeze = mouth->val;

    if (squeeze==0)	return;

/*
    printf("Spincter Parameters: \n");
    printf("Center = (%5.3f, %5.3f)  \t LipZ = %5.3f\n",cx,cy,pout);
    printf("Range = %5.3f \t Squeeze = %5.3f\n",range,squeeze);
*/
    npnts = face[0];
    ipt = -2;
    for (i=0;i<npnts; i++) { 	/* For now loop thru all points */
	ipt+=3;
	dist = SQR(face[ipt] - cx)/OVAL_X/OVAL_X +
	       SQR(face[ipt+1] - cy)/OVAL_Y/OVAL_Y;
	
	if (dist <= range) {
	    ftemp = 1.0 - fsqrt(SQR(face[ipt])+SQR(face[ipt]+2.0)+C);
	    ftemp2= range * squeeze;

	    face[ipt] +=  ((ftemp) /OVAL_X) * face[ipt]    *	ftemp2; 
	    face[ipt+1] += (ftemp-2)/OVAL_Y * (face[ipt+1]-cy)*ftemp2; 
	    /* not sure about parenthesis in ipt+1 !!! */
	    face[ipt+2] += pout/face[ipt+2];
	}
    }
    
}
    




/*** lip_sep() ***/
void lip_sep(float *face,int *llip,int *ulip,float dispy, float dispz)
{
    
    int		i;

    dispy = dispy * 0.4;
    dispz = dispz * 0.3;
    
    if ((dispy==0) && (dispz==0))
      return;
    
  /*** NOTE: Really can do lower lip f-tuck without the upper lip ***/  
    
    /*	printf("LipY = %5.4f \t LipZ = %5.4f \n",dispy,dispz);
     */
    /* Do the lower lip */
    for (i=1;i<=llip[0]; i++) {
	face[llip[i]*3-1] -= dispy;	/* Lower the Y Coord */
	face[llip[i]*3]   += dispz;	/* Lower the Z Coord */
    }
    
    /* Upper Lip */
    for (i=1;i<=ulip[0]; i++) {
	face[ulip[i]*3-1] += dispy;	/* Raise the Y Coord */
	face[ulip[i]*3]   += dispz;	/* Raise the Z Coord */
    }
}







void	rot_jaw(float *face,int*jaw_indx,float theta)
{
    
    /* This is somewhat custom for the Waters face data but...
       all jaw points are rotated by theta except 4 points near the corner of
       the mouth, to make it work with another face must redefine
       the Jaw.indx file (using tools in /Data ) to tell what index
       need to be rotated */

    float	ftemp,ang2,ang3;
    float	cos_ang,sin_ang;
    int		i,y,z;
    
    if (theta ==0)	return; 

    theta = theta *10;
    theta *= 0.01745329252;
    ang2 =  (theta * 0.5);
    ang3 = -(theta * 0.3);
    cos_ang =  fcos(theta);
    sin_ang = fsin(theta);
    
    for (i=0; i<jaw_indx[0]; i++) { 
	y = jaw_indx[i+1]*3-1;		/* double check this */
	z = y+1;
	ftemp = face[y];
	face[y] = (cos_ang * face[y]) + (-sin_ang * face[z]);
	face[z] = (sin_ang * ftemp)  + (	cos_ang * face[z]);
    }


    /** There are a few points that need special attention...
      this are hard wired and may need to be adjusted when the
      facial data is changed.

      **/

   

    /** Upper lip  special cases **/
    i = 181;
    ftemp = face[i*3-1];
    face[i*3-1] = (cos(ang2) * face[i*3-1]) + (-sin(ang2) * face[i*3]);
    face[i*3  ] = (sin(ang2) * ftemp )+	 (cos(ang2) * face[i*3]);
 
    i = 193;
    ftemp = face[i*3-1];
    face[i*3-1] = (cos(ang2) * face[i*3-1]) + (-sin(ang2) * face[i*3]);
    face[i*3  ] = (sin(ang2) * ftemp )+	 (cos(ang2) * face[i*3]);
 
    i = 182;
    ftemp = face[i*3-1];
    face[i*3-1] = (cos(ang2) * face[i*3-1]) + (-sin(ang2) * face[i*3]);
    face[i*3  ] = (sin(ang2) * ftemp )+	 (cos(ang2) * face[i*3]);

    i = 194;
    ftemp = face[i*3-1];
    face[i*3-1] = (cos(ang2) * face[i*3-1]) + (-sin(ang2) * face[i*3]);
    face[i*3  ] = (sin(ang2) * ftemp )+	 (cos(ang2) * face[i*3]);

/* this should be used to raise to lower lip or corner of mouth    
    for (i=87;i<=90; i++) { 
	ftemp = face[i*3-1];
	face[i*3-1] = (cos(ang3) * face[i*3-1]) + (-sin(ang3) * face[i*3]);
	face[i*3  ] = (sin(ang3) * ftemp )+	 (cos(ang3) * face[i*3]);
    }
*/
    /* maybe should make the corners of the mouth go inward too?
     */
    
}















