#ifndef _winman.h_

#define _winman.h_

#include <stdio.h>
#include "actor.h"
#include "debug.h"


#define MAX_BOARDS	10

class Board { // each "board" holds 1 scene with n windows
  public:
    char	scene_title[40];
    int		open;			// boolean flag
    long	scene_id;
    Actor	**obj;
    long	*act_gid;
    long	*act_id;
    char	**act_title;
    int		num_act;
    float	start_x,end_x;
    
    Board(char *,long,int);
    void plot_cursor(float);		// Plot the cursor (or clear);
    void add_actor(char *,long,Actor *);
    void append_scene(Board *);
    void prepend_scene(Board *);
    void get_range(float *,float *);
    void precompute();
    void reset();

    void print_actors();		// debugging routine
};




class Winman {
  public:

    Board	*b[MAX_BOARDS];
    int		num_boards;

    Winman();
    ~Winman();

    void set_curr_board(long i) { curr_board = i; }; 
    long curr_num() { return(curr_board);};
    char *curr_title() { if (curr_board==-1) return("NoActiveBoard");
			 else return(b[curr_board]->scene_title); };

    int  create_board(char*,long,int);   // return internal board #
    void delete_board(long);
    void reset_board(long);
    void show_board(long);
    void hide_board(long);
    void push_board(long);
    int	 pick_board();
    void pop_board(long);
    void redraw_board(long,float=-1);
    void scroll_board(long,float,float);
    void forward_gl_event(long,short,int);

    void precompute(long);		// Setup a board for evaluation
    void register_actor(long,char *,long,Actor *);
    void print_boards();		// debugging routine
    void print_actors(long);
    void plot_cursor(long bid,float x) { b[bid]->plot_cursor(x);};
    void get_range(long ,float *,float *);

  private:
    long	curr_board;
    
};

#endif




























