// This file has the rouintes to handle the FORM2.0 callbacks.

extern "C" {
#include <forms.h>
#include "spline_forms.h"
#include "test_forms.h"
#include "IPC.h"
}


#include <stdio.h>
#include <stream.h>
#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>

#include "debug.h"
#include "muscles.h"
#include "spline_ed.h"
#include "spline_lib.h"


extern packet_format 	data;
extern spline_editor  	*sp[20];
extern int		skt;
extern	winman		*wman;


/*** evaluate_splines_cb ***/
void evaluate_splines_cb(FL_OBJECT *,long)
{
    static	int	cnt=0;
    int		i,frame;
    float	val[20]; 
    
    data.param[I_PUPL]	= 0.50;	// these should be changable
    data.param[I_XDIR]	= 0.50; // "  "
    data.param[I_YDIR]	= 0.50; // "  "
    data.param[I_RAD] 	= 0.68;
    data.param[I_DIST]	= 0.83;
    data.param[I_XPOS]	= 0.71;
    data.param[I_YPOS]	= 0.91;
    data.param[I_ZPOS]	= 0.63;
    data.param[I_ISIZ]	= 0.50;
    
   // for (n=0;n<10;n++)
      for (frame=1; frame<200; frame+=5) {
	  data.id = cnt;
	  
	  
	  for (i=0;i<12; i++) {
	      val[i] = sp[i]->value(frame);
	      if (val[i]>1)
		val[i]= 1.0;
	      else if (val[i]<0)
		val[i]=0.0;
	  }
	  
	  data.param[L_ZYGO] = 		data.param[R_ZYGO] 	=val[0]; 
	  data.param[L_ANGULI] = 	data.param[R_ANGULI] 	=val[1];
	  data.param[IL_FRONT] = 	data.param[IR_FRONT] 	=val[2];
	  data.param[OL_FRONT] = 	data.param[OR_FRONT] 	=val[3];
	  data.param[L_LABI] = 		data.param[R_LABI] 	=val[4];
	  data.param[L_CORR] = 		data.param[R_CORR] 	=val[5];
	  data.param[NASI] 					=val[6];
	  data.param[LAT_CORR]  	 			=val[7];
	  data.param[ML_FRONT] = 	data.param[MR_FRONT] 	=val[8];
	  data.param[JAW]					=val[9];
	  data.param[LIP_Z]					=val[10]; 
	  data.param[LIP_Y]					=val[11]; 
	  
	  send_data_packet(skt,&data,sizeof(packet_format));
	  cnt++;
      }
}

/*** save_scene_cb ***/
void  save_scene_cb(FL_OBJECT *,long)
{
    status("Saving the current scene to disk");
    
    // need to rewrite the spline_lib interface;
    spline_lib *tlib;

    tlib  = new spline_lib("Scenes");
    tlib->set_file();
    tlib->set_frames(1,200);
    tlib->save_scene(wman);
    delete tlib;

}


/*** load_scene_cb ***/
void load_scene_cb(FL_OBJECT *,long)
{
    scene *t1;
    spline_lib	*tlib;
    int		i,id,st;
    // this loads a scene and replaces existing splines with it

    tlib = new spline_lib("Scenes");
    tlib->set_file();
    t1 = tlib->load_scene();
    
    for (i=0;i<t1->num_splines;i++) {
	id = t1->spls[i]->get_id();
	st = sp[id]->replace(t1->spls[i]);
	if (st==-1) {
	    status("Problem Replacing Spline ",sp[id]->get_title());
	}
	sp[id]->redraw();
    }
    
}


/*** append_scene_cb ***/
void append_scene_cb(FL_OBJECT *,long)
{
   
    spline_lib 	*tlib;
    scene	*t1;
    int		i,id,st;

    //this loads in a scene and appends it to the current "script"

    tlib = new spline_lib("Scenes");
    tlib->set_file();
    t1 = tlib->load_scene();
    for (i=0;i<t1->num_splines;i++) {
	id = t1->spls[i]->get_id();
	st = sp[id]->append(t1->spls[i]);
	if (st==-1) {
	    status("Problem Appending  Spline ",sp[id]->get_title());
	}
	sp[id]->redraw();
    }
}
 

/*** prepend_scene_cb ***/
void prepend_scene_cb(FL_OBJECT *,long)
{
   
    spline_lib 	*tlib;
    scene	*t1;
    int		i,id,st;

    //this loads in a scene and prepends it to the current "script"

    tlib = new spline_lib("Scenes");
    tlib->set_file();
    t1 = tlib->load_scene();
    for (i=0;i<t1->num_splines;i++) {
	id = t1->spls[i]->get_id();
	st = sp[id]->prepend(t1->spls[i]);
	if (st==-1) {
	    status("Problem Prepending  Spline ",sp[id]->get_title());
	}
	sp[id]->redraw();
    }
}
    

      

/*** reset_script_cb ***/
void 	reset_script_cb(FL_OBJECT *,long)
{
    // Set all the spline_editors to initial default value

    status("reset callback");
    for (int i=0; i<wman->num_win();i++) {
	sp[i]->cntrl_pts->reset();
	sp[i]->redraw();
    }
}


/*** exit_cb ***/
void	exit_cb(FL_OBJECT *,long)
{
    status("Gracefully Exiting Muscle Control Program");
    close(skt);		// Close the INET socket 
    exit(0);
}

#ifdef YABADABADOO

/*** disp_scroll_cb ***/
void disp_scroll_cb(FL_OBJECT *obj,long val)
{
    static 	int	status= FALSE;

    if (status==TRUE) {
	fl_hide_form();
	status=FALSE;
    }
    else { //status==FALSE
	fl_show_form();
	status==TRUE;
    }
}

#endif

/*** scroll_cb ***/
void scroller_cb(FL_OBJECT *obj,long val)
{
    /* This takes care of alot the scrolling window callbacks */
    double sval;

    switch ( (int) val) {
      case 0:
	// Window Position Slider
	s_val = get_slider_value(dev);
//	winman->scroll_pos(s_val);
	winman->redraw_all();
	
      case 1:
	// Zoom Factor Slider
	s_val =  get_slider_value(dev);
//	winman->set_zoom(s_val);	// 0..1
	winman->redraw_all();

	
    }

}













