/*exampleHDF.c
  Example program to write an HDF file

  Compile 

  cc exampleHDF.c -lm -ldf -o exampleHDF

  Eric Pepke
*/

#include <stdio.h>
#include <math.h>

#define XSIZE 50
#define YSIZE 50
#define ZSIZE 50

/*Define this if you have a newer version of HDF*/
#define NEWHDF

main()
{
    int i, j, k;
    int dimSizes[3];
    float array[XSIZE][YSIZE][ZSIZE];	/*Data array*/
    float xScale[XSIZE];		/*Scales*/
    float yScale[YSIZE];
    float zScale[ZSIZE];
    float min, max;

    /*Fill array*/
    for (i = 0; i < XSIZE; ++i)
    {
	for (j = 0; j < YSIZE; ++j)
	{
	    for (k = 0; k < ZSIZE; ++k)
	    {
		array[i][j][k] =  sin(((double) i) / XSIZE * 6.0)
				+ sin(((double) j) / YSIZE * 8.0)
				+ sin(((double) k) / ZSIZE * 10.0);
	    }
	}
    }
    min = -3.0;
    max = 3.0;

    /*Set up the dimension sizes*/
    dimSizes[0] = XSIZE;
    dimSizes[1] = YSIZE;
    dimSizes[2] = ZSIZE;
    DFSDsetdims(3, dimSizes);

    /*Set up the scales along each dimension.  Here they're regularly 
      spaced, but they could be irregularly spaced.*/
    for (i = 0; i < XSIZE; ++i) xScale[i] = (float) i;
    for (j = 0; j < YSIZE; ++j) yScale[j] = (float) j;
    for (k = 0; k < ZSIZE; ++k) zScale[k] = (float) k;
    DFSDsetdimscale(1, XSIZE, xScale);
    DFSDsetdimscale(2, YSIZE, yScale);
    DFSDsetdimscale(3, ZSIZE, zScale);

    /*Set up the names of the dimensions.  In the current version of
      SciAn, only the axis name and the units are read, and the units are
      ignored unless the coordinate system is polar.*/
    DFSDsetdimstrs(1, "X", "meters", "E10.2");
    DFSDsetdimstrs(2, "Y", "meters", "E10.2");
    DFSDsetdimstrs(3, "Z", "meters", "E10.2");

    /*Set up the dataset information.  In the current version of
      SciAn, only "field" and "cartesian" are read.  Cartesian sets
      up a normal cartesian coordinate system, polar or spherical does
      a Mercator projection*/
    DFSDsetdatastrs("field", "dimensionless", "E10.2", "cartesian");

    /*Set the max and min.*/
    DFSDsetrange(&max, &min); 

    /*Finally, put the data*/
    DFSDputdata("scalartest.hdf", 3, dimSizes, array);
}
