/*ScianErrors.h
  Public routines for ScianErrors.c
*/

/*Errors*/
#define VARNOTFOUND		1	/*Variable is not found*/
#define VARNOTOBJECT		2	/*Variable is not an object*/
#define VARNOTARRAY		3	/*Variable is not an array*/
#define VARBADRANK		4	/*Rank of an array is bad*/
#define VARBADDIM		5	/*A dimension of an array is bad*/
#define VARNOTPICTURE		6	/*Variable is not a picture*/
#define VARNOTINT		7	/*Variable is not an integer*/
#define VARNOTREAL		8	/*Variable is not a real number*/
#define VARNOTPALETTE		10	/*Var is not a palette*/
#define VARNOTLIST		11	/*Var is not a list*/
#define METHODNOTFOUND		14	/*Method is not found*/
#define VARNOTWINDOW		15	/*Var is not a window*/
#define VARNOTSTRING		16	/*Var is not a string*/
#define CREATEFILEERROR		17	/*Error creating a file*/
#define OPENFILEERROR		18	/*Error opening a file*/
#define VARNOTSYMBOL		23	/*Var is not a symbol*/

#define MAXNWARNINGS		10	/*Max # warnings at one time*/

#define WT_CAUTION		1	/*Caution warning, mild*/
#define WT_ERROR		2	/*Error warning, requires action*/
#define WT_SEVERE		3	/*Severe warning, may mean something bad*/

#define CW_NUMBERERROR		1	/*Syntax error in number*/ 
#define CW_NONINTERROR		2	/*Non-integral number*/
#define CW_INFINITYERROR	3	/*Infinite number*/
#define CW_MISSINGERROR		4	/*Missing data number*/
#define CW_NOTPALETTEERROR	5	/*Not a palette*/
#define CW_READDIRERROR		6	/*Tried to read a dir*/
#define CW_FILEFORMATERROR	7	/*File format error*/
#define CW_NOTOGETHERMODIFY	8	/*Can't modify together*/
#define CW_NOSEPARATEMODIFY	9	/*No separate modify*/
#define CW_CANNOTVISFILE	10	/*Cannot visualize a file*/
#define CW_CANNOTVISERROR	11	/*Cannot visualize an object*/
#define CW_LOOKATERROR		12	/*Lookat point same as location*/
#define CW_NOGEOMETRYERROR	13	/*Can't use geometry here*/
#define CW_CANNOTDROPINMAIN	14	/*Cannot drop in main dataset*/
#define CW_SCRSAVEFAILED	15	/*Screen save failed*/
#define CW_OPENERROR		16	/*Open file error*/
#define CW_CHDIRERROR		17	/*Directory open error*/
#define CW_PATHTOOLONGERROR	18	/*Path is too long*/

#ifdef PROTO
void WarnUser(int);
#else
void WarnUser();
#endif

#ifdef PROTO
void OMErr(void);
void Error(char *, int, char *);
void VarError(char *, int, ObjPtr, NameTyp);
FuncTyp GetMethodSurely(char *, ObjPtr, NameTyp);
ObjPtr GetVarSurely(char *, ObjPtr, NameTyp);
ObjPtr GetObjectVar(char *, ObjPtr, NameTyp);
ObjPtr GetListVar(char *, ObjPtr, NameTyp);
ObjPtr GetPictureVar(char *, ObjPtr, NameTyp);
ObjPtr GetWindowVar(char *, ObjPtr, NameTyp);
ObjPtr GetArrayVar(char *, ObjPtr, NameTyp);
ObjPtr GetIntVar(char *, ObjPtr, NameTyp);
ObjPtr GetSymbolVar(char *, ObjPtr, NameTyp);
ObjPtr GetRealVar(char *, ObjPtr, NameTyp);
ObjPtr GetPaletteVar(char *, ObjPtr, NameTyp);
ObjPtr GetStringVar(char *, ObjPtr, NameTyp);
ObjPtr GetFixedArrayVar(char *, ObjPtr, NameTyp, int, ...);
ObjPtr GetTimedVar(ObjPtr, NameTyp);
Bool GetPredicate(ObjPtr, NameTyp);
char *IDName(NameTyp);
Bool IntVarEql(ObjPtr object, NameTyp var, int value);
#else
void OMErr();
void Error();
void VarError();
FuncTyp GetMethodSurely();
ObjPtr GetVarSurely();
ObjPtr GetObjectVar();
ObjPtr GetListVar();
ObjPtr GetPictureVar();
ObjPtr GetWindowVar();
ObjPtr GetArrayVar();
ObjPtr GetIntVar();
ObjPtr GetSymbolVar();
ObjPtr GetRealVar();
ObjPtr GetFixedArrayVar();
ObjPtr GetPaletteVar();
ObjPtr GetStringVar();
ObjPtr GetTimedVar();
Bool GetPredicate();
char *IDName();
Bool IntVarEql();
#endif
