;# $Id: files.pl,v 3.0.1.1 1993/10/16 13:54:55 ram Exp $
;#
;#  Copyright (c) 1991-1993, Raphael Manfredi
;#  
;#  You may redistribute only under the terms of the Artistic Licence,
;#  as specified in the README file that comes with the distribution.
;#  You may reuse parts of this distribution only within the terms of
;#  that same Artistic Licence; a copy of which may be found at the root
;#  of the source tree for dist 3.0.
;#
;# $Log: files.pl,v $
;# Revision 3.0.1.1  1993/10/16  13:54:55  ram
;# patch12: now skip confmagic.h when -M option is used
;#
;# Revision 3.0  1993/08/18  12:10:23  ram
;# Baseline for dist 3.0 netwide release.
;#
;# 
;# These two arrays record the file names of the files which may (or may not)
;# contain shell or C symbols known by metaconfig.
;#  @SHlist records the .SH files
;#  @clist records the C-like files (i.e. .[chyl])
;#
# Extract filenames from manifest
sub extract_filenames {
	print "Extracting filenames (*.[chyl] and *.SH) from $NEWMANI...\n"
		unless $opt_s;
	open(NEWMANI,$NEWMANI) || die "Can't open $NEWMANI.\n";
	local($file);
	while (<NEWMANI>) {
		($file) = split(' ');
		next if $file eq 'config_h.SH';			# skip config_h.SH
		next if $file eq 'Configure';			# also skip Configure
		next if $file eq 'confmagic.h' && $opt_M;
		push(@SHlist,$file) if $file =~ /\.SH$/;
		push(@clist,$file) if $file =~ /\.[chyl]$/;
	}
}

