/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.spelling.SpellChecker;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;

public class SpellingMarkerResolution
implements IMarkerResolution2 {
    private String solution;
    private IDocument document;

    public SpellingMarkerResolution(String str, IDocument doc) {
        this.document = doc;
        this.solution = str;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getLabel() {
        return this.solution;
    }

    public void run(IMarker marker) {
        int charBegin = marker.getAttribute("charStart", -1);
        int charEnd = marker.getAttribute("charEnd", -1);
        String str = this.document.get();
        if (!(charBegin <= 0 || str.length() >= charEnd || Character.isWhitespace(str.charAt(charBegin - 1)) && Character.isWhitespace(str.charAt(charEnd)))) {
            ++charBegin;
            ++charEnd;
            while (str.length() < charEnd && !Character.isWhitespace(str.charAt(charBegin - 1))) {
                ++charBegin;
                ++charEnd;
            }
        }
        try {
            if (this.solution.equals(SpellChecker.SPELL_CHECKER_ADD)) {
                String word = this.document.get(charBegin, charEnd - charBegin);
                SpellChecker.addWordToAspell(word);
            } else if (!this.solution.equals(SpellChecker.SPELL_CHECKER_IGNORE)) {
                this.document.replace(charBegin, charEnd - charBegin, this.solution);
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("Replacing Spelling Marker", e);
        }
        try {
            marker.delete();
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Removing Spelling Marker", e);
        }
    }

    public String getDescription() {
        return TexlipsePlugin.getResourceString("spellCheckerReplaceWithCorrect");
    }

    public Image getImage() {
        return TexlipsePlugin.getImage("replacetext");
    }
}

