/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.actions.TexSelections;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexUncollapseAction
implements IEditorActionDelegate {
    private IEditorPart targetEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    private ITextEditor getTextEditor() {
        if (this.targetEditor instanceof ITextEditor) {
            return (ITextEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    public void run(IAction action) {
        TexSelections selection = new TexSelections(this.getTextEditor());
        int firstOffset = selection.getStartLine().getOffset();
        int lastOffset = selection.getEndLine().getOffset();
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.getTextEditor().getAdapter(ProjectionAnnotationModel.class);
        if (model != null) {
            model.expandAll(firstOffset, lastOffset - firstOffset);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TextSelection) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(this.targetEditor instanceof ITextEditor);
    }
}

