/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.TexSelections;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractTexSelectionChange
implements IEditorActionDelegate {
    private IEditorPart targetEditor;
    private TexSelections selection;
    private String startTag = this.getStartTag();
    private String endTag = this.getEndTag();

    protected AbstractTexSelectionChange() {
    }

    protected String getStartTag() {
        return "\\{";
    }

    protected String getEndTag() {
        return "}";
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void run(IAction action) {
        this.selection = new TexSelections(this.getTextEditor());
        if (this.isSelectionChanged()) {
            this.unchange();
        } else {
            this.change();
        }
    }

    private ITextEditor getTextEditor() {
        if (this.targetEditor instanceof ITextEditor) {
            return (ITextEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    private void change() {
        try {
            int selStart = this.selection.getTextSelection().getOffset();
            String replaceText = String.valueOf(this.startTag) + this.selection.getCompleteSelection() + this.endTag;
            this.selection.getDocument().replace(selStart, this.selection.getSelLength(), replaceText);
            this.getTextEditor().selectAndReveal(selStart, replaceText.length());
        }
        catch (Exception e) {
            TexlipsePlugin.log("Wrapping selection inside " + this.startTag, e);
        }
    }

    private void unchange() {
        try {
            String selected = this.selection.getCompleteSelection();
            int selStart = this.selection.getTextSelection().getOffset();
            String replaceText = selected.substring(this.startTag.length(), selected.length() - this.endTag.length());
            this.selection.getDocument().replace(selStart, this.selection.getSelLength(), replaceText);
            this.getTextEditor().selectAndReveal(selStart, replaceText.length());
        }
        catch (Exception e) {
            TexlipsePlugin.log("Unwrapping selection from " + this.startTag, e);
        }
    }

    private boolean isSelectionChanged() {
        return this.selection.getCompleteSelection().startsWith(this.startTag) && this.selection.getCompleteSelection().endsWith(this.endTag);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TextSelection) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(this.targetEditor instanceof ITextEditor);
    }
}

