%%%%%%%%%%
%
% Tools
%
variable tmp_file = make_tmp_file("");

define exit_hook()
{
    set_buffer_modified_flag(0);
    () = remove(tmp_file);
    return 1;
}

define buffer_as_string()
{
    push_spot();
    bob();
    push_mark();
    eob();
    bufsubstr();
    pop_spot();
    return ();
}

define print_buffer()
{
    message( buffer_as_string );
}

define expect_buffer_content(id, str)
{
    variable b = buffer_as_string();
    if (b == str)
      message("Test $id succeeded"$);
    else
    {
        message("Test $id failed"$);
        message(__tmp(b));
    }
}

%%%%%%%%%%
%
% Setup the file
%
() = find_file(tmp_file);
latex_mode();
() = evalfile("latex_pst", "latex");
variable test_id;

%%%%%%%%%%
%
% Test pst_point_min and pst_point_max
%
define test_mm(id, x1, y1, x2, y2, min_x, min_y, max_x, max_y)
{
    variable stk_depth = _stkdepth();
    variable pnt1 = @Pst_Point_Type, pnt2 = @Pst_Point_Type;
    pnt1.x = x1;
    pnt1.y = y1;
    pnt2.x = x2;
    pnt2.y = y2;

    variable pnt = latex->pst_point_min(pnt1, pnt2);
    if (pnt.x == min_x and pnt.y == min_y)
      message("Test mm$id-min succeeded"$);
    else
      message("Test mm$id-min failed: "$ + string(pnt.x) + "," + string(pnt.y));
    stk_depth -= _stkdepth();
    if (stk_depth != 0)
      message("Test mm$id-min left $stk_depth values on stack"$);

    stk_depth = _stkdepth();
    pnt = latex->pst_point_max(pnt1, pnt2);
    if (pnt.x == max_x and pnt.y == max_y)
      message("Test mm$id-max succeeded"$);
    else
      message("Test mm$id-max failed: "$ + string(pnt.x) + "," + string(pnt.y));
    stk_depth -= _stkdepth();
    if (stk_depth != 0)
      message("Test mm$id-max left $stk_depth values on stack"$);
}

test_id = 0;
++test_id; test_mm(test_id, 1, 1, 1, 1, 1, 1, 1, 1);
++test_id; test_mm(test_id, 1, 0, 0, 1, 0, 0, 1, 1);
++test_id; test_mm(test_id, 0, 0, 0, 1, 0, 0, 0, 1);
++test_id; test_mm(test_id, -10, 0, -20, 1, -20, 0, -10, 1);
++test_id; test_mm(test_id, 10, 10, -20, -1, -20, -1, 10, 10);
++test_id; test_mm(test_id, -1, -1, 5, -2, -1, -2, 5, -1);

%%%%%%%%%%
%
% Test pst_enlarge_pic
%
define test_ep(id, pre, x, y, post)
{
    variable stk_depth = _stkdepth();
    erase_buffer();
    insert("\\begin{pspicture}$pre\n\n\\end{pspicture}\n"$);

    goto_line(2);
    variable pnt = @Pst_Point_Type;
    pnt.x = x;
    pnt.y = y;
    latex->pst_enlarge_pic(pnt);

    expect_buffer_content("ep$id"$,
                          "\\begin{pspicture}$post\n\n\\end{pspicture}\n"$);
    stk_depth -= _stkdepth();
    if (stk_depth != 0)
      message("Test ep$id left $stk_depth values on stack"$);
}

test_id = 0;
++test_id; test_ep(test_id, "", 5, 5, "(5,5)");
++test_id; test_ep(test_id, "", -5, 5, "(-5,0)(0,5)");
++test_id; test_ep(test_id, "", -8.8, -2, "(-8.8,-2)(0,0)");
++test_id; test_ep(test_id, "", 3, -7, "(0,-7)(3,0)");

++test_id; test_ep(test_id, "(10,10)", 3, 7, "(10,10)");
++test_id; test_ep(test_id, "(10,10)", -1, -2, "(-1,-2)(10,10)");
++test_id; test_ep(test_id, "(-1,-1)(10,10)", 5, -2, "(-1,-2)(10,10)");
++test_id; test_ep(test_id, "", 0, 0, "");

%%%%%%%%%%
%
% Test pst_update_pic_size
%
define test_ups(id, inner, exp)
{
    variable stk_depth = _stkdepth();
    erase_buffer();
    insert("\\begin{pspicture}\n$inner\n\\end{pspicture}\n"$);

    goto_line(2);
    latex->pst_update_pic_size();
    expect_buffer_content("ups$id"$,
                       "\\begin{pspicture}$exp\n$inner\n\\end{pspicture}\n"$);
    stk_depth -= _stkdepth();
    if (stk_depth != 0)
      message("Test ups$id left $stk_depth values on stack"$);
}

test_id = 0;
++test_id; test_ups(test_id, "\\psframe(-0.3,-0.2)(5.1,2.2)", "(-0.3,-0.2)(5.1,2.2)");
++test_id; test_ups(test_id, "\\psframe(3.3,0.2)(5.1,2.2)", "(5.1,2.2)");
++test_id; test_ups(test_id, "\\psframe(3.3,0.2)(5.1,2.2)\n\\rput[t](6,1)", "(6,2.2)");
++test_id; test_ups(test_id, "", "");

%%%%%%%%%%
%
% Test pst_update_pic_size
%
define test_mp(id, inner, input, exp)
{
    variable stk_depth = _stkdepth();
    erase_buffer();
    insert("\\begin{pspicture}$inner\n\\end{pspicture}\n"$);

    bob(); () = right(17);
    push_mark();
    eob(); () = up(1); bol();
    buffer_keystring(input + "\n");
    latex->pst_move_points();
    expect_buffer_content("mp$id"$,
                          "\\begin{pspicture}$exp\n\\end{pspicture}\n"$);
    stk_depth -= _stkdepth();
    if (stk_depth != 0)
      message("Test mp$id left $stk_depth values on stack"$);
}

test_id = 0;
++test_id;
test_mp(test_id,
        "(4,4)\n\\psframe(1,1)(2,2)\n\\psdots(0.5,3)\n\\psline(0,0)(3,2)",
        "2",
        "(5,5)\n\\psframe(3,3)(4,4)\n\\psdots(2.5,5)\n\\psline(2,2)(5,4)");
++test_id;
test_mp(test_id,
        "(4,4)\n\\psframe(1,1)(2,2)\n\\psdots(0.5,3)\n\\psline(0,0)(3,2)",
        "(-1,2)",
        "(-1,0)(4,5)\n\\psframe(0,3)(1,4)\n\\psdots(-0.5,5)\n\\psline(-1,2)(2,4)");
++test_id;
test_mp(test_id,
        "(4,4)\n\\psframe(1,1)(2,2)\n\\psdots(0.5,3)\n\\psline(0,0)(3,2)",
        "0",
        "(4,4)\n\\psframe(1,1)(2,2)\n\\psdots(0.5,3)\n\\psline(0,0)(3,2)");
++test_id;
test_mp(test_id,
        "(4,4)\n\\psframe(1,1)(2,2)\n\\psdots(0.5,3)\n\\psline(0,0)(3,2)",
        "(0,0)",
        "(4,4)\n\\psframe(1,1)(2,2)\n\\psdots(0.5,3)\n\\psline(0,0)(3,2)");
++test_id;
test_mp(test_id,
        "(4,4)\n\\psframe(1,1)(2,2)\n\\psdots(0.5,3)\n\\psline(.7,-.3)(3,2)",
        "-3.14",
        "(-2.64,-3.44)(4,4)\n\\psframe(-2.14,-2.14)(-1.14,-1.14)\n\\psdots(-2.64,-0.14)\n\\psline(-2.44,-3.44)(-0.14,-1.14)");
