/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2latex.c                                                    *
 * description: The main program opens and closes files and calls functions.  *
 ******************************************************************************/

/* MC Some advice to the Borland C compiler... */
/*    (Note: This cannot be wrapped in #ifdef __BORLANDC__, unfortunately.) */
#pragma warn -pro                  /* MC Allow calls without prototypes */
#pragma warn -par                  /* MC Don't warn of unused parameters */
#pragma option -ml                 /* MC Use large memory model */
#ifdef __BORLANDC__
extern unsigned _stklen = 0x3000;  /* MC Use large stack */
#endif

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef __BORLANDC__
#include <io.h>
#endif
#include "wp2latex.h"


FILE     *wpd, *tabel, *strip, *latex;
unsigned short num_of_lines_stripfile;
char     *open_com[0x11], *close_com[0x11];

int main(int argc, char *argv[])
{
  int  i;
  char *wpd_fn, *strip_fn, *tabel_fn, *latex_fn, *p, filename[256];

  /* MC putchar(0xc); */

   puts("Word Perfect 5.1 to LaTeX Conversion Program");
   puts("Authors: R. C. Houtepen (c) TUE-Eindhoven and others");
   printf("Version %s (%s)\n\n", versionname, versiondate);

  if (argc < 2) {
    do {
       printf("\n\nWordPerfect-filename : ");
       gets(filename);
    } while ( *filename == '\0' );
    assert ( (wpd_fn = strdup(filename)) != NULL );
  }
  else
    assert ( (wpd_fn = strdup(argv[1]))  != NULL );

  if ( (wpd = CheckOpen(wpd_fn, "r+b")) == NULL ) return 1;

  if ( Wpd_check() ) return 1;

  strcpy(filename, wpd_fn);
  if ( (p = strchr(filename, '.')) == NULL ) {
     p = filename + strlen(filename);
     strcat(filename, ".");
  }
  *(++p) = 0;
  assert ( (strip_fn = calloc(3*(i = strlen(filename)+4), sizeof(char))) != NULL );
  strcat(strcpy(strip_fn, filename), "str");
  strcat(strcpy(tabel_fn = strip_fn + i, filename), "tbl");
  strcat(strcpy(latex_fn = tabel_fn + i, filename), "tex");

  printf("\nLaTeX-filename [%s] : ", latex_fn);
  gets(filename);
  putchar('\n');
  if (*filename != '\0') strcpy(latex_fn, filename);

  Init_commando();

  if ( (strip = CheckOpen(strip_fn, "w"))   == NULL ) return 1;
  if ( (tabel = CheckOpen(tabel_fn, "w+b")) == NULL ) return 1;

  printf("Converting ...\n\n");

  Convert_first_pass();
  fclose(wpd);
  wpd = NULL;
  fclose(strip);
  fclose(tabel);

  if ( (strip = CheckOpen(strip_fn, "r"))   == NULL ) return 1;
  if ( (tabel = CheckOpen(tabel_fn, "r+b")) == NULL ) return 1;
  if ( (latex = CheckOpen(latex_fn, "w"))   == NULL ) return 1;

  Convert_second_pass(wpd_fn);

  fclose(latex);
  fclose(strip);
  fclose(tabel);

/* Delete auxillary files */
#ifndef DEBUG
    unlink(strip_fn);
    unlink(tabel_fn);
#endif

  puts("\nConversion completed.\n");
  puts("Important note: Conversions performed by wp2latex are only partial.");
  puts("Print the resulting document and compare carefully with original.");
  puts("In all but the simplest documents you will have to do further editing.");
  puts("Or you may wish to edit the WordPerfect document to remove unwanted");
  puts("codes (such as Tab, Tab Set), then run it through wp2latex again.");

  free(wpd_fn);
  free(strip_fn);

  return(0);
}
/* End. */
/* ************************************************************************ */
