---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, signe pourcent, symbole pourcent,
              signe pour cent, symbole pour cent, symbole pour mille, fractions
---

# Comment obtenir les symboles pour-cent, pour-mille... ?

Le pour-cent, "%", est un des 
[caractères réservés](/3_composition/texte/symboles/caracteres/caracteres_reserves) 
de LaTeX qui sert à introduire des commentaires. 
Aussi, pour l'obtenir dans un texte, il faut passer par une commande dédiée.

Sans aucune extension particulière, et même en TeX pur, ce caractère s'obtient avec `\%`.

LaTeX fournit deux autres commandes :

- `\textperthousand` pour le pour-mille (‰) ;
- `\textpertenthousand` pour le pour-dix-mille (‱).

Voici un exemple d'utilisation où il convient de noter la présence d'une espace insécable 
entre la valeur et le symbole du pour-cent (avec `~`).


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
Avoir 0,02~\% ou 0,2~\textperthousand{} ou bien encore 2~\textpertenthousand{}
de chance, est-ce si différent ?
\end{document}
```


## Avec l'extension <ctanpkg:siunitx>

L’extension <ctanpkg:siunitx> fournit `\percent`. 
Elle permet de gérer convenablement l'espace entre le nombre et le signe.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{siunitx}

\begin{document}
Avoir \SI{2}{\percent} de chance, est-ce si important ?
\end{document}
```


## Avec l'extension <ctanpkg:wasysym>

L’extension <ctanpkg:wasysym> fournit `\permil`, le pour-mille.

Il faut faire attention au fait que ce symbole a un aspect proche des fontes 
*Computer modern* et ne se marie pas forcément bien avec d'autres fontes.


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{wasysym}

\begin{document}
Avoir 0,02~\% ou 0,2~\permil{} de chance, est-ce si différent ?
\end{document}
```


## Avec l'extension <ctanpkg:textcomp>

:::{warning}
L’extension <ctanpkg:textcomp> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif.
:::

Historiquement, le symbole pour-mille était accessible  par la commande `\textperthousand` 
dès lors que l'extension <ctanpkg:textcomp> était chargée. 
Il en était de même pour le symbole pour-dix-mille `\textpertenthousand`. 
Ces commandes étant désormais accessibles par défaut avec LaTeX, 
l'extension <ctanpkg:textcomp> n'a plus à être utilisée sur ce sujet.