/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;

public final class CharCounter
extends PrimitiveCounter {
    private int size;
    private final int[] counts = new int[65536];

    public void count(char key) {
        if (this.counts[key] == 0) {
            ++this.size;
        }
        char c = key;
        this.counts[c] = this.counts[c] + 1;
    }

    @Override
    public void count(String value) {
        this.count(value.charAt(0));
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    public final class Iterator
    implements java.util.Iterator<Record> {
        private int index;
        private int count;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < CharCounter.this.size;
        }

        @Override
        public Record next() {
            Record entry = new Record();
            entry.count = CharCounter.this.counts[this.index];
            while (entry.count == 0) {
                entry.count = CharCounter.this.counts[++this.index];
            }
            entry.value = (char)this.index++;
            ++this.count;
            return entry;
        }
    }

    public static final class Record
    extends PrimitiveCounter.Record {
        private char value;
        private int count;

        private Record() {
        }

        public char getPrimitive() {
            return this.value;
        }

        @Override
        public String getValue() {
            return Character.toString(this.value);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Character.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            return this.value == ((Record)o).value;
        }
    }
}

