/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.HashNMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.function.DefaultFunctionDescription;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.FunctionCategory;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;

public class DefaultFunctionRegistry
implements FunctionRegistry {
    private static final Logger logger = Logger.getLogger(DefaultFunctionRegistry.class.getName());
    private static final String FUNCTIONS_PREFIX = "org.pentaho.reporting.libraries.formula.functions.";
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final FunctionCategory[] EMPTY_CATEGORIES = new FunctionCategory[0];
    private FunctionCategory[] categories;
    private HashNMap categoryFunctions;
    private HashMap functions;
    private HashMap functionMetaData;
    private HashMap cachedFunctions = new HashMap();

    public DefaultFunctionRegistry() {
        this.categoryFunctions = new HashNMap();
        this.functionMetaData = new HashMap();
        this.functions = new HashMap();
        this.categories = EMPTY_CATEGORIES;
    }

    @Override
    public FunctionCategory[] getCategories() {
        return (FunctionCategory[])this.categories.clone();
    }

    @Override
    public Function[] getFunctions() {
        String[] fnNames = this.getFunctionNames();
        ArrayList<Function> functions = new ArrayList<Function>(fnNames.length);
        for (int i = 0; i < fnNames.length; ++i) {
            String aName = fnNames[i];
            Function function = this.createFunction(aName);
            if (function == null) {
                logger.config("There is no such function: " + aName);
                continue;
            }
            functions.add(function);
        }
        return functions.toArray(new Function[functions.size()]);
    }

    @Override
    public String[] getFunctionNames() {
        return this.functions.keySet().toArray(new String[this.functions.size()]);
    }

    @Override
    public String[] getFunctionNamesByCategory(FunctionCategory category) {
        return (String[])this.categoryFunctions.toArray((Object)category, (Object[])EMPTY_ARRAY);
    }

    @Override
    public Function[] getFunctionsByCategory(FunctionCategory category) {
        String[] fnNames = (String[])this.categoryFunctions.toArray((Object)category, (Object[])EMPTY_ARRAY);
        ArrayList<Function> functions = new ArrayList<Function>(fnNames.length);
        for (int i = 0; i < fnNames.length; ++i) {
            String aName = fnNames[i];
            Function function = this.createFunction(aName);
            if (function == null) continue;
            functions.add(function);
        }
        return functions.toArray(new Function[functions.size()]);
    }

    @Override
    public Function createFunction(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String functionClass = (String)this.functions.get(name.toUpperCase());
        Class cachedClass = (Class)this.cachedFunctions.get(functionClass);
        if (cachedClass != null) {
            try {
                return (Function)cachedClass.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        Function function = (Function)ObjectUtilities.loadAndInstantiate((String)functionClass, DefaultFunctionRegistry.class, Function.class);
        if (function == null) {
            logger.config("There is no such function: " + name);
        } else {
            this.cachedFunctions.put(functionClass, function.getClass());
        }
        return function;
    }

    @Override
    public FunctionDescription getMetaData(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (FunctionDescription)this.functionMetaData.get(name.toUpperCase());
    }

    public void initialize(Configuration configuration) {
        Iterator functionKeys = configuration.findPropertyKeys(FUNCTIONS_PREFIX);
        HashSet<FunctionCategory> categories = new HashSet<FunctionCategory>();
        while (functionKeys.hasNext()) {
            Object fn;
            String className;
            String classKey = (String)functionKeys.next();
            if (!classKey.endsWith(".class") || (className = configuration.getConfigProperty(classKey)).length() == 0 || !((fn = ObjectUtilities.loadAndInstantiate((String)className, DefaultFunctionRegistry.class, Function.class)) instanceof Function)) continue;
            Function function = (Function)fn;
            int endIndex = classKey.length() - 6;
            String descrKey = classKey.substring(0, endIndex) + ".description";
            String descrClassName = configuration.getConfigProperty(descrKey);
            Object descr = ObjectUtilities.loadAndInstantiate((String)descrClassName, DefaultFunctionRegistry.class, FunctionDescription.class);
            FunctionDescription description = !(descr instanceof FunctionDescription) ? new DefaultFunctionDescription(function.getCanonicalName()) : (FunctionDescription)descr;
            FunctionCategory cat = description.getCategory();
            this.categoryFunctions.add((Object)cat, (Object)function.getCanonicalName());
            this.functionMetaData.put(function.getCanonicalName(), description);
            this.functions.put(function.getCanonicalName(), className);
            categories.add(cat);
        }
        this.categories = categories.toArray(new FunctionCategory[categories.size()]);
    }
}

