/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.io.Serializable;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleSheet;

public abstract class StyleRule
implements Serializable,
Cloneable {
    private StyleSheet parentStyle;
    private StyleRule parentRule;
    private boolean readOnly;
    private StyleKeyRegistry styleKeyRegistry;

    protected StyleRule(StyleKeyRegistry styleKeyRegistry) {
        if (styleKeyRegistry == null) {
            throw new NullPointerException();
        }
        this.styleKeyRegistry = styleKeyRegistry;
    }

    protected StyleRule(StyleSheet styleSheet, StyleRule styleRule) {
        this.styleKeyRegistry = styleSheet == null ? StyleKeyRegistry.getRegistry() : styleSheet.getStyleKeyRegistry();
        this.parentStyle = styleSheet;
        this.parentRule = styleRule;
    }

    public StyleKeyRegistry getStyleKeyRegistry() {
        return this.styleKeyRegistry;
    }

    public StyleSheet getParentStyle() {
        return this.parentStyle;
    }

    public StyleRule getParentRule() {
        return this.parentRule;
    }

    protected void setParentStyle(StyleSheet styleSheet) {
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        this.parentStyle = styleSheet;
    }

    protected void setParentRule(StyleRule styleRule) {
        this.parentRule = styleRule;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final void makeReadOnly() {
        this.readOnly = true;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }
}

