typedef struct mpu_cmd {
	unsigned char time_tag;
	unsigned char arg_cnt;
	unsigned char cmd_cont;
	unsigned char cmd_type;
	long mpu_time;
	unsigned char *mpu_cmd;
} MpuCmd;
extern MpuCmd *GetMpuCmd();

typedef	struct	mcmdstr	{
	long	when;		/* absolute time, in MIDI clocks */
	int	len;		/* length of command stored at cmd */
	unsigned char	*cmd;	/* pointer to midi data (no time tag) */
} MCMD;
extern	MCMD	Rt_tcwme;	/* RT_TCWME command */
extern	MCMD	Mpu_nop;	/* MPU_NO_OP command */
extern	MCMD	*getmcmd();	/* read MPU commands */
extern	MCMD	*getmcmdb();	/* getmcmd() with user-supplied buffer */
extern	long	putmcmd();	/* write MPU commands (single stream) */
extern	long	Onow;		/* output clock (single stream) */
extern	long	putmcmds();	/* write MPU commands (multiple stream) */
#define	MAXSID	16		/* max simultaneous output streams */
extern	long	Sonow[MAXSID];	/* output clocks (mult stream) */

#define d define
/* The following definitions taken from the MPU technical reference manual */
#d MPU_DEV_0			"/dev/mpu0"
#d MPU_DEV_1			"/dev/mpu1"
#d MPU_DEV_2			"/dev/mpu2"
#d MPU_DEV_3			"/dev/mpu3"
#d MidiDevice			MPU_DEV_0
#d MPU_CLOCK_PERIOD 		240
#d MPU_DEFAULT_TIME_BASE	120
#d MPU_DEFAULT_TEMPO		(60.0)	/* beats/minute */
#d MPU_TPS(tempo, time_base)	(((time_base)*tempo)/60.0)
#d MPU_DEFAULT_TICS_PER_SEC	MPU_TPS(MPU_DEFAULT_TEMPO,MPU_DEFAULT_TIME_BASE)
#d MPU_STOP_PLAY		0x05
#d MPU_START_PLAY		0x0A
#d MPU_CONTINUE_PLAY		0x0B
#d MPU_STOP_RECORD		0x11
#d MPU_STOP_OVERDUB		0x15
#d MPU_RECORD_STANDBY		0x20
#d MPU_START_RECORD		0x22
#d MPU_START_OVERDUB		0x2A
#d MPU_ALL_NOTE_OFF		0x30	/* turn all notes off */
#d MPU_NO_REAL_TIME		0x32	/* no real time messages to MIDI OUT */
#d MPU_THRU_OFF			0x33	/* disable THRU function */
#d MPU_TIMING_ON		0x34
#d MPU_MODE_MESS_ON		0x35	/* let host see mode msgs */
#d MPU_THRU_ACTIVE_SENSING	0x36	/* ??? */
#d MPU_THRU_EXCLU_ON		0x37	/* allow sysex msgs from MIDI in->out */
#d MPU_COMMON_TO_HOST_ON	0x38	/* let host see system-common msgs */
#d MPU_REAL_TIME_TO_HOST_ON	0x39	/* let host see real-time msgs */
#d MPU_UART_MODE		0x3F	/* simple uart-mode; MPU_RESET ends */
#d MPU_CHAN_REF_TABLE_A		0x40	/* +chan, set table A to control chan */
#d MPU_CHAN_REF_TABLE_B		0x50	/* +chan, set table B to control chan */
#d MPU_CHAN_REF_TABLE_C		0x60	/* +chan, set table C to control chan */
#d MPU_CHAN_REF_TABLE_D		0x70	/* +chan, set table D to control chan */
#d MPU_INT_CLOCK		0x80	/* enable mpu clock; cf C0-C8, E0-E2 */
#d MPU_FSK_CLOCK		0x81	/* sync to FSK TONE @ TAPE IN jack */
#d MPU_MIDI_CLOCK		0x82	/* sync to MIDI clock @ MIDI IN jack */
#d MPU_METRO_NO_ACC		0x83	/* turn mpu metronome on, no accent */
#d MPU_METRO_OFF		0x84	/* turn mpu metronome off */
#d MPU_METRO_ACC		0x85	/* turn mpu metronome on, with accent */
#d MPU_BENDER_OFF		0x86	/* no continuous control msgs to host */
#d MPU_BENDER_ON		0x87	/* enable continuous control msgs */
#d MPU_MIDI_THRU_OFF		0x88	/* disable MPU MIDI IN -> MIDI OUT */
#d MPU_MIDI_THRU_ON		0x89	/* enable MPU MIDI IN -> MIDI OUT */
#d MPU_DATA_STOP_RECORD_OFF	0x8A	/* no MIDI IN -> host while in stop */
#d MPU_DATA_STOP_RECORD_ON	0x8B	/* send MIDI IN -> host while in stop */
#d MPU_SEND_MEASURE_END_OFF	0x8C	/* no TCWME sent while in record */
#d MPU_SEND_MEASURE_END_ON	0x8D	/* send TCWME while in record */
#d MPU_CONDUCTOR_ON		0x8E	/* allow CONDUCTOR cmnds in play mode */
#d MPU_CONDUCTOR_OFF		0x8F	/* no CONDUCTOR cmnds in play mode */
#d MPU_RT_AFFECT_OFF		0x90	/* ignore real-time msgs from MIDI IN */
#d MPU_RT_AFFECT_ON		0x91	/* act on real-time msgs from MIDI IN */
#d MPU_FSK_TO_INT		0x92	/* set tape sync res to int TIMEBASE */
#d MPU_FSK_TO_MIDI		0x93	/* set tape sync res to 24/beat */
#d MPU_CLOCK_TO_HOST_OFF	0x94	/* don't send CLOCK-TO-HOST (0xFD) */
#d MPU_CLOCK_TO_HOST_ON		0x95	/* send 0xFD at rate set with 0xE7 */
#d MPU_EXCLUSIVE_TO_HOST_OFF	0x96	/* no SysExcl from MIDI IN to host */
#d MPU_EXCLUSIVE_TO_HOST_ON	0x97	/* send SysExcl from MIDI IN to host */
#d MPU_CHAN_REF_TABLE_A_OFF	0x98	/* disable channel reference table A */
#d MPU_CHAN_REF_TABLE_A_ON	0x99	/* enable channel reference table A */
#d MPU_CHAN_REF_TABLE_B_OFF	0x9A	/* disable channel reference table B */
#d MPU_CHAN_REF_TABLE_B_ON	0x9B	/* enable channel reference table B */
#d MPU_CHAN_REF_TABLE_C_OFF	0x9C	/* disable channel reference table C */
#d MPU_CHAN_REF_TABLE_C_ON	0x9D	/* enable channel reference table C */
#d MPU_CHAN_REF_TABLE_D_OFF	0x9E	/* disable channel reference table D */
#d MPU_CHAN_REF_TABLE_D_ON	0x9F	/* enable channel reference table D */
#d MPU_REQUEST_PLAY_CTR		0xA0	/* +track num, request play counter */
#d MPU_REQUEST_RECORD_CTR	0xAB	/* request then clear, rec counter */
#d MPU_REQUEST_VERSION		0xAC	/* request MPU version number */
#d MPU_REQUEST_REVISION		0xAD	/* request MPU revision number */
#d MPU_REQUEST_TEMPO		0xAF	/* request MPU tempo setting */
#d MPU_RESET_TEMPO		0xB1	/* reset tempo to 1/1 (== 0xE1 0x40) */
#d MPU_CLEAR_PLAY_COUNTERS	0xB8	/* clear play counters */
#d MPU_CLEAR_PLAY_MAP		0xB9	/* clear play map */
#d MPU_CLEAR_RECORD_CTR		0xBA	/* clear record counter */
#d MPU_TIMEBASE_48		0xC2	/* set timebase to 48 */
#d MPU_TIMEBASE_72		0xC3	/* set timebase to 72 */
#d MPU_TIMEBASE_96		0xC4	/* set timebase to 96 */
#d MPU_TIMEBASE_120		0xC5	/* set timebase to 120 (recommended) */
#d MPU_TIMEBASE_144		0xC6	/* set timebase to 144 */
#d MPU_TIMEBASE_168		0xC7	/* set timebase to 168 */
#d MPU_TIMEBASE_192		0xC8	/* set timebase to 192 */
#d MPU_WANT_TO_SEND_DATA	0xD0	/* +chan, send raw MIDI data */
#d MPU_SEND_SYSTEM_MESSAGE	0xDF	/* send sys (excl or common) msg */
#d MPU_TEMPO			0xE0	/* set beats/minute with next byte */
#d MPU_RELATIVE_TEMPO		0xE1	/* set tempo ratio with next byte */
#d MPU_GRADUATION		0xE2	/* set rate of change with next byte */
#d MPU_MIDI_METRO		0xE4	/* set MIDI clocks/beep (next byte) */
#d MPU_METRO_MEAS		0xE6	/* set beats/measure with next byte */
#d MPU_SET_INT_CLOCK		0xE7	/* set CLOCK_TO_HOST rate (next byte) */
#d MPU_ACTIVE_TRACKS		0xEC	/* en/disable tracks with next byte */
#d MPU_SEND_PLAY_CTR		0xED	/* select tracks with next byte */
#d MPU_CHANNELS_1to8		0xEE	/* en/disable chans 1-8 w/next byte */
#d MPU_CHANNELS_9to16		0xEF	/* en/disable chans 9-16 w/next byte */
#d MPU_TRACK_DATA_REQ		0xF0	/* +track, ready for more play data */
#d MPU_NO_OP			0xF8	/* w time-tag, kill time */
#d MPU_TIMING_OVERFLOW		0xF8	/* w/o time-tag, aka RT_TCIP */
#d MPU_TCIP			0xF8	/* synonym for MPU_TIMING_OVERFLOW */
#d MPU_MEASURE_END		0xF9	/* aka (erroneously) RT_TCWME */
#d MPU_TCWME			0xF9	/* synonym for MPU_MEASURE_END */
#d MPU_COND_DATA_REQ		0xF9	/* ready for conductor data */
#d MPU_DATA_END			0xFC	/* aka (erroneously) RT_TCIS */
#d MPU_ALL_END			0xFC	/* w/o time-tag, all tracks played */
#d MPU_CLOCK_TO_HOST		0xFD	/* w/o time-tag, see 0x95 & 0xE7 */
#d MPU_ACK			0xFE	/* w/o time-tag, command acknowledge */
#d MPU_RESET			0xFF	/* reset MPU to power up condition */
#ifndef Alloc
#define Alloc(x) (x *)malloc(sizeof(x))
#endif
#ifndef loop
#define loop(i,j) for(i=0;i<j;i++)
#endif
#undef d
