/*
**	JULIA -- Musical Julia Sets
**	Make music by iterating complex polynomials
**	psl 3/89
*/
#include	<stdio.h>
#include	<midi.h>

#define	EIGHTH		(MPU_CLOCK_PERIOD >> 2)

typedef	struct	cmplx {
	double	r, i;
} CMPLX;

u_char	Mbuf[4];
int	Mink	= 36;
int	Maxk	= 84;
CMPLX	Incr	= { -1.5, 0.0, };
CMPLX	Zero	= { 0.0, 0.0, };
MCMD	M;

double	cabs(), cdst(), atof();
CMPLX	cadd(), cmul();

main(argc, argv)
char	*argv[];
{
	register int i;
	char *cp;
	double rho;
	CMPLX z, oz;

	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'i':		/* don't adjust key-off */
		    Incr.r = atof(&argv[i][2]);
		    for (cp = &argv[i][2]; *cp && *cp != ','; cp++);
		    if (*cp++ != ',')
			goto syntax;
		    Incr.i = atof(cp);
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s [-i#,#]\n", argv[0]);
		exit(2);
	    }
	}
	M.when = 0;
	M.len = 3;
	M.cmd = Mbuf;
	M.cmd[0] = CH_KEY_ON;
	z = Zero;
	for (;;) {
	    oz = z;
	    z = cadd(cmul(oz, oz), Incr);
	    rho = cabs(z);
	    if (rho > 2.)
		break;
	    play(rho, oz, z);
	}
}

play(rho, oz, z)
double	rho;
CMPLX	oz, z;
{
	int dt, k;

	dt = cdst(oz, z) * EIGHTH;
	k = Maxk - rho * (Maxk - Mink) / 2.;
	M.cmd[1] = k;
	M.cmd[2] = 64;
	putmcmd(stdout, &M);
	M.when += dt > 4? dt : 4;
	M.cmd[2] = 0;
	putmcmd(stdout, &M);
}

double
cdst(a, b)
CMPLX	a, b;
{
	a.r -= b.r;
	a.i -= b.i;
	return(cabs(a));
}

CMPLX
cadd(a, b)
CMPLX	a, b;
{
	CMPLX c;

	c.r = a.r + b.r;
	c.i = a.i + b.i;
	return(c);
}

CMPLX
cmul(a, b)
CMPLX	a, b;
{
	CMPLX c;

	c.r = a.r * b.r - a.i * b.i;
	c.i = a.r * b.i + a.i * b.r;
	return(c);
}
