/*
 * Usenet header definitions (see ARPA Internet RFCs 1036 nee 850 & 822;
 *	for a second opinion, see The Hideous Name by Pike & Weinberger).
 *
 * Headers are parsed and modified and copied in one pass.
 * Nevertheless, the code is in pieces: hdrdefs.c, hdrcommon.c,
 * hdrparse.c, hdrmunge.c.
 */

#include <stdio.h>
#include <sys/types.h>
#include "libc.h"
#include "news.h"
#include "headers.h"
#include "hdrint.h"		/* may define "const" or REALSTDC */
#ifdef REALSTDC
#include <stddef.h>		/* defines offsetof */
#endif				/* REALSTDC */

#ifndef offsetof
#define offsetof(type, mem) ((char *)&((type *)NULL)->mem - (char *)NULL)
#endif

/* required headers */
static const char msgnm[] =	"Message-ID:";	/* rejection of dup.s */
static const char ngsnm[] =	"Newsgroups:";	/* filing, clone for Xref */
static const char pathnm[] =	"Path:";	/* rejection, extend (damn) */
static const char subjnm[] =	"Subject:";	/* for ctl. msgs. */
static const char datenm[] =	"Date:";	/* rejection of stale art.s */
static const char fromnm[] =	"From:";	/* only required; no use */

/* optional headers */
static const char appnm[] =	"Approved:";	/* mod. groups */
static const char ctlnm[] =	"Control:";	/* ctl. msg.; NCMP */
static const char etctlnm[] =	"Also-Control:"; /* hybrid ctl. msg.; NCMP */
static const char expnm[] =	"Expires:";	/* history */
static const char distrnm[] =	"Distribution:";	/* transmission */
static const char sendnm[] =	"Sender:";	/* mod. groups */
static const char xrefnm[] =	"Xref:";	/* to *replace* (damn!)*/

/* obsolete "useful" headers */
static const char artnm[] =	"Article-I.D.:";	/* obs. Message-ID: */

/* obsolete useless headers: delete them all on contact */
static const char datercvnm[] = "Date-Received:";
static const char rcvnm[] =	"Received:";	/* obsolete Date-Received: */
static const char postnm[] =	"Posted:";	/* obsolete Date: */
static const char postversnm[] = "Posting-Version:";
static const char rlyversnm[] = "Relay-Version:";
static const char illobjnm[] = "Illegal-Object:";	/* zmailer bitching */

static const struct hdrdef msghdr = {
	msgnm, STRLEN(msgnm), offsetof(struct headers, h_msgid) };
static const struct hdrdef ngshdr = {
	ngsnm, STRLEN(ngsnm), offsetof(struct headers, h_ngs) };
const struct hdrdef pathhdr = {
	pathnm, STRLEN(pathnm), offsetof(struct headers, h_path) };
static const struct hdrdef subjhdr = {
	subjnm, STRLEN(subjnm), offsetof(struct headers, h_subj) };
static const struct hdrdef datehdr = {
	datenm, STRLEN(datenm), offsetof(struct headers, h_date) };
static const struct hdrdef fromhdr = {
	fromnm, STRLEN(fromnm), offsetof(struct headers, h_from) };

static const struct hdrdef apphdr = {
	appnm, STRLEN(appnm), offsetof(struct headers, h_approved) };
static const struct hdrdef ctlhdr = {				/* NCMP */
	ctlnm, STRLEN(ctlnm), offsetof(struct headers, h_ctlcmd) }; /* NCMP */
static const struct hdrdef etctlhdr = {				/* NCMP */
	etctlnm, STRLEN(etctlnm), offsetof(struct headers, h_etctlcmd) }; /* NCMP */
static const struct hdrdef exphdr = {
	expnm, STRLEN(expnm), offsetof(struct headers, h_expiry) };
static const struct hdrdef distrhdr = {
	distrnm, STRLEN(distrnm), offsetof(struct headers, h_distr) };
static const struct hdrdef sendhdr = {
	sendnm, STRLEN(sendnm), offsetof(struct headers, h_sender) };
const struct hdrdef xrefhdr = { xrefnm, STRLEN(xrefnm), -1 };

static const struct hdrdef arthdr = {
	artnm, STRLEN(artnm), offsetof(struct headers, h_artid) };

static const struct hdrdef datrcvhdr = { datercvnm, STRLEN(datercvnm), -1 };
static const struct hdrdef rcvhdr = { rcvnm, STRLEN(rcvnm), -1 };
static const struct hdrdef psthdr = { postnm, STRLEN(postnm), -1 };
static const struct hdrdef pstvrshdr = { postversnm, STRLEN(postversnm), -1 };
static const struct hdrdef rlyvrshdr = { rlyversnm, STRLEN(rlyversnm), -1 };
static const struct hdrdef illobjhdr = { illobjnm, STRLEN(illobjnm), -1 };

/* these are parsed into a struct headers */

const hdrlist reqdhdrs = {
	&msghdr,
	&ngshdr,
	&pathhdr,		/* modified by hdrmunge.c (emithdr()) */
	&subjhdr,
	&datehdr,
	&fromhdr,
	NULL
};
const hdrlist opthdrs = {
	&arthdr,		/* obsolete */
	&apphdr,
	&ctlhdr,		/* NCMP */
	&etctlhdr,		/* NCMP */
	&distrhdr,
	&exphdr,
	&sendhdr,
	NULL
};

/*
 * the following noxious headers are deleted on contact because neighbours
 * still send them and they are big.  in an ideal world, they wouldn't be
 * sent and thus we wouldn't need to delete them.
 * It is tempting to delete Article-I.D.: too, but it may be too soon for that.
 */
const hdrlist hdrvilest = {
	&xrefhdr,		/* regenerated by fileart() if needed */
	&datrcvhdr,
	&rcvhdr,
	&psthdr,
	&pstvrshdr,
	&rlyvrshdr,
	&illobjhdr,
	NULL,
};

boolean headdebug = NO;

void
hdrdebug(state)
int state;
{
	headdebug = state;
}

void
hdrinit(hdrs)			/* zero all elements of hdrs */
register struct headers *hdrs;
{
	hdrs->h_subj = NULL;
	hdrs->h_ngs = NULL;
	hdrs->h_distr = NULL;
	hdrs->h_ctlcmd = NULL;		/* NCMP */
	hdrs->h_etctlcmd = NULL;	/* NCMP */
	hdrs->h_approved = NULL;
	hdrs->h_msgid = NULL;
	hdrs->h_artid = NULL;
	hdrs->h_expiry = NULL;
	hdrs->h_path = NULL;
	hdrs->h_sender = NULL;
	hdrs->h_from = NULL;
	hdrs->h_date = NULL;
}

void
freeheaders(hdrs)		/* free (assumed) malloced storage */
register struct headers *hdrs;
{
	nnfree(&hdrs->h_subj);
	nnfree(&hdrs->h_ngs);
	nnfree(&hdrs->h_distr);
	nnfree(&hdrs->h_ctlcmd);	/* NCMP */
	nnfree(&hdrs->h_etctlcmd);	/* NCMP */
	nnfree(&hdrs->h_approved);
	nnfree(&hdrs->h_msgid);
	nnfree(&hdrs->h_artid);
	nnfree(&hdrs->h_expiry);
	nnfree(&hdrs->h_path);
	nnfree(&hdrs->h_sender);
	nnfree(&hdrs->h_from);
	nnfree(&hdrs->h_date);
}
