/*
 * gngp - globally match newsgroup pattern and print
 *	like grep, but for newsgroup patterns instead of regular expressions
 */

#include <stdio.h>
#include <string.h>

char *progname;
int debug = 0;

/*
 * if true, match only ng at start of line, followed by whitespace or newline.
 */
int anchored = 0;
int reverse = 0;	/* iff true, reverse argument & file roles */

FILE *efopen();

/*
 * main - parse arguments and handle options
 */
main(argc, argv)
int argc;
char *argv[];
{
	int c, status = 0;
	int errflg = 0;
	FILE *in;
	extern int optind;
	extern char *optarg;

	progname = argv[0];
	while ((c = getopt(argc, argv, "adr")) != EOF)
		switch (c) {
		case 'a':		/* anchored at start of line */
			anchored++;
			break;
		case 'd':
			matchdebug(1);	/* all debugging on */
			debug++;
			break;
		case 'r':	/* reverse roles: ngs in arg., patterns in file */
			reverse++;
			break;
		default:
			errflg++;
			break;
		}
	if (errflg || optind == argc) {
		(void) fprintf(stderr, "usage: %s [-adr] ng_pattern [file...]\n",
			progname);
		exit(2);
	}
	if (optind == argc-1)
		status |= process(argv[optind], stdin, "stdin");
	else {
		int patind = optind;

		for (optind++; optind < argc; optind++) {
			in = efopen(argv[optind], "r");
			status |= process(argv[patind], in, argv[optind]);
			(void) fclose(in);
		}
	}
	exit(status != 0? 0: 1);
}

/*
 * process - process input file
 */
process(pattern, in, inname)
char *pattern;
FILE *in;
char *inname;
{
	int status = 0;
	char line[BUFSIZ];

	while (fgets(line, sizeof line, in) != NULL)
		if (anchored)
			status |= gngp(pattern, line);
		else {
			register char *start;

			for (start = line; *start != '\0'; start++)
				status |= gngp(pattern, start);
		}
	return status;
}

int
gngp(pattern, text)
register char *pattern, *text;
{
	int returned;
	char savewhite;
	char *whitesp;

	if (anchored) {
		whitesp = strpbrk(text, " \t\n");
		if (whitesp != NULL) {
			savewhite = *whitesp;
			*whitesp = '\0';
		}
	}
	returned = (!reverse? ngmatch(pattern, text): ngmatch(text, pattern));
	if (anchored) {
		if (whitesp != NULL)
			*whitesp = savewhite;
	}
	if (returned)
		(void) fputs(text, stdout);
	return returned;
}
