/*
 * canonhdr - canonicalise capitalisation of header keywords
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "news.h"
#include "libc.h"

char *progname;
int debug;

/*
 * main - parse arguments and handle options
 */
main(argc, argv)
int argc;
char *argv[];
{
	int c;
	int errflg = 0;
	extern int optind;
	extern char *optarg;
	extern FILE *efopen();

	progname = argv[0];
	while ((c = getopt(argc, argv, "d")) != EOF)
		switch (c) {
		case 'd':
			++debug;
			break;
		default:
			errflg++;
			break;
		}
	if (errflg) {
		(void) fprintf(stderr, "usage: %s [-d] [file]...\n", progname);
		exit(2);
	}

	if (optind >= argc)
		process(stdin, "stdin");
	else
		for (; optind < argc; optind++)
			if (STREQ(argv[optind], "-"))
				process(stdin, "-");
			else {
				FILE *in = efopen(argv[optind], "r");

				process(in, argv[optind]);
				(void) fclose(in);
			}
	exit(0);
}

/*
 * process - process input file
 */
process(in, inname)
FILE *in;
char *inname;
{
	register char *hdr;
	int ishdr = YES;
	long nolimit = -1;
	static int washdr = YES;

	if (!washdr)
		return;
	while ((hdr = gethdr(in, &nolimit, &ishdr)) != NULL && ishdr) {
		register char *cp;
		static char canonmsgid[] = "Message-Id:";
		static char magicmsgid[] = "Message-ID:";

		/* capitalise initial letter of each word, Message-ID: special */
		for (cp = hdr; *cp != ':' && *cp != '\0'; cp++)
			if (cp == hdr || cp[-1] == '-') {
				if (isascii(*cp) && islower(*cp))
					*cp = toupper(*cp);
			} else
				if (isascii(*cp) && isupper(*cp))
					*cp = tolower(*cp);
		if (STREQN(hdr, canonmsgid, STRLEN(canonmsgid)))
			(void) strncpy(hdr, magicmsgid, STRLEN(magicmsgid));
		(void) fputs(hdr, stdout);
		/* must not free hdr; gethdr will do so automatically */
	}
	if (hdr != NULL)
		free(hdr);
	if (!ishdr)
		washdr = NO;
}
