/*
 * doustat - the heart of spacefor.ustat
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ustat.h>

int debug = 0;
char *progname;

extern void error(), exit();

/*
 - main - parse arguments and handle options
 */
main(argc, argv)
int argc;
char *argv[];
{
	int c;
	int errflg = 0;
	extern int optind;
	extern char *optarg;
	void process();
	extern long atol();
	extern double atof();

	progname = argv[0];

	while ((c = getopt(argc, argv, "d")) != EOF)
		switch (c) {
		case 'd':	/* Debugging. */
			debug++;
			break;
		case '?':
		default:
			errflg++;
			break;
		}
	if (errflg || optind != argc-4 || !num(argv[optind]) ||
						!num(argv[optind+2]) ||
						!num(argv[optind+3])) {
		fprintf(stderr, "usage: %s ", progname);
		fprintf(stderr, "filesize fileonfs wantspace wantinodes\n");
		exit(2);
	}

	process((long)atof(argv[optind]), argv[optind+1],
				atol(argv[optind+2]), atol(argv[optind+3]));
	exit(0);
}

/*
 - num - is a string numeric?
 */
int				/* predicate */
num(s)
char *s;
{
	return(strspn(s, "0123456789.eE+-") == strlen(s));
}

/*
 - process - do the work
 */
void
process(filesize, fileonfs, wantspace, wantinodes)
long filesize;
char *fileonfs;
long wantspace;
long wantinodes;
{
	struct stat silly;
	struct ustat info;
	register long n;
#	define	LOTS	10000
#ifndef USTATBS
#	define	USTATBS	(512)
#endif

	if (stat(fileonfs, &silly) < 0)
		error("cannot do stat(%s)", fileonfs);
	if (ustat(silly.st_dev, &info) < 0)
		error("cannot do ustat(%s)", fileonfs);
	if (debug)
		fprintf(stderr, "bsize %ld, avail %ld, inodes %ld\n",
				USTATBS, info.f_tfree, (long)info.f_tinode);

	n = LOTS;
	if (info.f_tfree <= wantspace)
		n = 0;
	else if (USTATBS > 0 && filesize > 0)
		n = (info.f_tfree - wantspace) / (filesize/USTATBS + 1);

	if (info.f_tinode <= wantinodes)
		n = 0;
	else if (info.f_tinode - wantinodes < n)
		n = info.f_tinode - wantinodes;

	if (n < 0)
		n = 0;
	else if (n > LOTS)
		n = LOTS;	/* to avert 16-bit trouble elsewhere */

	printf("%ld\n", n);
}
